/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Function;
import jscl.mathml.MathML;

public class Comparison
extends Function {
    int operator;
    private static final String[] eass = new String[]{"=", "<=", ">=", "<>", "<", ">", "~"};
    private static final String[] easj = new String[]{"==", "<=", ">=", "!=", "<", ">", "=="};
    private static final String[] easm = new String[]{"=", "\u2264", "\u2265", "\u2260", "<", ">", "\u2248"};
    private static final String[] easo = new String[]{"eq", "le", "ge", "ne", "lt", "gt", "ap"};

    public Comparison(String name, Generic expression1, Generic expression2) {
        super(name, new Generic[]{expression1, expression2});
        for (int i = 0; i < easo.length; ++i) {
            if (name.compareTo(easo[i]) != 0) continue;
            this.operator = i;
        }
    }

    public Generic antiderivative(int n) throws NotIntegrableException {
        throw new NotIntegrableException();
    }

    public Generic derivative(int n) {
        return JSCLInteger.valueOf(0L);
    }

    public Generic evaluate() {
        try {
            return this.compare(this.parameter[0].integerValue(), this.parameter[1].integerValue());
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    public Generic evalelem() {
        return this.expressionValue();
    }

    public Generic evalsimp() {
        return this.expressionValue();
    }

    public Generic evalnum() {
        return this.compare((NumericWrapper)this.parameter[0], (NumericWrapper)this.parameter[1]);
    }

    JSCLInteger compare(JSCLInteger a1, JSCLInteger a2) {
        return JSCLInteger.valueOf(this.compare((Generic)a1, (Generic)a2) ? 1L : 0L);
    }

    NumericWrapper compare(NumericWrapper a1, NumericWrapper a2) {
        return new NumericWrapper(JSCLInteger.valueOf(this.compare((Generic)a1, (Generic)a2) ? 1L : 0L));
    }

    boolean compare(Generic a1, Generic a2) {
        switch (this.operator) {
            case 0: {
                return a1.compareTo(a2) == 0;
            }
            case 1: {
                return a1.compareTo(a2) < 0;
            }
            case 2: {
                return a1.compareTo(a2) > 0;
            }
            case 3: {
                return a1.compareTo(a2) != 0;
            }
            case 4: {
                return a1.compareTo(a2) <= 0;
            }
            case 5: {
                return a1.compareTo(a2) >= 0;
            }
            case 6: {
                return a1.compareTo(a2) == 0;
            }
        }
        return false;
    }

    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava()).append(easj[this.operator]).append(this.parameter[1].toJava());
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        this.parameter[0].toMathML(element, null);
        MathML e1 = element.element("mo");
        e1.appendChild(element.text(easm[this.operator]));
        element.appendChild(e1);
        this.parameter[1].toMathML(element, null);
    }

    protected Variable newinstance() {
        return new Comparison(this.name, null, null);
    }
}

