/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Matrix;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Exp;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.Log;
import jscl.mathml.MathML;

public class Conjugate
extends Function {
    public Conjugate(Generic generic) {
        super("conjugate", new Generic[]{generic});
    }

    public Generic antiderivative(int n) throws NotIntegrableException {
        return Constant.half.multiply(this.evaluate().pow(2));
    }

    public Generic derivative(int n) {
        return JSCLInteger.valueOf(1L);
    }

    public Generic evaluate() {
        try {
            return this.parameter[0].integerValue();
        }
        catch (NotIntegerException notIntegerException) {
            if (this.parameter[0] instanceof Matrix) {
                return ((Matrix)this.parameter[0]).conjugate();
            }
            if (this.parameter[0] instanceof JSCLVector) {
                return ((JSCLVector)this.parameter[0]).conjugate();
            }
            return this.expressionValue();
        }
    }

    public Generic evalelem() {
        try {
            return this.parameter[0].integerValue();
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    public Generic evalsimp() {
        try {
            return this.parameter[0].integerValue();
        }
        catch (NotIntegerException e) {
            if (this.parameter[0].signum() < 0) {
                return new Conjugate(this.parameter[0].negate()).evalsimp().negate();
            }
            if (this.parameter[0].compareTo(Constant.i) == 0) {
                return Constant.i.negate();
            }
            try {
                Variable v = this.parameter[0].variableValue();
                if (v instanceof Conjugate) {
                    Generic[] g = ((Conjugate)v).parameters();
                    return g[0];
                }
                if (v instanceof Exp) {
                    Generic[] g = ((Exp)v).parameters();
                    return new Exp(new Conjugate(g[0]).evalsimp()).evalsimp();
                }
                if (v instanceof Log) {
                    Generic[] g = ((Log)v).parameters();
                    return new Log(new Conjugate(g[0]).evalsimp()).evalsimp();
                }
            }
            catch (NotVariableException e2) {
                Generic[] a = this.parameter[0].sumValue();
                if (a.length > 1) {
                    Generic s = JSCLInteger.valueOf(0L);
                    for (int i = 0; i < a.length; ++i) {
                        s = ((Generic)s).add(new Conjugate(a[i]).evalsimp());
                    }
                    return s;
                }
                Generic[] p = a[0].productValue();
                Generic s = JSCLInteger.valueOf(1L);
                for (int i = 0; i < p.length; ++i) {
                    Power o = p[i].powerValue();
                    s = ((Generic)s).multiply(new Conjugate(o.value()).evalsimp().pow(o.exponent()));
                }
                return s;
            }
            Generic[] n = Frac.separateCoefficient(this.parameter[0]);
            if (n[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || n[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
                return new Conjugate(n[2]).evalsimp().multiply(new Frac(n[0], n[1]).evalsimp());
            }
            return this.expressionValue();
        }
    }

    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).conjugate();
    }

    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".conjugate()");
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            MathML e2 = element.element("mfenced");
            this.bodyToMathML(e2);
            e1.appendChild(e2);
            e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("mover");
        this.parameter[0].toMathML(e1, null);
        MathML e2 = element.element("mo");
        e2.appendChild(element.text("_"));
        e1.appendChild(e2);
        element.appendChild(e1);
    }

    protected Variable newinstance() {
        return new Conjugate(null);
    }
}

