/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.NotIntegrableException;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Function;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public class ImplicitFunction
extends Function {
    protected int[] derivation;
    protected Generic[] subscript;

    public ImplicitFunction(String name, Generic[] parameter, int[] derivation, Generic[] subscript) {
        super(name, parameter);
        this.derivation = derivation;
        this.subscript = subscript;
    }

    public int[] derivation() {
        return this.derivation;
    }

    public Generic[] subscript() {
        return this.subscript;
    }

    public Generic antiderivative(int n) throws NotIntegrableException {
        int[] c = new int[this.derivation.length];
        for (int i = 0; i < c.length; ++i) {
            if (i == n) {
                if (this.derivation[i] > 0) {
                    c[i] = this.derivation[i] - 1;
                    continue;
                }
                throw new NotIntegrableException();
            }
            c[i] = this.derivation[i];
        }
        return new ImplicitFunction(this.name, this.parameter, c, this.subscript).evaluate();
    }

    public Generic derivative(int n) {
        int[] c = new int[this.derivation.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = i == n ? this.derivation[i] + 1 : this.derivation[i];
        }
        return new ImplicitFunction(this.name, this.parameter, c, this.subscript).evaluate();
    }

    public Generic evaluate() {
        return this.expressionValue();
    }

    public Generic evalelem() {
        return this.expressionValue();
    }

    public Generic evalsimp() {
        return this.expressionValue();
    }

    public Generic evalnum() {
        throw new ArithmeticException();
    }

    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        ImplicitFunction v = (ImplicitFunction)variable;
        c = this.name.compareTo(v.name);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        c = ArrayComparator.comparator.compare(this.subscript, v.subscript);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        c = ImplicitFunction.compareDerivation(this.derivation, v.derivation);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return ArrayComparator.comparator.compare(this.parameter, v.parameter);
    }

    static int compareDerivation(int[] c1, int[] c2) {
        int n = c1.length;
        for (int i = n - 1; i >= 0; --i) {
            if (c1[i] < c2[i]) {
                return -1;
            }
            if (c1[i] <= c2[i]) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        int n = 0;
        for (i = 0; i < this.derivation.length; ++i) {
            n += this.derivation[i];
        }
        buffer.append(this.name);
        for (i = 0; i < this.subscript.length; ++i) {
            buffer.append("[").append(this.subscript[i]).append("]");
        }
        if (n != 0) {
            if (this.parameter.length == 1 && n <= 3) {
                buffer.append(Constant.primechars(n));
            } else {
                buffer.append(this.derivationToString());
            }
        }
        buffer.append("(");
        for (i = 0; i < this.parameter.length; ++i) {
            buffer.append(this.parameter[i]).append(i < this.parameter.length - 1 ? ", " : "");
        }
        buffer.append(")");
        return buffer.toString();
    }

    String derivationToString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.derivation.length; ++i) {
            buffer.append(this.derivation[i]).append(i < this.derivation.length - 1 ? ", " : "");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toJava() {
        int i;
        StringBuffer buffer = new StringBuffer();
        int n = 0;
        for (i = 0; i < this.derivation.length; ++i) {
            n += this.derivation[i];
        }
        buffer.append(this.name);
        if (n != 0) {
            if (this.parameter.length == 1 && n <= 3) {
                buffer.append(Constant.underscores(n));
            } else {
                buffer.append(this.derivationToJava());
            }
        }
        buffer.append("(");
        for (i = 0; i < this.parameter.length; ++i) {
            buffer.append(this.parameter[i].toJava()).append(i < this.parameter.length - 1 ? ", " : "");
        }
        buffer.append(")");
        for (i = 0; i < this.subscript.length; ++i) {
            buffer.append("[").append(this.subscript[i].integerValue().intValue()).append("]");
        }
        return buffer.toString();
    }

    String derivationToJava() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.derivation.length; ++i) {
            buffer.append("_").append(this.derivation[i]);
        }
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        MathML e1;
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
        e1 = element.element("mfenced");
        for (int i = 0; i < this.parameter.length; ++i) {
            this.parameter[i].toMathML(e1, null);
        }
        element.appendChild(e1);
    }

    void bodyToMathML(MathML element) {
        int n = 0;
        for (int i = 0; i < this.derivation.length; ++i) {
            n += this.derivation[i];
        }
        if (this.subscript.length == 0) {
            if (n == 0) {
                this.nameToMathML(element);
            } else {
                MathML e1 = element.element("msup");
                this.nameToMathML(e1);
                this.derivationToMathML(e1, n);
                element.appendChild(e1);
            }
        } else if (n == 0) {
            MathML e1 = element.element("msub");
            this.nameToMathML(e1);
            MathML e2 = element.element("mrow");
            for (int i = 0; i < this.subscript.length; ++i) {
                this.subscript[i].toMathML(e2, null);
            }
            e1.appendChild(e2);
            element.appendChild(e1);
        } else {
            MathML e1 = element.element("msubsup");
            this.nameToMathML(e1);
            MathML e2 = element.element("mrow");
            for (int i = 0; i < this.subscript.length; ++i) {
                this.subscript[i].toMathML(e2, null);
            }
            e1.appendChild(e2);
            this.derivationToMathML(e1, n);
            element.appendChild(e1);
        }
    }

    void derivationToMathML(MathML element, int n) {
        if (this.parameter.length == 1 && n <= 3) {
            Constant.primecharsToMathML(element, n);
        } else {
            MathML e1 = element.element("mfenced");
            for (int i = 0; i < this.derivation.length; ++i) {
                MathML e2 = element.element("mn");
                e2.appendChild(element.text(String.valueOf(this.derivation[i])));
                e1.appendChild(e2);
            }
            element.appendChild(e1);
        }
    }

    protected Variable newinstance() {
        return new ImplicitFunction(this.name, new Generic[this.parameter.length], this.derivation, this.subscript);
    }
}

