/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.hyperbolic;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Log;
import jscl.math.function.Trigonometric;
import jscl.math.function.hyperbolic.Acoth;
import jscl.math.function.hyperbolic.Cosh;
import jscl.math.function.hyperbolic.Sinh;

public class Coth
extends Trigonometric {
    public Coth(Generic generic) {
        super("coth", new Generic[]{generic});
    }

    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Log(JSCLInteger.valueOf(4L).multiply(new Sinh(this.parameter[0]).evaluate())).evaluate();
    }

    public Generic derivative(int n) {
        return JSCLInteger.valueOf(1L).subtract(new Coth(this.parameter[0]).evaluate().pow(2));
    }

    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Coth(this.parameter[0].negate()).evaluate().negate();
        }
        return this.expressionValue();
    }

    public Generic evalelem() {
        return new Frac(new Cosh(this.parameter[0]).evalelem(), new Sinh(this.parameter[0]).evalelem()).evalelem();
    }

    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Coth(this.parameter[0].negate()).evaluate().negate();
        }
        try {
            Variable v = this.parameter[0].variableValue();
            if (v instanceof Acoth) {
                Generic[] g = ((Acoth)v).parameters();
                return g[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    public Generic identity(Generic a, Generic b) {
        Generic ta = new Coth(a).evalsimp();
        Generic tb = new Coth(b).evalsimp();
        return new Frac(ta.multiply(tb).add(JSCLInteger.valueOf(1L)), ta.add(tb)).evalsimp();
    }

    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).coth();
    }

    protected Variable newinstance() {
        return new Coth(null);
    }
}

