/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.numeric.Complex;
import jscl.math.numeric.Numeric;

public final class JSCLDouble
extends Numeric {
    double content;

    JSCLDouble(double val) {
        this.content = val;
    }

    public JSCLDouble add(JSCLDouble dble) {
        return new JSCLDouble(this.content + dble.content);
    }

    public Numeric add(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.add((JSCLDouble)numeric);
        }
        return numeric.valueof(this).add(numeric);
    }

    public JSCLDouble subtract(JSCLDouble dble) {
        return new JSCLDouble(this.content - dble.content);
    }

    public Numeric subtract(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.subtract((JSCLDouble)numeric);
        }
        return numeric.valueof(this).subtract(numeric);
    }

    public JSCLDouble multiply(JSCLDouble dble) {
        return new JSCLDouble(this.content * dble.content);
    }

    public Numeric multiply(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.multiply((JSCLDouble)numeric);
        }
        return numeric.multiply(this);
    }

    public JSCLDouble divide(JSCLDouble dble) throws ArithmeticException {
        return new JSCLDouble(this.content / dble.content);
    }

    public Numeric divide(Numeric numeric) throws ArithmeticException {
        if (numeric instanceof JSCLDouble) {
            return this.divide((JSCLDouble)numeric);
        }
        return numeric.valueof(this).divide(numeric);
    }

    public Numeric negate() {
        return new JSCLDouble(-this.content);
    }

    public int signum() {
        return this.content == 0.0 ? 0 : (this.content < 0.0 ? -1 : 1);
    }

    public Numeric log() {
        return new JSCLDouble(Math.log(this.content));
    }

    public Numeric exp() {
        return new JSCLDouble(Math.exp(this.content));
    }

    public Numeric inverse() {
        return new JSCLDouble(1.0 / this.content);
    }

    public Numeric pow(JSCLDouble dble) {
        if (this.signum() < 0) {
            return Complex.valueOf(this.content, 0.0).pow(dble);
        }
        return new JSCLDouble(Math.pow(this.content, dble.content));
    }

    public Numeric pow(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.pow((JSCLDouble)numeric);
        }
        return numeric.valueof(this).pow(numeric);
    }

    public Numeric sqrt() {
        if (this.signum() < 0) {
            return Complex.valueOf(0.0, 1.0).multiply(this.negate().sqrt());
        }
        return new JSCLDouble(Math.sqrt(this.content));
    }

    public Numeric nthrt(int n) {
        if (this.signum() < 0) {
            return n % 2 == 0 ? this.sqrt().nthrt(n / 2) : this.negate().nthrt(n).negate();
        }
        return super.nthrt(n);
    }

    public Numeric conjugate() {
        return this;
    }

    public Numeric acos() {
        return new JSCLDouble(Math.acos(this.content));
    }

    public Numeric asin() {
        return new JSCLDouble(Math.asin(this.content));
    }

    public Numeric atan() {
        return new JSCLDouble(Math.atan(this.content));
    }

    public Numeric cos() {
        return new JSCLDouble(Math.cos(this.content));
    }

    public Numeric sin() {
        return new JSCLDouble(Math.sin(this.content));
    }

    public Numeric tan() {
        return new JSCLDouble(Math.tan(this.content));
    }

    public JSCLDouble valueof(JSCLDouble dble) {
        return new JSCLDouble(dble.content);
    }

    public Numeric valueof(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.valueof((JSCLDouble)numeric);
        }
        throw new ArithmeticException();
    }

    public double doubleValue() {
        return this.content;
    }

    public int compareTo(JSCLDouble dble) {
        if (this.content < dble.content) {
            return -1;
        }
        if (this.content > dble.content) {
            return 1;
        }
        if (this.content == dble.content) {
            return 0;
        }
        throw new ArithmeticException();
    }

    public int compareTo(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.compareTo((JSCLDouble)numeric);
        }
        return numeric.valueof(this).compareTo(numeric);
    }

    public static JSCLDouble valueOf(double val) {
        return new JSCLDouble(val);
    }

    public String toString() {
        return new Double(this.content).toString();
    }
}

