/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.Arithmetic;
import jscl.math.numeric.Complex;
import jscl.math.numeric.JSCLDouble;

public abstract class Numeric
implements Arithmetic,
Comparable {
    public abstract Numeric add(Numeric var1);

    public Numeric subtract(Numeric numeric) {
        return this.add(numeric.negate());
    }

    public abstract Numeric multiply(Numeric var1);

    public abstract Numeric divide(Numeric var1) throws ArithmeticException;

    public Arithmetic add(Arithmetic arithmetic) {
        return this.add((Numeric)arithmetic);
    }

    public Arithmetic subtract(Arithmetic arithmetic) {
        return this.subtract((Numeric)arithmetic);
    }

    public Arithmetic multiply(Arithmetic arithmetic) {
        return this.multiply((Numeric)arithmetic);
    }

    public Arithmetic divide(Arithmetic arithmetic) throws ArithmeticException {
        return this.divide((Numeric)arithmetic);
    }

    public Numeric pow(int exponent) {
        Numeric a = JSCLDouble.valueOf(1.0);
        for (int i = 0; i < exponent; ++i) {
            a = ((Numeric)a).multiply(this);
        }
        return a;
    }

    public Numeric abs() {
        return this.signum() < 0 ? this.negate() : (this.signum() == 0 ? JSCLDouble.valueOf(1.0) : this);
    }

    public abstract Numeric negate();

    public abstract int signum();

    public Numeric sgn() {
        return this.divide(this.abs());
    }

    public abstract Numeric log();

    public abstract Numeric exp();

    public Numeric inverse() {
        return JSCLDouble.valueOf(1.0).divide(this);
    }

    public Numeric pow(Numeric numeric) {
        if (numeric.signum() == 0) {
            return JSCLDouble.valueOf(1.0);
        }
        if (numeric.compareTo(JSCLDouble.valueOf(1.0)) == 0) {
            return this;
        }
        return numeric.multiply(this.log()).exp();
    }

    public Numeric sqrt() {
        return this.nthrt(2);
    }

    public Numeric nthrt(int n) {
        return this.pow(JSCLDouble.valueOf(1.0 / (double)n));
    }

    public static Numeric root(int subscript, Numeric[] parameter) {
        throw new ArithmeticException();
    }

    public abstract Numeric conjugate();

    public Numeric acos() {
        return this.add(JSCLDouble.valueOf(-1.0).add(this.pow(2)).sqrt()).log().multiply(Complex.valueOf(0.0, 1.0));
    }

    public Numeric asin() {
        return this.multiply(Complex.valueOf(0.0, 1.0)).negate().add(JSCLDouble.valueOf(1.0).subtract(this.pow(2)).sqrt()).log().multiply(Complex.valueOf(0.0, 1.0));
    }

    public Numeric atan() {
        return Complex.valueOf(0.0, 1.0).multiply(Complex.valueOf(0.0, 1.0).add(this).divide(Complex.valueOf(0.0, 1.0).subtract(this)).log()).divide(JSCLDouble.valueOf(2.0));
    }

    public Numeric acot() {
        return Complex.valueOf(0.0, 1.0).multiply(Complex.valueOf(0.0, 1.0).add(this).divide(Complex.valueOf(0.0, 1.0).subtract(this)).negate().log()).divide(JSCLDouble.valueOf(2.0));
    }

    public Numeric cos() {
        return JSCLDouble.valueOf(1.0).add(this.multiply(Complex.valueOf(0.0, 1.0)).exp().pow(2)).divide(JSCLDouble.valueOf(2.0).multiply(this.multiply(Complex.valueOf(0.0, 1.0)).exp()));
    }

    public Numeric sin() {
        return Complex.valueOf(0.0, 1.0).subtract(this.multiply(Complex.valueOf(0.0, 1.0)).exp().pow(2).multiply(Complex.valueOf(0.0, 1.0))).divide(JSCLDouble.valueOf(2.0).multiply(this.multiply(Complex.valueOf(0.0, 1.0)).exp()));
    }

    public Numeric tan() {
        return Complex.valueOf(0.0, 1.0).subtract(this.multiply(Complex.valueOf(0.0, 1.0)).exp().pow(2).multiply(Complex.valueOf(0.0, 1.0))).divide(JSCLDouble.valueOf(1.0).add(this.multiply(Complex.valueOf(0.0, 1.0)).exp().pow(2)));
    }

    public Numeric cot() {
        return Complex.valueOf(0.0, 1.0).add(Complex.valueOf(0.0, 1.0).multiply(Complex.valueOf(0.0, 1.0).multiply(this).exp().pow(2))).divide(JSCLDouble.valueOf(1.0).subtract(Complex.valueOf(0.0, 1.0).multiply(this).exp().pow(2))).negate();
    }

    public Numeric acosh() {
        return this.add(JSCLDouble.valueOf(-1.0).add(this.pow(2)).sqrt()).log();
    }

    public Numeric asinh() {
        return this.add(JSCLDouble.valueOf(1.0).add(this.pow(2)).sqrt()).log();
    }

    public Numeric atanh() {
        return JSCLDouble.valueOf(1.0).add(this).divide(JSCLDouble.valueOf(1.0).subtract(this)).log().divide(JSCLDouble.valueOf(2.0));
    }

    public Numeric acoth() {
        return JSCLDouble.valueOf(1.0).add(this).divide(JSCLDouble.valueOf(1.0).subtract(this)).negate().log().divide(JSCLDouble.valueOf(2.0));
    }

    public Numeric cosh() {
        return JSCLDouble.valueOf(1.0).add(this.exp().pow(2)).divide(JSCLDouble.valueOf(2.0).multiply(this.exp()));
    }

    public Numeric sinh() {
        return JSCLDouble.valueOf(1.0).subtract(this.exp().pow(2)).divide(JSCLDouble.valueOf(2.0).multiply(this.exp())).negate();
    }

    public Numeric tanh() {
        return JSCLDouble.valueOf(1.0).subtract(this.exp().pow(2)).divide(JSCLDouble.valueOf(1.0).add(this.exp().pow(2))).negate();
    }

    public Numeric coth() {
        return JSCLDouble.valueOf(1.0).add(this.exp().pow(2)).divide(JSCLDouble.valueOf(1.0).subtract(this.exp().pow(2))).negate();
    }

    public abstract Numeric valueof(Numeric var1);

    public abstract int compareTo(Numeric var1);

    public int compareTo(Object o) {
        return this.compareTo((Numeric)o);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Numeric) {
            return this.compareTo((Numeric)obj) == 0;
        }
        return false;
    }
}

