/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;
import jscl.math.numeric.NumericVector;
import jscl.util.ArrayComparator;

public class NumericMatrix
extends Numeric {
    protected final Numeric[][] element;
    protected final int n;
    protected final int p;

    public NumericMatrix(Numeric[][] element) {
        this.element = element;
        this.n = element.length;
        this.p = element.length > 0 ? element[0].length : 0;
    }

    public Numeric[][] elements() {
        return this.element;
    }

    public NumericMatrix add(NumericMatrix matrix) {
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].add(matrix.element[i][j]);
            }
        }
        return m;
    }

    public Numeric add(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.add((NumericMatrix)numeric);
        }
        return this.add(this.valueof(numeric));
    }

    public NumericMatrix subtract(NumericMatrix matrix) {
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].subtract(matrix.element[i][j]);
            }
        }
        return m;
    }

    public Numeric subtract(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.subtract((NumericMatrix)numeric);
        }
        return this.subtract(this.valueof(numeric));
    }

    public NumericMatrix multiply(NumericMatrix matrix) {
        if (this.p != matrix.n) {
            throw new ArithmeticException();
        }
        NumericMatrix m = this.newinstance(new Numeric[this.n][matrix.p]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < matrix.p; ++j) {
                m.element[i][j] = JSCLDouble.valueOf(0.0);
                for (int k = 0; k < this.p; ++k) {
                    m.element[i][j] = m.element[i][j].add(this.element[i][k].multiply(matrix.element[k][j]));
                }
            }
        }
        return m;
    }

    public Numeric multiply(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.multiply((NumericMatrix)numeric);
        }
        if (numeric instanceof NumericVector) {
            NumericVector v = ((NumericVector)numeric).newinstance(new Numeric[this.n]);
            NumericVector v2 = (NumericVector)numeric;
            if (this.p != v2.n) {
                throw new ArithmeticException();
            }
            for (int i = 0; i < this.n; ++i) {
                v.element[i] = JSCLDouble.valueOf(0.0);
                for (int k = 0; k < this.p; ++k) {
                    v.element[i] = v.element[i].add(this.element[i][k].multiply(v2.element[k]));
                }
            }
            return v;
        }
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].multiply(numeric);
            }
        }
        return m;
    }

    public Numeric divide(Numeric numeric) throws ArithmeticException {
        if (numeric instanceof NumericMatrix) {
            return this.multiply(((NumericMatrix)numeric).inverse());
        }
        if (numeric instanceof NumericVector) {
            throw new ArithmeticException();
        }
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].divide(numeric);
            }
        }
        return m;
    }

    public Numeric negate() {
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].negate();
            }
        }
        return m;
    }

    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                int c = this.element[i][j].signum();
                if (c < 0) {
                    return -1;
                }
                if (c <= 0) continue;
                return 1;
            }
        }
        return 0;
    }

    public Numeric valueof(Numeric numeric) {
        if (numeric instanceof NumericMatrix || numeric instanceof NumericVector) {
            throw new ArithmeticException();
        }
        NumericMatrix m = (NumericMatrix)NumericMatrix.identity(this.n, this.p).multiply(numeric);
        return this.newinstance(m.element);
    }

    public Numeric[] vectors() {
        Numeric[] v = new NumericVector[this.n];
        for (int i = 0; i < this.n; ++i) {
            v[i] = new NumericVector(new Numeric[this.p]);
            for (int j = 0; j < this.p; ++j) {
                ((NumericVector)v[i]).element[j] = this.element[i][j];
            }
        }
        return v;
    }

    public Numeric transpose() {
        NumericMatrix m = this.newinstance(new Numeric[this.p][this.n]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[j][i] = this.element[i][j];
            }
        }
        return m;
    }

    public Numeric trace() {
        Numeric s = JSCLDouble.valueOf(0.0);
        for (int i = 0; i < this.n; ++i) {
            s = ((Numeric)s).add(this.element[i][i]);
        }
        return s;
    }

    public Numeric inverse() {
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                m.element[i][j] = this.inverseElement(i, j);
            }
        }
        return m.transpose().divide(this.determinant());
    }

    Numeric inverseElement(int k, int l) {
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                m.element[i][j] = i == k ? JSCLDouble.valueOf(j == l ? 1.0 : 0.0) : this.element[i][j];
            }
        }
        return m.determinant();
    }

    public Numeric determinant() {
        if (this.n > 1) {
            Numeric a = JSCLDouble.valueOf(0.0);
            for (int i = 0; i < this.n; ++i) {
                if (this.element[i][0].signum() == 0) continue;
                NumericMatrix m = this.newinstance(new Numeric[this.n - 1][this.n - 1]);
                for (int j = 0; j < this.n - 1; ++j) {
                    for (int k = 0; k < this.n - 1; ++k) {
                        m.element[j][k] = this.element[j < i ? j : j + 1][k + 1];
                    }
                }
                a = i % 2 == 0 ? ((Numeric)a).add(this.element[i][0].multiply(m.determinant())) : ((Numeric)a).subtract(this.element[i][0].multiply(m.determinant()));
            }
            return a;
        }
        if (this.n > 0) {
            return this.element[0][0];
        }
        return JSCLDouble.valueOf(0.0);
    }

    public Numeric log() {
        throw new ArithmeticException();
    }

    public Numeric exp() {
        throw new ArithmeticException();
    }

    public Numeric conjugate() {
        NumericMatrix m = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].conjugate();
            }
        }
        return m;
    }

    public int compareTo(NumericMatrix matrix) {
        return ArrayComparator.comparator.compare(this.vectors(), matrix.vectors());
    }

    public int compareTo(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.compareTo((NumericMatrix)numeric);
        }
        return this.compareTo(this.valueof(numeric));
    }

    public static NumericMatrix identity(int dimension) {
        return NumericMatrix.identity(dimension, dimension);
    }

    public static NumericMatrix identity(int n, int p) {
        NumericMatrix m = new NumericMatrix(new Numeric[n][p]);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                m.element[i][j] = i == j ? JSCLDouble.valueOf(1.0) : JSCLDouble.valueOf(0.0);
            }
        }
        return m;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            buffer.append("{");
            for (int j = 0; j < this.p; ++j) {
                buffer.append(this.element[i][j]).append(j < this.p - 1 ? ", " : "");
            }
            buffer.append("}").append(i < this.n - 1 ? ",\n" : "");
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected NumericMatrix newinstance() {
        return this.newinstance(new Numeric[this.n][this.p]);
    }

    protected NumericMatrix newinstance(Numeric[][] element) {
        return new NumericMatrix(element);
    }
}

