/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;
import jscl.math.numeric.NumericMatrix;
import jscl.util.ArrayComparator;

public class NumericVector
extends Numeric {
    protected final Numeric[] element;
    protected final int n;

    public NumericVector(Numeric[] element) {
        this.element = element;
        this.n = element.length;
    }

    public Numeric[] elements() {
        return this.element;
    }

    public NumericVector add(NumericVector vector) {
        NumericVector v = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].add(vector.element[i]);
        }
        return v;
    }

    public Numeric add(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.add((NumericVector)numeric);
        }
        return this.add(this.valueof(numeric));
    }

    public NumericVector subtract(NumericVector vector) {
        NumericVector v = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].subtract(vector.element[i]);
        }
        return v;
    }

    public Numeric subtract(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.subtract((NumericVector)numeric);
        }
        return this.subtract(this.valueof(numeric));
    }

    public Numeric multiply(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.scalarProduct((NumericVector)numeric);
        }
        if (numeric instanceof NumericMatrix) {
            return ((NumericMatrix)numeric).transpose().multiply(this);
        }
        NumericVector v = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].multiply(numeric);
        }
        return v;
    }

    public Numeric divide(Numeric numeric) throws ArithmeticException {
        if (numeric instanceof NumericVector) {
            throw new ArithmeticException();
        }
        if (numeric instanceof NumericMatrix) {
            return this.multiply(((NumericMatrix)numeric).inverse());
        }
        NumericVector v = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].divide(numeric);
        }
        return v;
    }

    public Numeric negate() {
        NumericVector v = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].negate();
        }
        return v;
    }

    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            int c = this.element[i].signum();
            if (c < 0) {
                return -1;
            }
            if (c <= 0) continue;
            return 1;
        }
        return 0;
    }

    public Numeric valueof(Numeric numeric) {
        if (numeric instanceof NumericVector || numeric instanceof NumericMatrix) {
            throw new ArithmeticException();
        }
        NumericVector v = (NumericVector)NumericVector.unity(this.n).multiply(numeric);
        return this.newinstance(v.element);
    }

    public Numeric magnitude2() {
        return this.scalarProduct(this);
    }

    public Numeric scalarProduct(NumericVector vector) {
        Numeric a = JSCLDouble.valueOf(0.0);
        for (int i = 0; i < this.n; ++i) {
            a = ((Numeric)a).add(this.element[i].multiply(vector.element[i]));
        }
        return a;
    }

    public Numeric log() {
        throw new ArithmeticException();
    }

    public Numeric exp() {
        throw new ArithmeticException();
    }

    public Numeric conjugate() {
        NumericVector v = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            v.element[i] = this.element[i].conjugate();
        }
        return v;
    }

    public int compareTo(NumericVector vector) {
        return ArrayComparator.comparator.compare(this.element, vector.element);
    }

    public int compareTo(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.compareTo((NumericVector)numeric);
        }
        return this.compareTo(this.valueof(numeric));
    }

    public static NumericVector unity(int dimension) {
        NumericVector v = new NumericVector(new Numeric[dimension]);
        for (int i = 0; i < v.n; ++i) {
            v.element[i] = i == 0 ? JSCLDouble.valueOf(1.0) : JSCLDouble.valueOf(0.0);
        }
        return v;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            buffer.append(this.element[i]).append(i < this.n - 1 ? ", " : "");
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected NumericVector newinstance() {
        return this.newinstance(new Numeric[this.n]);
    }

    protected NumericVector newinstance(Numeric[] element) {
        return new NumericVector(element);
    }
}

