/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

final class ArrayPolynomial
extends Polynomial {
    Term[] content;
    int size;
    int degree;

    ArrayPolynomial(Monomial monomialFactory, Generic coefFactory) {
        super(monomialFactory, coefFactory);
    }

    ArrayPolynomial(int size, Monomial monomialFactory, Generic coefFactory) {
        this(monomialFactory, coefFactory);
        this.init(size);
    }

    public int size() {
        return this.size;
    }

    void init(int size) {
        this.content = new Term[size];
        this.size = size;
    }

    void resize(int size) {
        int length = this.content.length;
        if (size < length) {
            Term[] content = new Term[size];
            System.arraycopy(this.content, length - size, content, 0, size);
            this.content = content;
            this.size = size;
        }
    }

    public Iterator iterator(boolean direction, Monomial current) {
        return new ContentIterator(direction, current);
    }

    int indexOf(Monomial monomial) {
        int n = Arrays.binarySearch(this.content, new Term(monomial, null));
        return n < 0 ? -n - 1 : n;
    }

    public Polynomial subtract(Polynomial polynomial) {
        Term t2;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomial q = (ArrayPolynomial)polynomial;
        ArrayPolynomial p = this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Term t1 = i1 > 0 ? this.content[--i1] : null;
        Term term = t2 = i2 > 0 ? q.content[--i2] : null;
        while (t1 != null || t2 != null) {
            int c;
            int n = t1 == null ? 1 : (c = t2 == null ? -1 : -this.ordering.compare(t1.monomial(), t2.monomial()));
            if (c < 0) {
                p.content[--i] = t1;
                t1 = i1 > 0 ? this.content[--i1] : null;
                continue;
            }
            if (c > 0) {
                p.content[--i] = t2.negate();
                t2 = i2 > 0 ? q.content[--i2] : null;
                continue;
            }
            Term t = t1.subtract(t2);
            if (t.signum() != 0) {
                p.content[--i] = t;
            }
            t1 = i1 > 0 ? this.content[--i1] : null;
            t2 = i2 > 0 ? q.content[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomial.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Term t2;
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        ArrayPolynomial q = (ArrayPolynomial)polynomial;
        ArrayPolynomial p = this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Term t1 = i1 > 0 ? this.content[--i1] : null;
        Term term = t2 = i2 > 0 ? q.content[--i2].multiply(generic) : null;
        while (t1 != null || t2 != null) {
            int c;
            int n = t1 == null ? 1 : (c = t2 == null ? -1 : -this.ordering.compare(t1.monomial(), t2.monomial()));
            if (c < 0) {
                p.content[--i] = t1;
                t1 = i1 > 0 ? this.content[--i1] : null;
                continue;
            }
            if (c > 0) {
                p.content[--i] = t2.negate();
                t2 = i2 > 0 ? q.content[--i2].multiply(generic) : null;
                continue;
            }
            Term t = t1.subtract(t2);
            if (t.signum() != 0) {
                p.content[--i] = t;
            }
            t1 = i1 > 0 ? this.content[--i1] : null;
            t2 = i2 > 0 ? q.content[--i2].multiply(generic) : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomial.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Term t2;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        ArrayPolynomial q = (ArrayPolynomial)polynomial;
        ArrayPolynomial p = this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Term t1 = i1 > 0 ? this.content[--i1] : null;
        Term term = t2 = i2 > 0 ? q.content[--i2].multiply(monomial, generic) : null;
        while (t1 != null || t2 != null) {
            int c;
            int n = t1 == null ? 1 : (c = t2 == null ? -1 : -this.ordering.compare(t1.monomial(), t2.monomial()));
            if (c < 0) {
                p.content[--i] = t1;
                t1 = i1 > 0 ? this.content[--i1] : null;
                continue;
            }
            if (c > 0) {
                p.content[--i] = t2.negate();
                t2 = i2 > 0 ? q.content[--i2].multiply(monomial, generic) : null;
                continue;
            }
            Term t = t1.subtract(t2);
            if (t.signum() != 0) {
                p.content[--i] = t;
            }
            t1 = i1 > 0 ? this.content[--i1] : null;
            t2 = i2 > 0 ? q.content[--i2].multiply(monomial, generic) : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomial.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar + monomial.degree());
        return p;
    }

    public Polynomial multiply(Polynomial polynomial) {
        Polynomial p = this.valueof(JSCLInteger.valueOf(0L));
        for (int i = 0; i < this.size; ++i) {
            Term t = this.content[i];
            p = p.multiplyAndSubtract(t.monomial(), t.coef().negate(), polynomial);
        }
        return p;
    }

    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomial p = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.content[i] = this.content[i].multiply(generic);
        }
        p.degree = this.degree;
        p.sugar = this.sugar;
        return p;
    }

    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomial p = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.content[i] = this.content[i].multiply(monomial);
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomial p = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.content[i] = this.content[i].divide(generic);
        }
        p.degree = this.degree;
        p.sugar = this.sugar;
        return p;
    }

    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomial p = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.content[i] = this.content[i].divide(monomial);
        }
        p.degree = this.degree - monomial.degree();
        p.sugar = this.sugar - monomial.degree();
        return p;
    }

    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    public Generic gcd() {
        Generic a = this.coefficient(JSCLInteger.valueOf(0L));
        for (int i = this.size - 1; i >= 0; --i) {
            a = a.gcd(this.content[i].coef());
        }
        return a.signum() == this.signum() ? a : a.negate();
    }

    public Monomial monomialGcd() {
        Monomial m = this.monomial(this.tail());
        for (int i = 0; i < this.size; ++i) {
            m = m.gcd(this.content[i].monomial());
        }
        return m;
    }

    public int degree() {
        return this.degree;
    }

    public Polynomial valueof(Polynomial polynomial) {
        ArrayPolynomial p = this.newinstance(0);
        p.init(polynomial);
        return p;
    }

    public Polynomial valueof(Generic generic) {
        ArrayPolynomial p = this.newinstance(0);
        p.init(generic);
        return p;
    }

    public Polynomial valueof(Monomial monomial) {
        ArrayPolynomial p = this.newinstance(0);
        p.init(monomial);
        return p;
    }

    public Polynomial freeze() {
        return this;
    }

    public Term head() {
        return this.size > 0 ? this.content[this.size - 1] : null;
    }

    public Term tail() {
        return this.size > 0 ? this.content[0] : null;
    }

    void init(Polynomial polynomial) {
        ArrayPolynomial q = (ArrayPolynomial)polynomial;
        this.init(q.size);
        System.arraycopy(q.content, 0, this.content, 0, this.size);
        this.degree = q.degree;
        this.sugar = q.sugar;
    }

    void init(Expression expression) {
        TreeMap<Monomial, Generic> map = new TreeMap<Monomial, Generic>(this.ordering);
        int n = expression.size();
        for (int i = 0; i < n; ++i) {
            Generic a;
            Literal l = expression.literal(i);
            JSCLInteger en = expression.coef(i);
            Monomial m = this.monomial(l);
            Generic a2 = this.coefficient((l = l.divide(m.literalValue())).degree() > 0 ? en.multiply(Expression.valueOf(l)) : en);
            Generic a1 = (Generic)map.get(m);
            Generic generic = a = a1 == null ? a2 : a1.add(a2);
            if (a.signum() == 0) {
                map.remove(m);
                continue;
            }
            map.put(m, a);
        }
        this.init(map.size());
        int sugar = 0;
        Iterator it = map.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            Map.Entry e = it.next();
            Monomial m = (Monomial)e.getKey();
            Generic a = (Generic)e.getValue();
            this.content[i] = new Term(m, a);
            sugar = Math.max(sugar, m.degree());
        }
        this.degree = ArrayPolynomial.degree(this);
        this.sugar = sugar;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic a = this.coefficient(generic);
            if (a.signum() != 0) {
                this.init(1);
                this.content[0] = new Term(this.monomial(Literal.valueOf()), a);
            } else {
                this.init(0);
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.init(1);
        this.content[0] = new Term(monomial, this.coefficient(JSCLInteger.valueOf(1L)));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected ArrayPolynomial newinstance(int n) {
        return new ArrayPolynomial(n, this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        int index;

        ContentIterator(boolean direction, Monomial current) {
            this.direction = direction;
            this.index = current == null ? (direction ? ArrayPolynomial.this.size : 0) : ArrayPolynomial.this.indexOf(current);
        }

        public boolean hasNext() {
            return this.direction ? this.index > 0 : this.index < ArrayPolynomial.this.size;
        }

        public Object next() {
            return this.direction ? ArrayPolynomial.this.content[--this.index] : ArrayPolynomial.this.content[this.index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

