/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.math.BigInteger;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ArrayPolynomialInteger
extends ArrayPolynomialGeneric {
    BigInteger[] coef;

    ArrayPolynomialInteger(Monomial monomialFactory) {
        super(monomialFactory, JSCLInteger.factory);
    }

    ArrayPolynomialInteger(int size, Monomial monomialFactory) {
        this(monomialFactory);
        this.init(size);
    }

    void init(int size) {
        this.monomial = new Monomial[size];
        this.coef = new BigInteger[size];
        this.size = size;
    }

    void resize(int size) {
        int length = this.monomial.length;
        if (size < length) {
            Monomial[] monomial = new Monomial[size];
            BigInteger[] coef = new BigInteger[size];
            System.arraycopy(this.monomial, length - size, monomial, 0, size);
            System.arraycopy(this.coef, length - size, coef, 0, size);
            this.monomial = monomial;
            this.coef = coef;
            this.size = size;
        }
    }

    public Polynomial subtract(Polynomial polynomial) {
        Monomial m2;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialInteger q = (ArrayPolynomialInteger)polynomial;
        ArrayPolynomialInteger p = (ArrayPolynomialInteger)this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial = m2 = i2 > 0 ? q.monomial[--i2] : null;
        while (m1 != null || m2 != null) {
            BigInteger a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.coef[i1];
                p.monomial[--i] = m1;
                p.coef[i] = a;
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = q.coef[i2].negate();
                p.monomial[--i] = m2;
                p.coef[i] = a;
                m2 = i2 > 0 ? q.monomial[--i2] : null;
                continue;
            }
            a = this.coef[i1].subtract(q.coef[i2]);
            if (a.signum() != 0) {
                p.monomial[--i] = m1;
                p.coef[i] = a;
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialInteger.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Monomial m2;
        if (generic.signum() == 0) {
            return this;
        }
        BigInteger g = generic.integerValue().content();
        if (g.compareTo(BigInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        ArrayPolynomialInteger q = (ArrayPolynomialInteger)polynomial;
        ArrayPolynomialInteger p = (ArrayPolynomialInteger)this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial = m2 = i2 > 0 ? q.monomial[--i2] : null;
        while (m1 != null || m2 != null) {
            BigInteger a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.coef[i1];
                p.monomial[--i] = m1;
                p.coef[i] = a;
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = q.coef[i2].multiply(g).negate();
                p.monomial[--i] = m2;
                p.coef[i] = a;
                m2 = i2 > 0 ? q.monomial[--i2] : null;
                continue;
            }
            a = this.coef[i1].subtract(q.coef[i2].multiply(g));
            if (a.signum() != 0) {
                p.monomial[--i] = m1;
                p.coef[i] = a;
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialInteger.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Monomial m2;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        BigInteger g = generic.integerValue().content();
        ArrayPolynomialInteger q = (ArrayPolynomialInteger)polynomial;
        ArrayPolynomialInteger p = (ArrayPolynomialInteger)this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial2 = m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
        while (m1 != null || m2 != null) {
            BigInteger a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.coef[i1];
                p.monomial[--i] = m1;
                p.coef[i] = a;
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = q.coef[i2].multiply(g).negate();
                p.monomial[--i] = m2;
                p.coef[i] = a;
                m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
                continue;
            }
            a = this.coef[i1].subtract(q.coef[i2].multiply(g));
            if (a.signum() != 0) {
                p.monomial[--i] = m1;
                p.coef[i] = a;
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialInteger.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar + monomial.degree());
        return p;
    }

    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        BigInteger g = generic.integerValue().content();
        if (g.compareTo(BigInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialInteger p = (ArrayPolynomialInteger)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i];
            p.coef[i] = this.coef[i].multiply(g);
        }
        p.degree = this.degree;
        p.sugar = this.sugar;
        return p;
    }

    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialInteger p = (ArrayPolynomialInteger)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i].multiply(monomial);
            p.coef[i] = this.coef[i];
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    public Polynomial divide(Generic generic) throws ArithmeticException {
        BigInteger g = generic.integerValue().content();
        if (g.compareTo(BigInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialInteger p = (ArrayPolynomialInteger)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i];
            p.coef[i] = this.coef[i].divide(g);
        }
        p.degree = this.degree;
        p.sugar = this.sugar;
        return p;
    }

    public Polynomial gcd(Polynomial polynomial) {
        return this.valueof(this.genericValue().gcd(polynomial.genericValue()));
    }

    public Generic gcd() {
        BigInteger a = BigInteger.valueOf(0L);
        for (int i = this.size - 1; i >= 0 && (a = a.gcd(this.coef[i])).compareTo(BigInteger.valueOf(1L)) != 0; --i) {
        }
        return new JSCLInteger(a.signum() == this.signum() ? a : a.negate());
    }

    protected Generic coefficient(Generic generic) {
        return this.coefFactory.valueof(generic);
    }

    protected Generic getCoef(int n) {
        return new JSCLInteger(this.coef[n]);
    }

    protected void setCoef(int n, Generic generic) {
        this.coef[n] = generic.integerValue().content();
    }

    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialInteger(n, this.monomialFactory);
    }
}

