/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.Generic;
import jscl.math.Rational;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.Monomial;

class ArrayPolynomialRational
extends ArrayPolynomialGeneric {
    Rational[] coef;

    ArrayPolynomialRational(Monomial monomialFactory) {
        super(monomialFactory, Rational.factory);
    }

    ArrayPolynomialRational(int size, Monomial monomialFactory) {
        this(monomialFactory);
        this.init(size);
    }

    void init(int size) {
        this.monomial = new Monomial[size];
        this.coef = new Rational[size];
        this.size = size;
    }

    void resize(int size) {
        int length = this.monomial.length;
        if (size < length) {
            Monomial[] monomial = new Monomial[size];
            Rational[] coef = new Rational[size];
            System.arraycopy(this.monomial, length - size, monomial, 0, size);
            System.arraycopy(this.coef, length - size, coef, 0, size);
            this.monomial = monomial;
            this.coef = coef;
            this.size = size;
        }
    }

    protected Generic coefficient(Generic generic) {
        return this.coefFactory.valueof(generic);
    }

    protected Generic getCoef(int n) {
        return this.coef[n];
    }

    protected void setCoef(int n, Generic generic) {
        this.coef[n] = (Rational)generic;
    }

    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialRational(n, this.monomialFactory);
    }
}

