/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Debug;
import jscl.math.Generic;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.groebner.Block;
import jscl.math.polynomial.groebner.F4;
import jscl.math.polynomial.groebner.Instrumented;
import jscl.math.polynomial.groebner.Natural;
import jscl.math.polynomial.groebner.Pair;
import jscl.math.polynomial.groebner.Sugar;
import jscl.util.ArrayUtils;

public class Standard {
    final int flags;
    final Comparator comparator;
    final Map pairs;
    final List polys = new ArrayList();
    final Map removed = new TreeMap();
    int npairs;
    int npolys;

    Standard(int flags) {
        this.flags = flags;
        this.comparator = (flags & 0x800) > 0 ? Sugar.comparator : Natural.comparator;
        this.pairs = new TreeMap(this.comparator);
    }

    public static Basis compute(Basis basis) {
        return Standard.compute(basis, 0);
    }

    public static Basis compute(Basis basis, int flags) {
        return Standard.compute(basis, flags, (flags & 0x200) > 0);
    }

    static Basis compute(Basis basis, int flags, boolean instrumented) {
        Standard a = instrumented ? new Instrumented(flags) : Standard.algorithm(basis.ordering(), flags);
        a.computeValue(basis);
        basis = basis.valueof(a.elements());
        if (instrumented) {
            return Standard.compute(basis, flags, false);
        }
        return basis;
    }

    static Standard algorithm(Ordering ordering, int flags) {
        switch (flags & 0x180) {
            case 128: {
                return new F4(ordering, flags);
            }
            case 256: {
                return new Block(ordering, flags);
            }
        }
        return new Standard(flags);
    }

    void computeValue(Basis basis) {
        Debug.println(basis);
        this.populate(basis);
        this.npolys = 0;
        this.compute();
        this.remove();
        this.reduce();
        Debug.println("signature = (" + this.npairs + ", " + this.npolys + ", " + this.polys.size() + ")");
    }

    void populate(Basis basis) {
        ArrayList<Polynomial> list = new ArrayList<Polynomial>();
        Generic[] a = basis.elements();
        for (int i = 0; i < a.length; ++i) {
            list.add(basis.polynomial(a[i]));
        }
        this.add(list);
    }

    void add(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Polynomial p = (Polynomial)it.next();
            if (p.signum() == 0) continue;
            this.add(p);
        }
    }

    void compute() {
        Debug.println("compute");
        while (!this.pairs.isEmpty()) {
            Pair pa = (Pair)this.pairs.keySet().iterator().next();
            this.process(pa);
            this.remove(pa);
        }
    }

    void process(Pair pair) {
        if (this.criterion(pair)) {
            return;
        }
        Polynomial p = Standard.reduce(pair, this.polys);
        if (p.signum() != 0) {
            this.add(p);
        }
        ++this.npairs;
    }

    static Polynomial reduce(Pair pair, Collection ideal) {
        Debug.println(pair);
        return Standard.s_polynomial(pair.polynomial[0], pair.polynomial[1]).reduce(ideal, false).normalize().freeze();
    }

    static Polynomial s_polynomial(Polynomial p1, Polynomial p2) {
        Monomial m1 = p1.head().monomial();
        Monomial m2 = p2.head().monomial();
        Monomial m = m1.gcd(m2);
        m1 = m1.divide(m);
        m2 = m2.divide(m);
        return p1.multiply(m2).reduce(p1.head().coef(), m1, p2);
    }

    void remove(Pair pair) {
        this.pairs.remove(pair);
        if (pair.reduction) {
            this.removed.put(pair.principal, null);
        }
    }

    void add(Polynomial polynomial) {
        polynomial.setIndex(this.polys.size());
        Debug.println("(" + polynomial.head().monomial() + ", " + polynomial.index() + ")");
        if ((this.flags & 0x400) > 0) {
            this.makePairsGM(polynomial);
        } else {
            this.makePairs(polynomial);
        }
        this.polys.add(polynomial);
        ++this.npolys;
    }

    boolean criterion(Pair pair) {
        return (this.flags & 0x400) > 0 ? false : this.b_criterion(pair);
    }

    void makePairs(Polynomial polynomial) {
        Iterator it = this.polys.iterator();
        while (it.hasNext()) {
            Polynomial p = (Polynomial)it.next();
            Pair pa = new Pair(p, polynomial);
            if (pa.coprime) continue;
            this.pairs.put(pa, null);
        }
    }

    boolean b_criterion(Pair pair) {
        Iterator it = this.polys.iterator();
        while (it.hasNext()) {
            Polynomial p = (Polynomial)it.next();
            if (!pair.scm.multiple(p.head().monomial())) continue;
            Pair pa1 = new Pair(this.sort(pair.polynomial[0], p));
            Pair pa2 = new Pair(this.sort(pair.polynomial[1], p));
            if (!this.considered(pa1) || !this.considered(pa2)) continue;
            return true;
        }
        return false;
    }

    boolean considered(Pair pair) {
        return !this.pairs.containsKey(pair);
    }

    Polynomial[] sort(Polynomial p1, Polynomial p2) {
        Polynomial[] polynomialArray;
        if (p1.index() < p2.index()) {
            Polynomial[] polynomialArray2 = new Polynomial[2];
            polynomialArray2[0] = p1;
            polynomialArray = polynomialArray2;
            polynomialArray2[1] = p2;
        } else {
            Polynomial[] polynomialArray3 = new Polynomial[2];
            polynomialArray3[0] = p2;
            polynomialArray = polynomialArray3;
            polynomialArray3[1] = p1;
        }
        return polynomialArray;
    }

    void makePairsGM(Polynomial polynomial) {
        Pair pa;
        List<Pair> list = new ArrayList();
        Iterator<Object> it = this.pairs.keySet().iterator();
        while (it.hasNext()) {
            Pair pa2 = (Pair)it.next();
            Pair p1 = new Pair(new Polynomial[]{pa2.polynomial[0], polynomial});
            Pair p2 = new Pair(new Polynomial[]{pa2.polynomial[1], polynomial});
            if (!this.multiple(pa2, p1) || !this.multiple(pa2, p2)) continue;
            list.add(pa2);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Pair pa3 = (Pair)list.get(i);
            this.remove(pa3);
        }
        TreeMap map = new TreeMap((this.flags & 0x800) > 0 && (this.flags & 0x1000) > 0 ? Sugar.comparator : Natural.comparator);
        it = this.polys.iterator();
        while (it.hasNext()) {
            Polynomial p = (Polynomial)it.next();
            pa = new Pair(p, polynomial);
            this.pairs.put(pa, null);
            map.put(pa, null);
        }
        list = ArrayUtils.list(map.keySet());
        n = list.size();
        for (int i = 0; i < n; ++i) {
            pa = (Pair)list.get(i);
            for (int j = i + 1; j < n; ++j) {
                Pair pa2 = (Pair)list.get(j);
                if (!pa2.scm.multiple(pa.scm)) continue;
                this.remove(pa2);
            }
            if (!pa.coprime) continue;
            this.remove(pa);
        }
    }

    boolean multiple(Pair p1, Pair p2) {
        return p1.scm.multiple(p2.scm, true) && ((this.flags & 0x800) <= 0 || (this.flags & 0x1000) <= 0 || Sugar.comparator.compare(p1, p2) > 0);
    }

    void remove() {
        Iterator it = this.polys.iterator();
        while (it.hasNext()) {
            if (!this.removed.containsKey(it.next())) continue;
            it.remove();
        }
    }

    void reduce() {
        Debug.println("reduce");
        TreeMap map = new TreeMap();
        int size = this.polys.size();
        for (int i = 0; i < size; ++i) {
            Polynomial p = (Polynomial)this.polys.get(i);
            p = p.reduce(this.polys, true).normalize().freeze();
            this.polys.set(i, p);
            Debug.println("(" + p.head().monomial() + ")");
            map.put(p, null);
        }
        this.polys.clear();
        this.polys.addAll(map.keySet());
    }

    Generic[] elements() {
        int size = this.polys.size();
        Generic[] a = new Generic[size];
        for (int i = 0; i < size; ++i) {
            a[i] = ((Polynomial)this.polys.get(i)).genericValue();
        }
        return a;
    }
}

