/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.ConnectionDialog;
import dream.gui.ConsoleAction;
import dream.gui.ConsoleControl;
import dream.gui.ConsoleTaskHandler;
import dream.gui.Control;
import dream.gui.DefaultUIConfigurator;
import dream.gui.ExperimentDialog;
import dream.gui.HelpViewer;
import dream.gui.OptionDialog;
import dream.gui.PropertyHelper;
import dream.gui.StartupWindow;
import dream.gui.StatusPrinter;
import dream.gui.WindowStore;
import dream.gui.tasks.Messages;
import dream.gui.tasks.ObjectInfo;
import dream.util.PropertyHandler;
import drm.agentbase.ILogListener;
import drm.agentbase.Logger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class Console
extends JFrame
implements ILogListener,
StatusPrinter {
    private ConsoleControl control = null;
    private Console console = this;
    public Image dreamIcon = null;
    public WindowStore windowStore = new WindowStore();
    public ConsoleTaskHandler taskHandler = null;
    private boolean enabled = true;
    public ConnectAction connectAction = null;
    public OptionAction optionAction = null;
    public StartExperimentAction startExpAction = null;
    public ConnectDialogAction connectModAction = null;
    private static int MIN_SIZE_X = 300;
    private static int MIN_SIZE_Y = 250;
    private static int TOOLBAR_GAP = 3;
    private JPanel toolPanel;
    private JToolBar jToolBar2;
    private JScrollPane jScrollPane1;
    private JMenuItem serventSearchItem;
    private JMenu fileMenu;
    private JSplitPane jSplitPane2;
    private JLabel statusLabel;
    private JMenuItem experimentSearchItem;
    private JMenuItem jMenuItem5;
    private JMenuItem exitMenuItem;
    private JSplitPane jSplitPane1;
    private JPanel jPanel2;
    private JMenuItem aboutItem;
    private JMenuItem jMenuItem4;
    private JMenuItem componentSearchItem;
    private JMenuItem machineSearchItem;
    private JMenuItem islandSearchItem;
    private JToggleButton showConnect;
    private JMenuItem jMenuItem9;
    private JPanel taskButtonPanel;
    private JSplitPane jSplitPane3;
    private JLabel connectLabel;
    private JPanel taskPanel;
    private JTree componentTree;
    private JMenu editMenu;
    private JMenuItem infohabitantSearchItem;
    private JSeparator jSeparator1;
    public JTextField dreamNameField;
    private JPanel statusPanel;
    private JMenu toolsMenu;
    private JMenuItem jMenuItem8;
    private JMenuItem mainHelpItem;
    private JLabel taskLabel;
    private JMenu searchMenu;
    private JMenuItem jMenuItem10;
    private JMenu helpMenu;
    private JLabel glue;
    private JScrollPane jScrollPane3;
    private JPanel contentsPanel;
    private JProgressBar jProgressBar1;
    private JMenuItem userSearchItem;
    private JMenuBar jMenuBar1;

    public Console(ConsoleControl control, StartupWindow startWin) {
        this.control = control;
        this.setup(startWin);
    }

    private Image setDreamIcon() {
        Toolkit tool = Toolkit.getDefaultToolkit();
        Image img = tool.createImage(this.getClass().getResource("/dream/resources/icons/dream-icon.gif"));
        if (img != null) {
            this.setIconImage(img);
        } else {
            Logger.warning((String)this.getClass().getName(), (String)"DREAM icon image not found!", null);
        }
        return img;
    }

    private void setup(StartupWindow startWin) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Thread.currentThread().setPriority(10);
                }
            });
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Logger.addListener((ILogListener)this);
        this.dreamIcon = this.setDreamIcon();
        if (startWin != null) {
            startWin.printMessage("init ui settings...");
        }
        new DefaultUIConfigurator().run();
        if (startWin != null) {
            startWin.printMessage("init window components...");
        }
        this.initComponents();
        this.control.initTree(this.componentTree);
        this.componentTree.putClientProperty("JTree.lineStyle", "Angled");
        this.pack();
        PropertyHelper.setGeometry(this.control.consoleProps, this);
        Control.ensureSize(this, MIN_SIZE_X, MIN_SIZE_Y);
        this.jSplitPane1.setDividerLocation(new Double(this.control.consoleProps.getProperty("console.mainDivider", "0.2")));
        this.setTitle("DREAM Console");
        this.jToolBar2.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jToolBar2.add(Box.createHorizontalStrut(TOOLBAR_GAP));
        this.startExpAction = new StartExperimentAction();
        this.startExpAction.setToolBar(this.jToolBar2);
        this.toolsMenu.add(this.startExpAction);
        this.startExpAction.setEnabled(false);
        this.optionAction = new OptionAction();
        this.optionAction.setToolBar(this.jToolBar2);
        this.toolsMenu.add(this.optionAction);
        this.connectModAction = new ConnectDialogAction();
        this.connectModAction.setToolBar(this.jToolBar2);
        this.toolsMenu.add(this.connectModAction);
        this.connectAction = new ConnectAction();
        this.toolsMenu.add(this.connectAction);
        this.showConnect.setAction(this.connectAction);
        this.connectAction.setToolBar(this.jToolBar2);
        Properties optionProps = ConsoleControl.propHandler.fetch(ConsoleControl.optionPropID);
        if (this.control.localNode == null && new Boolean(optionProps.getProperty("autoConnect", "false")).booleanValue()) {
            Logger.debug((String)this.getClass().getName(), (String)"automatic connection enabled.");
            this.doConnect(this.control.connectProps, true, "Automatic network start in progress.");
            this.connectAction.setConnect(false);
        }
        if (this.control.localNode != null) {
            this.dreamNameField.setText(this.control.localNode.getJob());
        }
        if (this.control.expNode == null && new Boolean(optionProps.getProperty("startExperimentNode", "false")).booleanValue()) {
            Logger.debug((String)this.getClass().getName(), (String)"experiment node start is enabled.");
            this.control.provideExperimentNode(this.control.connectProps);
        }
        if (startWin != null) {
            startWin.printMessage("establish help resources...");
        }
        this.taskHandler = new ConsoleTaskHandler(this.contentsPanel, this.taskButtonPanel, this.toolPanel, this.jMenuBar1);
        this.taskHandler.addTask(new ObjectInfo(this.componentTree, this.control, this.control.requestHandler), true);
        this.taskHandler.addTask(new Messages(), true);
    }

    public void prepareShutdown() {
        PropertyHelper.getGeometry(this.control.consoleProps, this);
        this.control.consoleProps.setProperty("console.mainDivider", String.valueOf((double)this.jSplitPane1.getDividerLocation() / (double)this.jSplitPane1.getWidth()));
    }

    public void show() {
        if (this.enabled) {
            super.show();
        } else {
            this.dispose();
        }
    }

    public void doConnect(Properties proxyProps, boolean forceNewNode, String alternateStartMessage) {
        String startMessage = "Trying to establish network connection.";
        if (alternateStartMessage != null) {
            startMessage = alternateStartMessage;
        }
        if (this.control.localNode != null && forceNewNode) {
            this.control.disconnect();
        }
        this.control.localNode = this.control.getNewSpyNode(proxyProps);
        if (this.control.localNode != null) {
            this.control.hookUpNode(this.control.localNode);
            this.showConnect.setSelected(true);
            this.printStatusMessage("Connected to DRM group: " + this.control.localNode.getJob() + ".");
            this.startExpAction.setEnabled(true);
        } else {
            this.printStatusMessage("Connection to DRM has not been established.");
        }
    }

    public ConsoleControl getControl() {
        return this.control;
    }

    public void provideConnectionDialog() {
        String winName = "connectionDialog";
        if (!this.windowStore.containsKey(winName)) {
            this.printStatusMessage("Setting up connection dialog...");
            ConnectionDialog newWin = new ConnectionDialog(this, false, ConsoleControl.propHandler);
            newWin.setName(winName);
            this.windowStore.put(winName, newWin, this.control.consoleProps, this.dreamIcon);
            ((Window)newWin).show();
        } else {
            ((ConnectionDialog)this.windowStore.get(winName)).show();
            ((ConnectionDialog)this.windowStore.get(winName)).init();
        }
    }

    public void provideHelpWindow(Properties helpProps) {
        String winName = "helpViewer";
        if (!this.windowStore.containsKey(winName)) {
            this.printStatusMessage("Setting up help viewer...");
            try {
                PropertyHandler ph = ConsoleControl.propHandler;
                Control.installProgressTimer(this, this.jProgressBar1, this.statusLabel, Integer.parseInt(ph.getProperty("help.firstInitTime", "3000")), true, this.getClass().getMethod("isHelpVisible", null), this, ph.fetch(ConsoleControl.helpPropID), "help.firstInitTime", 9, "Starting up help viewer...", "Help viewer ready now.", "Still need more time to setup help.", "Help viewer could not be established.", Integer.parseInt(ph.getProperty("clearDelay", "-1")), "Status: ready.");
            }
            catch (Exception ex) {
                Logger.warning((String)this.getClass().getName(), (String)"progress timer failure! ", (Throwable)ex);
            }
            HelpViewer helpFrame = new HelpViewer(ConsoleControl.propHandler);
            helpFrame.setTitle("Console Help");
            helpFrame.setName(winName);
            this.windowStore.put(helpFrame.getName(), helpFrame, this.control.consoleProps, this.dreamIcon);
            URL helpPage = null;
            helpPage = this.getClass().getResource("/dream/resources/helpSets/console/console.html");
            helpFrame.setPage(helpPage);
            helpFrame.show();
        } else {
            ((JFrame)this.windowStore.get(winName)).show();
        }
    }

    public int isHelpVisible() {
        if (this.isWindowVisible("helpViewer")) {
            return 0;
        }
        return -1;
    }

    public boolean isWindowVisible(String winName) {
        boolean answer = false;
        if (this.windowStore.containsKey(winName) && ((JFrame)this.windowStore.get(winName)).isVisible()) {
            answer = true;
        }
        return answer;
    }

    public void provideOptionDialog() {
        String winName = "optionDialog";
        if (!this.windowStore.containsKey(winName)) {
            this.printStatusMessage("Setting up option dialog...");
            OptionDialog newWin = new OptionDialog((Frame)this.console, false, ConsoleControl.propHandler, ConsoleControl.optionPropID);
            newWin.setName(winName);
            this.windowStore.put(winName, newWin, this.control.consoleProps, this.dreamIcon);
            ((Window)newWin).show();
        } else {
            ((OptionDialog)this.windowStore.get(winName)).show();
        }
    }

    public void provideStartExperimentDialog() {
        String winName = "startExperimentDialog";
        if (!this.windowStore.containsKey(winName)) {
            this.printStatusMessage("Setting up experiment dialog...");
            ExperimentDialog newWin = new ExperimentDialog((Frame)this.console, false, this.control);
            newWin.setName(winName);
            this.windowStore.put(winName, newWin, this.control.consoleProps, this.dreamIcon);
            ((Window)newWin).show();
        } else {
            ((ExperimentDialog)this.windowStore.get(winName)).show();
        }
    }

    private void initComponents() {
        this.toolPanel = new JPanel();
        this.jToolBar2 = new JToolBar();
        this.pack();
        this.jPanel2 = new JPanel();
        this.connectLabel = new JLabel();
        this.dreamNameField = new JTextField();
        this.jSplitPane2 = new JSplitPane();
        this.jProgressBar1 = new JProgressBar();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.showConnect = new JToggleButton();
        this.jSplitPane3 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.componentTree = new JTree();
        this.contentsPanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.taskPanel = new JPanel();
        this.taskLabel = new JLabel();
        this.taskButtonPanel = new JPanel();
        this.glue = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.searchMenu = new JMenu();
        this.componentSearchItem = new JMenuItem();
        this.experimentSearchItem = new JMenuItem();
        this.userSearchItem = new JMenuItem();
        this.machineSearchItem = new JMenuItem();
        this.serventSearchItem = new JMenuItem();
        this.islandSearchItem = new JMenuItem();
        this.infohabitantSearchItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.mainHelpItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setName("consoleFrame");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                Console.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Console.this.exitForm(evt);
            }
        });
        this.toolPanel.setLayout(new FlowLayout(0, 2, 2));
        this.jToolBar2.setAlignmentX(0.0f);
        this.jToolBar2.setMinimumSize(new Dimension(109, 27));
        this.jToolBar2.setPreferredSize(new Dimension(285, 27));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.jPanel2.setBorder(new EtchedBorder());
        this.jPanel2.setToolTipText("drm group the console is connected to");
        this.jPanel2.setMinimumSize(new Dimension(39, 20));
        this.jPanel2.setPreferredSize(new Dimension(112, 20));
        this.connectLabel.setFont(new Font("Dialog", 0, 10));
        this.connectLabel.setHorizontalAlignment(0);
        this.connectLabel.setText("DRM:");
        this.connectLabel.setMaximumSize(new Dimension(41, 15));
        this.connectLabel.setMinimumSize(new Dimension(41, 15));
        this.connectLabel.setPreferredSize(new Dimension(41, 15));
        this.connectLabel.setHorizontalTextPosition(0);
        this.jPanel2.add(this.connectLabel);
        this.dreamNameField.setEditable(false);
        this.dreamNameField.setFont(new Font("SansSerif", 0, 9));
        this.dreamNameField.setHorizontalAlignment(0);
        this.dreamNameField.setText("not connected");
        this.dreamNameField.setMargin(new Insets(2, 0, 2, 0));
        this.dreamNameField.setMinimumSize(new Dimension(4, 12));
        this.dreamNameField.setPreferredSize(new Dimension(65, 12));
        this.jPanel2.add(this.dreamNameField);
        this.jToolBar2.add(this.jPanel2);
        this.toolPanel.add(this.jToolBar2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        this.getContentPane().add((Component)this.toolPanel, gridBagConstraints);
        this.jSplitPane2.setDividerLocation(100);
        this.jSplitPane2.setDividerSize(4);
        this.jSplitPane2.setMinimumSize(new Dimension(93, 19));
        this.jSplitPane2.setPreferredSize(new Dimension(231, 19));
        this.jSplitPane2.setLeftComponent(this.jProgressBar1);
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusPanel.setMinimumSize(new Dimension(101, 20));
        this.statusPanel.setPreferredSize(new Dimension(101, 20));
        this.statusLabel.setText("Status: ready.");
        this.statusLabel.setAlignmentX(0.5f);
        this.statusLabel.setBorder(new EmptyBorder(new Insets(0, 4, 0, 4)));
        this.statusLabel.setMaximumSize(new Dimension(77, 15));
        this.statusLabel.setMinimumSize(new Dimension(77, 15));
        this.statusLabel.setPreferredSize(new Dimension(77, 15));
        this.statusLabel.setAutoscrolls(true);
        this.statusLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        this.showConnect.setFont(new Font("Dialog", 1, 0));
        this.showConnect.setIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-default-16.gif")));
        this.showConnect.setToolTipText("enable or disable network connection");
        this.showConnect.setBorder(new EtchedBorder());
        this.showConnect.setContentAreaFilled(false);
        this.showConnect.setMargin(new Insets(0, 3, 0, 3));
        this.showConnect.setMaximumSize(new Dimension(26, 18));
        this.showConnect.setMinimumSize(new Dimension(26, 18));
        this.showConnect.setPreferredSize(new Dimension(26, 18));
        this.showConnect.setRolloverIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-rollover-16.gif")));
        this.showConnect.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/disconnect-rollover-16.gif")));
        this.showConnect.setSelectedIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/disconnect-default-16.gif")));
        this.statusPanel.add((Component)this.showConnect, new GridBagConstraints());
        this.jSplitPane2.setRightComponent(this.statusPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSplitPane2, gridBagConstraints);
        this.jSplitPane3.setBorder(new EtchedBorder());
        this.jSplitPane3.setDividerSize(4);
        this.jSplitPane3.setResizeWeight(0.95);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(400, 300));
        this.componentTree.setBorder(new TitledBorder(null, "known dream components", 0, 0, new Font("SansSerif", 0, 11)));
        this.componentTree.setExpandsSelectedPaths(false);
        this.componentTree.setRootVisible(false);
        this.componentTree.setShowsRootHandles(true);
        this.componentTree.setAutoscrolls(true);
        this.jScrollPane1.setViewportView(this.componentTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.contentsPanel.setLayout(new GridLayout(1, 1));
        this.jSplitPane1.setRightComponent(this.contentsPanel);
        this.jSplitPane3.setLeftComponent(this.jSplitPane1);
        this.jScrollPane3.setBorder(null);
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setMinimumSize(new Dimension(90, 22));
        this.jScrollPane3.setPreferredSize(new Dimension(90, 3));
        this.taskPanel.setLayout(new GridBagLayout());
        this.taskPanel.setBorder(new EmptyBorder(new Insets(1, 2, 1, 1)));
        this.taskPanel.setMinimumSize(new Dimension(40, 4));
        this.taskPanel.setPreferredSize(new Dimension(40, 4));
        this.taskLabel.setHorizontalAlignment(0);
        this.taskLabel.setText("Tasklist:");
        this.taskLabel.setAlignmentY(0.0f);
        this.taskLabel.setMaximumSize(new Dimension(200000, 20));
        this.taskLabel.setMinimumSize(new Dimension(38, 20));
        this.taskLabel.setPreferredSize(new Dimension(200, 20));
        this.taskLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.taskPanel.add((Component)this.taskLabel, gridBagConstraints);
        this.taskButtonPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.taskPanel.add((Component)this.taskButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1000.0;
        this.taskPanel.add((Component)this.glue, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.taskPanel);
        this.jSplitPane3.setRightComponent(this.jScrollPane3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSplitPane3, gridBagConstraints);
        this.fileMenu.setText("File");
        this.jMenuItem4.setText("Load Session");
        this.jMenuItem4.setEnabled(false);
        this.fileMenu.add(this.jMenuItem4);
        this.jMenuItem5.setText("Save Session");
        this.jMenuItem5.setEnabled(false);
        this.fileMenu.add(this.jMenuItem5);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.setEnabled(false);
        this.jMenuItem8.setText("Cut");
        this.jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem8);
        this.jMenuItem9.setText("Copy");
        this.editMenu.add(this.jMenuItem9);
        this.jMenuItem10.setText("Paste");
        this.editMenu.add(this.jMenuItem10);
        this.jMenuBar1.add(this.editMenu);
        this.searchMenu.setText("Search");
        this.searchMenu.setEnabled(false);
        this.componentSearchItem.setText("...for Component");
        this.componentSearchItem.setIcon(new ImageIcon(this.getClass().getResource("/dream/resources/icons/component-noframe-16.gif")));
        this.componentSearchItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.componentSearchItemActionPerformed(evt);
            }
        });
        this.searchMenu.add(this.componentSearchItem);
        this.experimentSearchItem.setText("...for Experiment");
        this.searchMenu.add(this.experimentSearchItem);
        this.userSearchItem.setText("...for User");
        this.searchMenu.add(this.userSearchItem);
        this.machineSearchItem.setText("...for Machine");
        this.machineSearchItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.machineSearchItemActionPerformed(evt);
            }
        });
        this.searchMenu.add(this.machineSearchItem);
        this.serventSearchItem.setText("...for Servent");
        this.searchMenu.add(this.serventSearchItem);
        this.islandSearchItem.setText("...for Island");
        this.searchMenu.add(this.islandSearchItem);
        this.infohabitantSearchItem.setText("...for Infohabitant");
        this.searchMenu.add(this.infohabitantSearchItem);
        this.jMenuBar1.add(this.searchMenu);
        this.toolsMenu.setText("Tools");
        this.jMenuBar1.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.mainHelpItem.setText("Open Help Viewer");
        this.mainHelpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.mainHelpItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.mainHelpItem);
        this.aboutItem.setText("About");
        this.aboutItem.setEnabled(false);
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.aboutItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
    }

    private void mainHelpItemActionPerformed(ActionEvent evt) {
        final Properties helpProps = ConsoleControl.propHandler.fetch(ConsoleControl.helpPropID);
        new Thread(new Runnable(){

            public void run() {
                Console.this.provideHelpWindow(helpProps);
            }
        }).start();
    }

    private void formComponentResized(ComponentEvent evt) {
        Control.ensureSize(this, MIN_SIZE_X, MIN_SIZE_Y);
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
    }

    private void propsMenuItemActionPerformed(ActionEvent evt) {
    }

    private void componentSearchItemActionPerformed(ActionEvent evt) {
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.control.shutdown(0);
    }

    private void machineSearchItemActionPerformed(ActionEvent evt) {
    }

    private void exitForm(WindowEvent evt) {
        this.control.shutdown(0);
    }

    public void handleLogMessage(int type, String sender, String comment, Throwable thr) {
        String s1 = sender == null ? "" : sender;
        String s2 = comment == null ? "" : comment;
        String s3 = thr == null ? "" : thr.toString();
        switch (type) {
            case 0: {
                System.err.print("PANIC! ");
                System.err.println(s1 + ": " + s2 + " " + s3);
                break;
            }
            case 1: {
                System.err.print("ERROR! ");
                System.err.println(s1 + ": " + s2 + " " + s3);
                break;
            }
            case 2: {
                System.err.print("WARNING! ");
                System.err.println(s1 + ": " + s2 + " " + s3);
                break;
            }
            default: {
                System.err.println(s1 + ": " + s2 + " " + s3);
            }
        }
        if (thr != null) {
            thr.printStackTrace();
        }
    }

    public JTree getComponentTree() {
        return this.componentTree;
    }

    public void printStatusMessage(String message) {
        int clearDelay = 0;
        try {
            clearDelay = Integer.parseInt(ConsoleControl.propHandler.fetch(ConsoleControl.optionPropID).getProperty("clearDelay", "0"));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        Control.setStatus(this, this.statusLabel, message, clearDelay);
    }

    public String getStatusMessage() {
        return this.statusLabel.getText();
    }

    public String getDefaultMessage() {
        return "Status: ready.";
    }

    public static void main(String[] args) {
        new ConsoleControl().display();
    }

    class StartExperimentAction
    extends ConsoleAction {
        public StartExperimentAction() {
            super("Start Experiment", "start a new experiment");
            ImageIcon defIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/start-experiment-default-16.gif"));
            ImageIcon rollIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/start-experiment-rollover-16.gif"));
            this.setIcons(defIcon, rollIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(new Runnable(this){
                private final /* synthetic */ StartExperimentAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    StartExperimentAction.access$400(this.this$1).provideStartExperimentDialog();
                }
            }).start();
        }

        static /* synthetic */ Console access$400(StartExperimentAction x0) {
            return x0.Console.this;
        }
    }

    class ConnectDialogAction
    extends ConsoleAction {
        public ConnectDialogAction() {
            super("Modify DRM connection", "shows the connection dialog for changing DRM groups and known host data");
            ImageIcon defaultIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-options-default-16.gif"));
            ImageIcon rollIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-options-rollover-16.gif"));
            this.setIcons(defaultIcon, rollIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(new Runnable(this){
                private final /* synthetic */ ConnectDialogAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ConnectDialogAction.access$300(this.this$1).provideConnectionDialog();
                }
            }).start();
        }

        static /* synthetic */ Console access$300(ConnectDialogAction x0) {
            return x0.Console.this;
        }
    }

    class OptionAction
    extends ConsoleAction {
        public OptionAction() {
            super("Options", "show the options dialog");
            ImageIcon optDefaultIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/options-default-16.gif"));
            ImageIcon optRollIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/options-rollover-16.gif"));
            this.setIcons(optDefaultIcon, optRollIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(new Runnable(this){
                private final /* synthetic */ OptionAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    OptionAction.access$200(this.this$1).provideOptionDialog();
                }
            }).start();
        }

        static /* synthetic */ Console access$200(OptionAction x0) {
            return x0.Console.this;
        }
    }

    class ConnectAction
    extends AbstractAction {
        Icon conDefaultIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-default-16.gif"));
        Icon conRollIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/connect-rollover-16.gif"));
        Icon disDefaultIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/disconnect-default-16.gif"));
        Icon disRollIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/disconnect-rollover-16.gif"));
        boolean isConnect = true;
        JToolBar inToolbar = null;
        JButton toolbarButton = null;

        public ConnectAction() {
            super("Connect to DRM");
            this.setConnect(true);
        }

        public void setConnect(boolean connect) {
            this.isConnect = connect;
            if (connect) {
                this.putValue("Name", "Connect to DRM group");
                this.putValue("SmallIcon", this.conDefaultIcon);
                this.putValue("ShortDescription", "connects to the DREAM network using the predefined settings");
            } else {
                this.putValue("Name", "Disconnect from DRM group");
                this.putValue("SmallIcon", this.disDefaultIcon);
                this.putValue("ShortDescription", "do this if you want to prevent further network access");
            }
            this.setEnabled(true);
            if (this.inToolbar != null) {
                this.setToolBar(this.inToolbar);
            }
        }

        public void setToolBar(JToolBar myToolBar) {
            if (this.toolbarButton != null && this.inToolbar != null) {
                this.inToolbar.remove(this.toolbarButton);
            }
            this.inToolbar = myToolBar;
            this.toolbarButton = myToolBar.add(Console.this.connectAction);
            this.toolbarButton.setToolTipText((String)Console.this.connectAction.getValue("ShortDescription"));
            if (this.isConnect) {
                this.toolbarButton.setRolloverIcon(this.conRollIcon);
            } else {
                this.toolbarButton.setRolloverIcon(this.disRollIcon);
            }
            myToolBar.invalidate();
            myToolBar.validate();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            if (this.isConnect) {
                Console.this.doConnect(((Console)Console.this).control.connectProps, true, "Connecting to DRM.");
                this.setConnect(false);
            } else {
                Console.this.control.disconnect();
                Console.this.dreamNameField.setText(Console.this.control.askDRMGroupName());
                this.setConnect(true);
                Console.this.showConnect.setSelected(false);
                Console.this.printStatusMessage("Disconnected from DRM.");
            }
            this.setEnabled(true);
        }
    }
}

