/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.Console;
import dream.gui.Control;
import dream.gui.StartupWindow;
import dream.gui.componentTree.DreamCellRenderer;
import dream.gui.componentTree.DreamComponent;
import dream.gui.componentTree.DreamTreeModel;
import dream.gui.event.DRMRequestHandler;
import dream.util.PropertyHandler;
import drm.agentbase.Logger;
import drm.core.Node;
import drm.util.ConfigProperties;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeNode;

public class ConsoleControl
extends Control
implements Serializable {
    private String optionPropertyFilename = "options.properties";
    private String helpPropertyFilename = "help.properties";
    private static String setupPropertyFilename = "installer.properties";
    private String consolePropertyFilename = "console.properties";
    public static String consolePropID = "console properties";
    public static String optionPropID = "option properties";
    public static String helpPropID = "console help properties";
    public static String networkPropID = "connection properties";
    public static String setupPropID = "setup properties";
    public static String addressListID = "address list";
    public static String addressListPath = "/drm/resources/AddressList.properties";
    public Properties consoleProps = new Properties();
    transient Node localNode = null;
    transient Node expNode = null;
    private Timer treeDisplayTimer = null;
    private DreamComponent treeRoot = null;
    private DreamTreeModel treeMod = null;
    private StartupWindow startWin = null;
    private String connectConfigFile = null;
    public Properties connectProps = new Properties();
    public DRMRequestHandler requestHandler = new DRMRequestHandler(null);
    private Console console = null;

    public ConsoleControl() {
        this(null);
    }

    public ConsoleControl(String propertyFilename) {
        if (propertyFilename != null) {
            this.consolePropertyFilename = propertyFilename;
        }
        this.initWindow();
        this.initConsoleControl();
    }

    private void initWindow() {
        this.startWin = new StartupWindow("/dream/resources/icons/console-startup.gif");
        this.startWin.show();
        this.startWin.toFront();
        this.startWin.setTextPosition(10, 141);
        this.startWin.printMessage("console initializing...");
    }

    private void closeInitWindow() {
        Timer eventTimer = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ConsoleControl.this.startWin != null) {
                    ConsoleControl.this.startWin.dispose();
                    ConsoleControl.this.startWin = null;
                }
            }
        });
        eventTimer.setRepeats(false);
        eventTimer.start();
    }

    private void initConsoleControl() {
        if (this.startWin != null) {
            this.startWin.printMessage("loading properties...");
        }
        this.consoleProps = Control.propHandler.fetch(this.consolePropertyFilename, consolePropID, Control.userDreamPath, System.out, "console", null);
        if (this.consoleProps == null) {
            System.out.println("Console fatal error: cannot start without property file.");
            System.exit(1);
        }
        this.currentDir = this.consoleProps.getProperty("current-dir");
        this.connectConfigFile = this.consoleProps.getProperty("proxy-config-file");
        if (this.connectConfigFile == null) {
            this.connectConfigFile = "connect.properties";
        }
        this.connectProps = Control.propHandler.fetch(this.connectConfigFile, networkPropID, Control.userDreamPath, System.out, "connection", new Properties());
        Control.propHandler.fetch(this.optionPropertyFilename, optionPropID, Control.userDreamPath, System.out, "option", null);
        Control.propHandler.fetch(this.helpPropertyFilename, helpPropID, Control.userDreamPath, System.out, "help", null);
        Control.propHandler.fetch(setupPropertyFilename, setupPropID, Control.userDreamPath, System.out, "setup", null);
        Control.propHandler.fetch("/drm/resources/AddressList.properties", addressListID, "", System.out, "address list", null);
        new Thread(this.requestHandler).start();
    }

    Node getNewSpyNode(Properties nodeProps) {
        Node newNode = null;
        ConfigProperties addProps = new ConfigProperties(nodeProps);
        try {
            addProps.loadSystemResource("drm/resources/AddressList.properties");
        }
        catch (IOException ex) {
            Logger.warning((String)this.getClass().getName(), (String)"address list not found", (Throwable)ex);
        }
        addProps.setProperty("spy", "true");
        newNode = new Node((Properties)addProps);
        int port = Integer.parseInt(addProps.getProperty("temp-port", "10121"));
        if (newNode.goOnline(port, port + 30) < 0) {
            Logger.warning((String)this.getClass().getName(), (String)("Temporary node could not go online, ports " + port + " to " + port + 30 + " seem to be in use"), null);
            newNode.close();
            newNode = null;
        }
        return newNode;
    }

    Node provideExperimentNode(Properties nodeProps) {
        if (nodeProps == null) {
            nodeProps = this.connectProps;
        }
        Node newNode = null;
        ConfigProperties addProps = new ConfigProperties(nodeProps);
        try {
            addProps.loadSystemResource("drm/resources/AddressList.properties");
        }
        catch (IOException ex) {
            Logger.warning((String)this.getClass().getName(), (String)"address list not found", (Throwable)ex);
        }
        addProps.setProperty("spy", "false");
        newNode = new Node((Properties)addProps);
        int port = Integer.parseInt(addProps.getProperty("port", "10101"));
        port = newNode.goOnline(port, port + 10);
        if (port < 0) {
            Logger.warning((String)this.getClass().getName(), (String)("Experiment node could not go online, ports " + port + " to " + port + 10 + " seem to be in use"), null);
            newNode.close();
            newNode = null;
        }
        if (newNode != null && this.localNode != null) {
            Properties p = new Properties();
            try {
                p.setProperty("node.1", InetAddress.getLocalHost().getHostAddress() + ":" + port);
                this.localNode.addNodes(p);
            }
            catch (UnknownHostException ex) {
                Logger.warning((String)(this.getClass().getName() + "#provideExperimentNode"), (String)"address of local node is not valid", (Throwable)ex);
            }
        }
        this.expNode = newNode;
        return newNode;
    }

    public void initTree(final JTree componentTree) {
        this.treeRoot = new DreamComponent("component tree root");
        this.treeMod = new DreamTreeModel(this.treeRoot, Control.propHandler);
        componentTree.setModel(this.treeMod);
        DreamCellRenderer renderer = new DreamCellRenderer();
        if (this.treeDisplayTimer != null) {
            this.treeDisplayTimer.stop();
        }
        this.treeDisplayTimer = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Logger.debug((String)this.getClass().getName(), (String)"updating tree view...");
                ConsoleControl.this.treeMod.updateFromDRM(ConsoleControl.this.localNode);
                ConsoleControl.this.treeMod.checkComponents((DreamComponent)ConsoleControl.this.treeMod.getRoot());
                componentTree.repaint();
            }
        });
        this.treeDisplayTimer.setRepeats(true);
        ToolTipManager.sharedInstance().registerComponent(componentTree);
        componentTree.setCellRenderer(renderer);
        this.treeDisplayTimer.start();
    }

    public void hookUpNode(Node localNode) {
        if (this.localNode != null) {
            // empty if block
        }
        this.localNode = localNode;
        if (this.console != null) {
            this.console.dreamNameField.setText(localNode.getJob());
        }
        this.requestHandler.setNode(localNode);
    }

    public void disconnect() {
        if (this.treeMod != null) {
            this.treeMod.restart();
        }
        if (this.localNode != null) {
            this.requestHandler.setNode(null);
            this.localNode.close();
            this.localNode = null;
        }
        if (this.expNode != null) {
            this.expNode.close();
            this.expNode = null;
        }
        if (this.console != null) {
            this.console.startExpAction.setEnabled(false);
        }
    }

    private void deleteNotFound(DreamComponent requestRoot, Collection requestResult) {
        Enumeration<TreeNode> children = requestRoot.children();
        DreamComponent next = null;
        HashSet<String> strings = new HashSet<String>();
        boolean deleteIt = true;
        if (requestResult != null) {
            Iterator resIter = requestResult.iterator();
            while (resIter.hasNext()) {
                DreamComponent resultElement = (DreamComponent)resIter.next();
                strings.add(resultElement.toString());
            }
        }
        while (children.hasMoreElements()) {
            next = (DreamComponent)children.nextElement();
            deleteIt = true;
            if (strings != null && strings.contains(next.toString())) {
                deleteIt = false;
            }
            if (!deleteIt) continue;
            System.out.println("DELETING element: " + next.toString());
            next.removeFromParent();
        }
    }

    public String askDRMGroupName() {
        String answer = null;
        if (this.localNode != null) {
            answer = this.localNode.getJob();
        }
        return answer == null ? "not connected" : answer;
    }

    public void shutdown(int returnToSystem) {
        if (this.console != null) {
            this.console.prepareShutdown();
        }
        Control.propHandler.saveAll();
        if (this.requestHandler != null) {
            this.requestHandler.shouldLive = false;
        }
        if (this.treeDisplayTimer != null) {
            this.treeDisplayTimer.stop();
        }
        if (this.console != null) {
            this.console.dispose();
        }
        this.console = null;
        this.disconnect();
        System.exit(returnToSystem);
    }

    public void display() {
        if (this.console == null) {
            this.console = new Console(this, this.startWin);
        }
        this.closeInitWindow();
        this.console.show();
    }

    private void showError(Frame rootFrame, String s) {
        new JOptionPane();
        JOptionPane.showMessageDialog(rootFrame, s, null, 0);
    }

    public static boolean isInstalled() {
        Properties installerProps = PropertyHandler.getDefaultHandler().fetch(setupPropertyFilename, setupPropID, Control.userDreamPath, null, null, null);
        return installerProps != null && Boolean.valueOf(installerProps.getProperty("DreamInstalled", "false")) == true;
    }

    public static void main(String[] args) {
        new ConsoleControl().display();
    }
}

