/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.ConsoleControl;
import dream.gui.Control;
import dream.gui.LocalClassLoader;
import dream.gui.StatusPrinter;
import drm.agentbase.JobClassLoader;
import drm.agentbase.Logger;
import drm.core.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class ExperimentDialog
extends JDialog
implements StatusPrinter {
    private boolean jarNameFieldUntouched = true;
    private boolean classNameFieldUntouched = true;
    private boolean browseMode = true;
    private ConsoleControl console = null;
    private int MIN_SIZE_X = 400;
    private int MIN_SIZE_Y = 450;
    private String status = "ready...";
    private DefaultListModel listMod = null;
    private Properties optionProps = new Properties();
    private JFileChooser jFileChooser1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator1;
    private JList startablesList;
    private JTextField launcherClassTextField;
    private JButton startButton;
    private JPanel buttonPanel;
    private JButton okButton;
    private JLabel middleGlue;
    private JTextField jarNameTextField;
    private JButton classSelectButton;
    private JLabel statusLabel;
    private JLabel listBoxGlue;
    private JButton browseButton;
    private JSplitPane jSplitPane1;
    private JProgressBar jProgressBar1;
    private JScrollPane startListScrollPane;
    private JButton cancelButton;
    private JPanel mainPanel;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel bottomGlue;
    static /* synthetic */ Class class$drm$core$Node;

    public ExperimentDialog(Frame parent, boolean modal, ConsoleControl console) {
        super(parent, modal);
        this.setName("experimentDialog");
        this.console = console;
        this.optionProps = ConsoleControl.propHandler.fetch("option.properties");
        this.initComponents();
        this.jFileChooser1.setVisible(false);
        this.jFileChooser1.setFileFilter(new JarFileFilter());
        Control.ensureSize(this, this.MIN_SIZE_X, this.MIN_SIZE_Y);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jarNameTextField = new JTextField();
        this.browseButton = new JButton();
        this.jFileChooser1 = new JFileChooser();
        this.jLabel2 = new JLabel();
        this.bottomGlue = new JLabel();
        this.launcherClassTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.classSelectButton = new JButton();
        this.startListScrollPane = new JScrollPane();
        this.startablesList = new JList();
        this.middleGlue = new JLabel();
        this.listBoxGlue = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jProgressBar1 = new JProgressBar();
        this.statusLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("DREAM Experiment Dialog");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ExperimentDialog.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ExperimentDialog.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        this.jarNameTextField.setText("enter jar file name here or click browse");
        this.jarNameTextField.setToolTipText("enter jar file name here or click browse");
        this.jarNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ExperimentDialog.this.jarNameTextFieldFocusGained(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mainPanel.add((Component)this.jarNameTextField, gridBagConstraints);
        this.browseButton.setText("browse");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExperimentDialog.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mainPanel.add((Component)this.browseButton, gridBagConstraints);
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.setControlButtonsAreShown(false);
        this.jFileChooser1.setFileSelectionMode(2);
        this.jFileChooser1.setMinimumSize(new Dimension(500, 250));
        this.jFileChooser1.setPreferredSize(new Dimension(150, 150));
        this.jFileChooser1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExperimentDialog.this.jFileChooser1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 15.0;
        this.mainPanel.add((Component)this.jFileChooser1, gridBagConstraints);
        this.jLabel2.setText("experiment jar file or base directory:");
        this.jLabel2.setToolTipText("jar file or directory that contains the experiment");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.bottomGlue, gridBagConstraints);
        this.launcherClassTextField.setText("enter launcher class or select from list below (first give jar file)");
        this.launcherClassTextField.setToolTipText("enter launcher class or select from list below (first give jar file)");
        this.launcherClassTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExperimentDialog.this.launcherClassTextFieldActionPerformed(evt);
            }
        });
        this.launcherClassTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ExperimentDialog.this.launcherClassTextFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mainPanel.add((Component)this.launcherClassTextField, gridBagConstraints);
        this.jLabel3.setText("launcher class:");
        this.jLabel3.setToolTipText("class of the given jar file or directory that actually starts the experiment");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.mainPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.classSelectButton.setText("select class");
        this.classSelectButton.setEnabled(false);
        this.classSelectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExperimentDialog.this.classSelectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.mainPanel.add((Component)this.classSelectButton, gridBagConstraints);
        this.startablesList.setBorder(new TitledBorder("available classes:"));
        this.startablesList.setToolTipText("classes contained in the given jar file or directory, please select one item");
        this.startablesList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExperimentDialog.this.startablesListMouseClicked(evt);
            }
        });
        this.startListScrollPane.setViewportView(this.startablesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 10.0;
        this.mainPanel.add((Component)this.startListScrollPane, gridBagConstraints);
        this.middleGlue.setPreferredSize(new Dimension(0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.middleGlue, gridBagConstraints);
        this.listBoxGlue.setMinimumSize(new Dimension(3, 10));
        this.listBoxGlue.setPreferredSize(new Dimension(3, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.listBoxGlue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.mainPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 3, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.startButton.setText("start");
        this.startButton.setToolTipText("start experiment, save data and leave dialogction");
        this.startButton.setAlignmentY(0.0f);
        this.startButton.setHorizontalTextPosition(0);
        this.startButton.setMargin(new Insets(0, 14, 0, 14));
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExperimentDialog.this.startButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.startButton, gridBagConstraints);
        this.okButton.setText("ok");
        this.okButton.setToolTipText("leave dialog without starting experiment, but save data");
        this.okButton.setHorizontalTextPosition(0);
        this.okButton.setMargin(new Insets(0, 14, 0, 14));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExperimentDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("cancel");
        this.cancelButton.setToolTipText("leave the dialog without saving data");
        this.cancelButton.setHorizontalTextPosition(0);
        this.cancelButton.setMargin(new Insets(0, 14, 0, 14));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExperimentDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(4);
        this.jSplitPane1.setAlignmentX(0.5f);
        this.jSplitPane1.setAlignmentY(0.5f);
        this.jSplitPane1.setMinimumSize(new Dimension(83, 19));
        this.jSplitPane1.setPreferredSize(new Dimension(83, 19));
        this.jProgressBar1.setToolTipText("shows connection progress");
        this.jProgressBar1.setBorder(new CompoundBorder(new EmptyBorder(new Insets(0, 0, 0, 0)), new LineBorder(new Color(0, 0, 0))));
        this.jProgressBar1.setMaximumSize(new Dimension(0, 0));
        this.jProgressBar1.setMinimumSize(new Dimension(0, 0));
        this.jProgressBar1.setPreferredSize(new Dimension(100, 15));
        this.jProgressBar1.setAutoscrolls(true);
        this.jSplitPane1.setLeftComponent(this.jProgressBar1);
        this.statusLabel.setText("Status: ready.");
        this.statusLabel.setAlignmentX(0.5f);
        this.statusLabel.setBorder(new EmptyBorder(new Insets(0, 4, 0, 4)));
        this.statusLabel.setMaximumSize(new Dimension(77, 15));
        this.statusLabel.setMinimumSize(new Dimension(77, 15));
        this.statusLabel.setPreferredSize(new Dimension(77, 15));
        this.statusLabel.setAutoscrolls(true);
        this.statusLabel.setHorizontalTextPosition(10);
        this.jSplitPane1.setRightComponent(this.statusLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.buttonPanel.add((Component)this.jSplitPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void classSelectButtonActionPerformed(ActionEvent evt) {
        if (this.listMod != null) {
            int index = this.startablesList.getMinSelectionIndex();
            String sel = (String)this.startablesList.getModel().getElementAt(index);
            this.classNameFieldUntouched = false;
            this.launcherClassTextField.setText(sel);
            this.printStatusMessage("Class " + sel + " selected.");
        }
    }

    private void startablesListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.startablesList.locationToIndex(evt.getPoint());
            String sel = (String)this.startablesList.getModel().getElementAt(index);
            this.classNameFieldUntouched = false;
            this.launcherClassTextField.setText(sel);
            this.printStatusMessage("Class " + sel + " selected.");
        }
    }

    private void launcherClassTextFieldFocusGained(FocusEvent evt) {
        if (this.classNameFieldUntouched) {
            this.launcherClassTextField.setText("");
            this.classNameFieldUntouched = false;
        }
    }

    private void jFileChooser1ActionPerformed(ActionEvent evt) {
        this.browseButtonActionPerformed(evt);
    }

    private void launcherClassTextFieldActionPerformed(ActionEvent evt) {
        if (this.launcherClassTextField.getText().toLowerCase().endsWith(".class")) {
            this.startButton.setEnabled(true);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
    }

    private static void startScript(String scriptName, Node startOn) throws ClassNotFoundException, NoSuchMethodException, Exception {
        Logger.debug((String)"ExperimentDialog#startScript", (String)("Starting '" + scriptName + "'"));
        Class<?> result = null;
        String fileName = null;
        String className = "Launch";
        LocalClassLoader jcl = null;
        int bound = scriptName.indexOf(33);
        if (bound != -1) {
            fileName = scriptName.substring(0, bound);
            className = scriptName.substring(bound + 1);
        } else {
            fileName = scriptName;
        }
        jcl = new LocalClassLoader(new File(fileName));
        result = Class.forName(className, true, (ClassLoader)((Object)jcl));
        if (!(result.getClassLoader() instanceof JobClassLoader)) {
            throw new Exception("class " + className + " should not be in class path");
        }
        Class[] pars = new Class[]{startOn.getClass()};
        Constructor<?> cons = result.getConstructor(pars);
        Object[] objpars = new Object[]{startOn};
        Runnable script = (Runnable)cons.newInstance(objpars);
        Thread launchThread = new Thread(script);
        launchThread.setPriority(1);
        launchThread.start();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        if (this.console != null) {
            String launchClass = this.launcherClassTextField.getText();
            if (launchClass.toLowerCase().endsWith(".class")) {
                launchClass = launchClass.substring(0, launchClass.length() - 6);
            }
            String launched = launchClass;
            try {
                if (this.console.expNode == null) {
                    this.console.provideExperimentNode(null);
                }
                if (this.console.expNode != null) {
                    ExperimentDialog.startScript(this.jarNameTextField.getText() + "!" + launchClass, this.console.expNode);
                    Control.recurseSetStatus(this, "Experiment started using launcher class " + launchClass + " .");
                } else {
                    Control.recurseSetStatus(this, "Cannot start any experiment, experiment node is not up.");
                    Logger.error((String)(this.getClass().getName() + "#startButtonActionPerformed"), (String)"experiment node could  not be started.", null);
                }
            }
            catch (Exception ex) {
                Logger.error((String)(this.getClass().getName() + "#startButtonActionPerformed"), (String)"could not start experiment", (Throwable)ex);
                Control.recurseSetStatus(this, "Experiment startup failed, used launcher class " + launchClass + " .");
            }
        }
        this.closeDialog(null);
    }

    private void formComponentResized(ComponentEvent evt) {
        Control.ensureSize(this, this.MIN_SIZE_X, this.MIN_SIZE_Y);
    }

    private void jarNameTextFieldFocusGained(FocusEvent evt) {
        if (this.jarNameFieldUntouched) {
            this.jarNameTextField.setText("");
            this.jarNameFieldUntouched = false;
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (this.browseMode) {
            this.browseButton.setText("select");
            this.browseMode = false;
            this.jFileChooser1.setVisible(true);
            this.startListScrollPane.setVisible(false);
        } else {
            this.browseButton.setText("browse");
            this.browseMode = true;
            if (this.jFileChooser1.getSelectedFile() != null) {
                this.jarNameTextField.setText(this.jFileChooser1.getSelectedFile().getAbsolutePath());
                this.jarNameFieldUntouched = false;
            }
            this.jFileChooser1.setVisible(false);
            this.startListScrollPane.setVisible(true);
            if (this.jarNameTextField.getText().toLowerCase().endsWith(".jar")) {
                this.extractJarClasses(this.startablesList, this.jarNameTextField.getText());
            }
        }
        this.validate();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void extractJarClasses(JList putInto, String jarPath) {
        JarFile jf = null;
        Enumeration<JarEntry> jenum = null;
        this.printStatusMessage("Extracting jar file...");
        try {
            jf = new JarFile(jarPath);
            jenum = jf.entries();
        }
        catch (Exception ex) {
            Logger.debug((String)(this.getClass().getName() + "#" + "extractJarClasses"), (String)("problem while opening jar file " + jarPath + ex));
        }
        this.listMod = new DefaultListModel();
        while (jenum != null && jenum.hasMoreElements()) {
            JarEntry next = jenum.nextElement();
            if (!next.getName().toLowerCase().endsWith(".class")) continue;
            String tmp = next.getName().substring(0, next.getName().length() - 6).replace('/', '.');
            this.listMod.addElement(tmp);
        }
        this.startablesList.setModel(this.listMod);
        this.classSelectButton.setEnabled(this.listMod.size() > 0);
        this.printStatusMessage(this.listMod.size() + " classes found, checking...");
        this.jProgressBar1.setMaximum(this.listMod.size());
        this.jProgressBar1.setValue(0);
        Vector<String> startables = new Vector<String>();
        Class[] pars = new Class[]{class$drm$core$Node == null ? (class$drm$core$Node = ExperimentDialog.class$("drm.core.Node")) : class$drm$core$Node};
        JobClassLoader jcl = new JobClassLoader(new File(jarPath));
        Class<?> testClass = null;
        int index = 0;
        while (index < this.listMod.size()) {
            boolean constructFound = false;
            try {
                testClass = Class.forName((String)this.listMod.getElementAt(index), true, (ClassLoader)jcl);
                Constructor<?> cons = testClass.getConstructor(pars);
                constructFound = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (constructFound) {
                startables.add((String)this.listMod.getElementAt(index));
            }
            this.jProgressBar1.setValue(index + 1);
            ++index;
        }
        if (startables.size() == 0) {
            this.printStatusMessage("No startable classes found.");
        } else {
            this.printStatusMessage(startables.size() + " startable class(es) found, " + "refining list.");
            this.listMod.removeAllElements();
            Iterator startIt = startables.iterator();
            while (startIt.hasNext()) {
                this.listMod.addElement(startIt.next());
            }
            putInto.setModel(this.listMod);
        }
    }

    public static void main(String[] args) {
        new ExperimentDialog((Frame)new JFrame(), true, null).show();
    }

    public String getStatusMessage() {
        return this.status;
    }

    public void printStatusMessage(String message) {
        int clearDelay = 0;
        try {
            clearDelay = Integer.parseInt(ConsoleControl.propHandler.fetch(ConsoleControl.optionPropID).getProperty("clearDelay", "0"));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        Control.setStatus(this, this.statusLabel, message, clearDelay);
    }

    public String getDefaultMessage() {
        return "Status: ready.";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class JarFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.getName().toLowerCase().endsWith(".jar")) {
                return true;
            }
            return file.isDirectory();
        }

        public String getDescription() {
            return "java archive files only (*.jar)";
        }
    }
}

