/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.ConsoleControl;
import dream.gui.Control;
import dream.gui.StartDialog;
import dream.setup.Setup;
import dream.util.PropertyHandler;
import drm.agentbase.Logger;
import drm.core.Node;
import drm.util.ConfigProperties;
import java.util.Properties;

public class Launcher
implements Runnable {
    Node consoleNode = null;
    PropertyHandler propHandler = PropertyHandler.getDefaultHandler();
    Properties nodeProperties = null;
    ConsoleControl console = null;

    public Launcher(Properties config) {
        this.nodeProperties = config;
    }

    public void run() {
        int startOption = 1;
        if (!this.checkInstalled()) {
            new Setup().show();
        }
        startOption = StartDialog.askStartOption(1500);
        switch (startOption) {
            case 3: {
                this.initConsole();
            }
            case 4: {
                new Setup().show();
                break;
            }
        }
    }

    public boolean checkInstalled() {
        this.propHandler.fetch("installer.properties", null, Control.userDreamPath, null, null, null);
        return !this.propHandler.getProperty("DreamInstalled", "false").equals("false");
    }

    public void initConsole() {
        int port;
        this.console = new ConsoleControl();
        this.nodeProperties.setProperty("spy", "true");
        if (this.consoleNode == null) {
            this.consoleNode = new Node(this.nodeProperties);
        }
        if (this.consoleNode.goOnline(port = Integer.parseInt(this.nodeProperties.getProperty("port", "10101")), port + 10) < 0) {
            Logger.panic((String)this.getClass().getName(), (String)("Could not go online, ports " + port + " to " + port + 10 + " seem to be in use"), null);
            this.consoleNode.close();
            System.exit(1);
        } else {
            this.console.display();
            this.console.hookUpNode(this.consoleNode);
        }
    }

    public static void main(String[] args) {
        ConfigProperties cfg = new ConfigProperties(args, "drm/resources/AddressList.properties");
        new Launcher((Properties)cfg).run();
    }
}

