/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import dream.gui.Control;
import dream.gui.PropertyHelper;
import dream.util.PropertyHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class OptionDialog
extends JDialog {
    private Properties props = null;
    private PropertyHandler propHandler = null;
    private static int MIN_SIZE_X = 400;
    private static int MIN_SIZE_Y = 250;
    private JCheckBox localServentCheckBox;
    private JTextField clearDelayTextField;
    private JCheckBox fullAgentNamesCheckBox;
    private JPanel startupPanel;
    private JButton clearDelayButton;
    private JButton okButton;
    private JTabbedPane optionPanel;
    private JPanel displayPanel;
    private JCheckBox fullIslandNamesCheckBox;
    private JCheckBox fullNodeNamesCheckBox;
    private JButton cancelButton;
    private ButtonGroup buttonGroup1;
    private JButton applyButton;
    private JPanel buttonPanel;
    private JCheckBox autoConnectCheckBox;

    public OptionDialog(Frame parent, boolean modal, PropertyHandler propHandler, String propFilename) {
        super(parent, modal);
        this.setName("optionDialog");
        this.props = propHandler.fetch(propFilename);
        this.propHandler = propHandler;
        propHandler.backup(this.props);
        this.initComponents();
        this.pack();
        Control.ensureSize(this, MIN_SIZE_X, MIN_SIZE_Y);
        JRootPane root = this.getRootPane();
        root.setDefaultButton(this.okButton);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.optionPanel = new JTabbedPane();
        this.startupPanel = new JPanel();
        this.autoConnectCheckBox = new JCheckBox();
        this.localServentCheckBox = new JCheckBox();
        this.displayPanel = new JPanel();
        this.fullNodeNamesCheckBox = new JCheckBox();
        this.fullIslandNamesCheckBox = new JCheckBox();
        this.clearDelayTextField = new JTextField();
        this.clearDelayButton = new JButton();
        this.fullAgentNamesCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.applyButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setTitle("DREAM OptionDialog");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                OptionDialog.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionDialog.this.closeDialog(evt);
            }
        });
        this.optionPanel.setBackground(Color.white);
        this.optionPanel.setBorder(new TitledBorder("Options"));
        this.optionPanel.setPreferredSize(new Dimension(400, 400));
        this.optionPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                OptionDialog.this.optionPanelComponentShown(evt);
            }
        });
        this.startupPanel.setLayout(new GridBagLayout());
        this.startupPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                OptionDialog.this.optionPanelComponentShown(evt);
            }
        });
        this.startupPanel.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                OptionDialog.this.startupPanelFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                OptionDialog.this.startupPanelFocusLost(evt);
            }
        });
        this.autoConnectCheckBox.setText("connect automatically during startup");
        this.autoConnectCheckBox.setToolTipText("connects to the set default DRM on startup");
        this.autoConnectCheckBox.setName("autoConnect");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.startupPanel.add((Component)this.autoConnectCheckBox, gridBagConstraints);
        this.localServentCheckBox.setText("start experiment node on startup");
        this.localServentCheckBox.setToolTipText("enables early startup of an experiment node to accelerate experiment start");
        this.localServentCheckBox.setName("startExperimentNode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.startupPanel.add((Component)this.localServentCheckBox, gridBagConstraints);
        this.optionPanel.addTab("Startup", null, this.startupPanel, "");
        this.displayPanel.setLayout(new GridBagLayout());
        this.displayPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                OptionDialog.this.optionPanelComponentShown(evt);
            }
        });
        this.fullNodeNamesCheckBox.setText("show full node names");
        this.fullNodeNamesCheckBox.setToolTipText("if selected, full node addresses are used in the tree view display");
        this.fullNodeNamesCheckBox.setName("options.fullNodeNames");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.displayPanel.add((Component)this.fullNodeNamesCheckBox, gridBagConstraints);
        this.fullIslandNamesCheckBox.setText("show full island names");
        this.fullIslandNamesCheckBox.setToolTipText("if selected, complete island addresses are used in the tree view display");
        this.fullIslandNamesCheckBox.setName("options.fullIslandNames");
        this.fullIslandNamesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionDialog.this.fullIslandNamesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.displayPanel.add((Component)this.fullIslandNamesCheckBox, gridBagConstraints);
        this.clearDelayTextField.setText("5000");
        this.clearDelayTextField.setToolTipText("enter the new time period (in milliseconds) here");
        this.clearDelayTextField.setMinimumSize(new Dimension(50, 20));
        this.clearDelayTextField.setName("clearDelay");
        this.clearDelayTextField.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.displayPanel.add((Component)this.clearDelayTextField, gridBagConstraints);
        this.clearDelayButton.setText("milliseconds to wait before clearing status line");
        this.clearDelayButton.setToolTipText("click sets the default value");
        this.clearDelayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionDialog.this.clearDelayButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.displayPanel.add((Component)this.clearDelayButton, gridBagConstraints);
        this.fullAgentNamesCheckBox.setText("show full agent names");
        this.fullAgentNamesCheckBox.setToolTipText("if selected, complete agent addresses are used in the tree view display");
        this.fullAgentNamesCheckBox.setName("options.fullAgentNames");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.displayPanel.add((Component)this.fullAgentNamesCheckBox, gridBagConstraints);
        this.optionPanel.addTab("Display", null, this.displayPanel, "");
        this.getContentPane().add(this.optionPanel);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 23));
        this.applyButton.setText("apply");
        this.applyButton.setToolTipText("apply new settings and save data");
        this.applyButton.setAlignmentY(0.0f);
        this.applyButton.setHorizontalTextPosition(0);
        this.applyButton.setMargin(new Insets(0, 14, 0, 14));
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionDialog.this.applyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.applyButton, gridBagConstraints);
        this.okButton.setText("ok");
        this.okButton.setToolTipText("leave dialog, apply new settings and save data");
        this.okButton.setHorizontalTextPosition(0);
        this.okButton.setMargin(new Insets(0, 14, 0, 14));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("cancel");
        this.cancelButton.setToolTipText("leave the dialog without saving data");
        this.cancelButton.setHorizontalTextPosition(0);
        this.cancelButton.setMargin(new Insets(0, 14, 0, 14));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add(this.buttonPanel);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(400, 300));
        this.setLocation((screenSize.width - 400) / 2, (screenSize.height - 300) / 2);
    }

    private void clearDelayButtonActionPerformed(ActionEvent evt) {
        this.clearDelayTextField.setText("5000");
    }

    private void optionPanelComponentShown(ComponentEvent evt) {
        PropertyHelper.setTabbedComponentAttributes(this.props, this.optionPanel);
    }

    private void formComponentResized(ComponentEvent evt) {
        Control.ensureSize(this, MIN_SIZE_X, MIN_SIZE_Y);
    }

    private void fullIslandNamesCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        PropertyHelper.getTabbedComponentAttributes(this.props, this.optionPanel);
        this.propHandler.backup(this.props);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.propHandler.restore(this.props);
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        PropertyHelper.getComponentAttributes(this.props, this.optionPanel);
        this.propHandler.backup(this.props);
        this.closeDialog(null);
    }

    private void startupPanelFocusLost(FocusEvent evt) {
        this.applyButton.setEnabled(true);
    }

    private void startupPanelFocusGained(FocusEvent evt) {
        this.applyButton.setEnabled(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new OptionDialog((Frame)new JFrame(), true, new PropertyHandler(), "none").show();
    }
}

