/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.text.JTextComponent;

public abstract class PropertyHelper {
    public static boolean getGeometry(Properties target, Component source) {
        if (source == null || target == null) {
            return false;
        }
        String compName = PropertyHelper.blankToUnderscore(source.getName());
        Point compLoc = source.getLocation();
        Dimension compSize = source.getSize();
        target.setProperty(compName + ".x", String.valueOf(compLoc.x));
        target.setProperty(compName + ".y", String.valueOf(compLoc.y));
        target.setProperty(compName + ".width", String.valueOf(compSize.width));
        target.setProperty(compName + ".height", String.valueOf(compSize.height));
        return true;
    }

    public static boolean setGeometry(Properties source, Component target) {
        boolean answer = true;
        if (source == null || target == null) {
            return false;
        }
        String compName = PropertyHelper.blankToUnderscore(target.getName());
        if (source.containsKey(compName + ".x") && source.containsKey(compName + ".y")) {
            target.setLocation(Integer.parseInt(source.getProperty(compName + ".x")), Integer.parseInt(source.getProperty(compName + ".y")));
        } else {
            answer = false;
        }
        if (source.containsKey(compName + ".width") && source.containsKey(compName + ".height")) {
            target.setSize(Integer.parseInt(source.getProperty(compName + ".width")), Integer.parseInt(source.getProperty(compName + ".height")));
        } else {
            answer = false;
        }
        return answer;
    }

    public static String blankToUnderscore(String originalName) {
        if (originalName == null) {
            return originalName;
        }
        return originalName.replace(' ', '_');
    }

    public static String UnderscoreToBlank(String filteredName) {
        if (filteredName == null) {
            return filteredName;
        }
        return filteredName.replace('_', ' ');
    }

    public static boolean getSelectedState(Properties target, AbstractButton source) {
        if (source == null || target == null) {
            return false;
        }
        String compName = PropertyHelper.blankToUnderscore(source.getName());
        boolean isSelected = source.getSelectedObjects() != null;
        target.setProperty(compName, String.valueOf(isSelected));
        return true;
    }

    public static boolean setSelectedState(Properties source, AbstractButton target) {
        if (source == null || target == null) {
            return false;
        }
        String compName = PropertyHelper.blankToUnderscore(target.getName());
        if (source.containsKey(compName)) {
            target.setSelected(Boolean.valueOf(source.getProperty(compName)));
            return true;
        }
        return false;
    }

    public static boolean setTabbedComponentAttributes(Properties source, JTabbedPane target) {
        if (source == null || target == null) {
            return false;
        }
        boolean answer = false;
        Component selected = target.getSelectedComponent();
        if (selected != null) {
            answer = PropertyHelper.setComponentAttributes(source, selected);
        }
        return answer;
    }

    public static boolean getTabbedComponentAttributes(Properties target, JTabbedPane source) {
        if (source == null || target == null) {
            return false;
        }
        boolean answer = false;
        Component selected = source.getSelectedComponent();
        if (selected != null) {
            answer = PropertyHelper.getComponentAttributes(target, selected);
        }
        return answer;
    }

    public static boolean setComponentAttributes(Properties source, Component target) {
        Component[] comps;
        if (target instanceof Container && (comps = ((Container)target).getComponents()) != null) {
            int run = 0;
            while (run < comps.length) {
                PropertyHelper.setComponentAttributes(source, comps[run]);
                ++run;
            }
        }
        if (target instanceof JComponent) {
            if (target instanceof AbstractButton && target.getName() != null) {
                PropertyHelper.setSelectedState(source, (AbstractButton)target);
            } else if (target instanceof JTextComponent && source.containsKey(PropertyHelper.blankToUnderscore(target.getName()))) {
                ((JTextComponent)target).setText(source.getProperty(PropertyHelper.blankToUnderscore(target.getName())));
            }
        }
        return true;
    }

    public static boolean getComponentAttributes(Properties target, Component source) {
        Component[] comps;
        if (source instanceof Container && (comps = ((Container)source).getComponents()) != null) {
            int run = 0;
            while (run < comps.length) {
                PropertyHelper.getComponentAttributes(target, comps[run]);
                ++run;
            }
        }
        if (source instanceof JComponent) {
            if (source instanceof AbstractButton && source.getName() != null) {
                PropertyHelper.getSelectedState(target, (AbstractButton)source);
            } else if (source instanceof JTextComponent) {
                target.setProperty(PropertyHelper.blankToUnderscore(source.getName()), ((JTextComponent)source).getText());
            }
        }
        return true;
    }
}

