/*
 * Decompiled with CFR 0.152.
 */
package dream.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class StartupWindow
extends JWindow
implements ImageObserver {
    private Image image = null;
    private boolean imageIsResource = false;
    private boolean imageReady = false;
    private int sizeX = 0;
    private int sizeY = 0;
    private Toolkit tool = Toolkit.getDefaultToolkit();
    private int textX = 0;
    private int textY = 0;
    private String actualMessage = null;
    private boolean toDispose = false;

    public StartupWindow() {
    }

    public StartupWindow(String pictureResourcePath) {
        this.setCursor(new Cursor(3));
        this.importImage(pictureResourcePath);
        this.tool.prepareImage(this.image, -1, -1, this);
    }

    public void dispose() {
        this.toDispose = true;
        super.dispose();
    }

    public void setTextPosition(int x, int y) {
        this.textX = x;
        this.textY = y;
    }

    public void printMessage(String message) {
        final StartupWindow thisWindow = this;
        this.toFront();
        this.actualMessage = message;
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        thisWindow.repaint();
                    }
                });
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    public void displayImage(Image availableImage, int imageWidth, int imageHeight) {
        Dimension screenDim = null;
        final StartupWindow thisWindow = this;
        super.show();
        if (imageWidth > 0 && imageHeight > 0) {
            screenDim = this.tool.getScreenSize();
            this.setLocation(screenDim.width / 2 - imageWidth / 2, screenDim.height / 2 - imageHeight / 2);
            this.setSize(imageWidth, imageHeight);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    thisWindow.repaint();
                }
            });
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        if (this.toDispose) {
            this.dispose();
        }
    }

    public void repaint() {
        this.paint(this.getGraphics());
    }

    public void paint(Graphics g) {
        if (this.imageReady && g != null) {
            g.drawImage(this.image, 0, 0, this);
            if (this.actualMessage != null) {
                g.setColor(Color.black);
                g.drawString(this.actualMessage, this.textX, this.textY);
            }
        }
    }

    public void importImage(String pictureResourcePath) {
        boolean printErrors = true;
        try {
            this.image = this.tool.createImage(this.getClass().getResource(pictureResourcePath));
            this.imageIsResource = true;
        }
        catch (NullPointerException nex) {
            if (printErrors) {
                System.out.println("warning: image file " + pictureResourcePath + " not in classpath, loading as file.");
            }
            this.image = this.tool.createImage(pictureResourcePath);
            this.imageIsResource = false;
        }
    }

    public boolean imageUpdate(Image p1, int p2, int p3, int p4, int p5, int p6) {
        boolean answer = true;
        if ((p2 & 0x20) == 32) {
            answer = false;
            this.imageReady = true;
            this.sizeX = p5;
            this.sizeY = p6;
            this.displayImage(p1, p5, p6);
        }
        return answer;
    }

    public static void main(String[] args) {
        StartupWindow win = new StartupWindow("/dream/resources/icons/console-startup.gif");
        win.setTextPosition(10, 140);
        win.printMessage("Hallo, hier eine Nachricht!");
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        win.printMessage("Und noch eine!");
        try {
            Thread.currentThread();
            Thread.sleep(6000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        System.exit(0);
    }
}

