/*
 * Decompiled with CFR 0.152.
 */
package dream.gui.componentTree;

import dream.gui.componentTree.DreamComponent;
import dream.gui.componentTree.DreamIsland;
import dream.gui.componentTree.DreamJob;
import dream.gui.componentTree.DreamNode;
import dream.gui.componentTree.DreamThread;
import drm.agentbase.Logger;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DreamCellRenderer
extends DefaultTreeCellRenderer {
    Icon leafIcon = null;
    Icon folderClosed = null;
    Icon folderOpen = null;
    Icon nodeIcon = null;
    Icon experimentIcon = null;
    Icon islandIcon = null;
    Icon threadIcon = null;

    public DreamCellRenderer() {
        this.initIcons();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Color localColor = new Color(0.8f, 0.5f, 0.0f);
        long tooOldInfo = 3600L;
        long deleteAgeInfo = 7200L;
        DreamComponent comp = (DreamComponent)value;
        if (comp.getLevel() > 1) {
            this.setIcons(comp);
            this.setToolTipText(" last update (sec): " + comp.time.getUpdateAge() / 1000L + ", offset: " + comp.time.getMessageOffset() / 1000L + ", remote age: " + comp.time.getRemoteAge() / 1000L + ", shareCount: " + comp.shareCount);
            this.setForeground(this.getTextNonSelectionColor());
            long age = comp.time.getRemoteAge() / 1000L;
            if (comp.isLocal()) {
                if (age > 0L) {
                    this.setForeground(DreamCellRenderer.blend(localColor, Color.lightGray, 1.0f - (float)age / (float)tooOldInfo));
                } else {
                    this.setForeground(localColor);
                }
            } else if (age > deleteAgeInfo) {
                this.setForeground(Color.red);
            } else if (age > tooOldInfo) {
                this.setForeground(Color.lightGray);
            } else if (age > 0L) {
                this.setForeground(DreamCellRenderer.blend(this.getTextNonSelectionColor(), Color.lightGray, 1.0f - (float)age / (float)tooOldInfo));
            }
        } else {
            this.setToolTipText(null);
        }
        return this;
    }

    public void setIcons(DreamComponent comp) {
        if (comp instanceof DreamNode) {
            this.setIcon(this.nodeIcon);
        }
        if (comp instanceof DreamJob) {
            this.setIcon(this.experimentIcon);
        }
        if (comp instanceof DreamIsland) {
            this.setIcon(this.islandIcon);
        }
        if (comp instanceof DreamThread) {
            this.setIcon(this.threadIcon);
        }
    }

    public static Color blend(Color start, Color end, float fraction) {
        if (fraction >= 1.0f) {
            return end;
        }
        if (fraction <= 0.0f) {
            return start;
        }
        float[] startRGB = start.getRGBColorComponents(null);
        float[] endRGB = end.getRGBColorComponents(null);
        Color answer = new Color(startRGB[0] * fraction + endRGB[0] * (1.0f - fraction), startRGB[1] * fraction + endRGB[1] * (1.0f - fraction), startRGB[2] * fraction + endRGB[2] * (1.0f - fraction));
        return answer;
    }

    public void initIcons() {
        try {
            this.leafIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/component-noframe-16.gif"));
            this.folderClosed = new ImageIcon(this.getClass().getResource("/dream/resources/icons/component-box-closed-16.gif"));
            this.folderOpen = new ImageIcon(this.getClass().getResource("/dream/resources/icons/component-box-open-16.gif"));
            this.nodeIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/node-default-16.gif"));
            this.experimentIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/experiment-default-16.gif"));
            this.islandIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/island-default-16.gif"));
            this.threadIcon = new ImageIcon(this.getClass().getResource("/dream/resources/icons/agent-default-16.gif"));
            this.setLeafIcon(this.leafIcon);
            this.setClosedIcon(this.folderClosed);
            this.setOpenIcon(this.folderOpen);
        }
        catch (Exception ex) {
            Logger.warning((String)(this.getClass().getName() + "#initTree"), (String)"problem while loading tree icons.", (Throwable)ex);
        }
    }
}

