/*
 * Decompiled with CFR 0.152.
 */
package dream.gui.componentTree;

public class Timing
implements Cloneable {
    protected long updateTime = 0L;
    protected long creationTime = -1L;
    protected long distanceOffset = 0L;
    public long remoteCreation = -1L;

    public Timing() {
        long now;
        this.updateTime = now = System.currentTimeMillis();
        this.creationTime = now;
        this.remoteCreation = now;
    }

    public Timing(long remoteCreationTime) {
        long now;
        this.updateTime = now = System.currentTimeMillis();
        this.creationTime = now;
        this.remoteCreation = remoteCreationTime;
        this.distanceOffset = now - remoteCreationTime;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            System.err.println(ex);
            return null;
        }
    }

    public void update(long newRemoteTime) {
        long now;
        this.updateTime = now = System.currentTimeMillis();
        this.remoteCreation = newRemoteTime;
        this.distanceOffset = (9L * this.distanceOffset + (now - newRemoteTime)) / 10L;
    }

    public long getAge() {
        long now = System.currentTimeMillis();
        return now - this.creationTime;
    }

    public long getUpdateAge() {
        long now = System.currentTimeMillis();
        return now - this.updateTime;
    }

    public long getRemoteAge() {
        long now = System.currentTimeMillis();
        return now - this.remoteCreation;
    }

    public long getMessageOffset() {
        return this.distanceOffset;
    }
}

