/*
 * Decompiled with CFR 0.152.
 */
package dream.gui.event;

import dream.gui.event.DRMRequest;
import dream.gui.event.DRMRequestEvent;
import dream.gui.event.DRMRequestListener;
import drm.agentbase.Address;
import drm.agentbase.IRequest;
import drm.core.Node;
import java.util.Iterator;
import java.util.Vector;

public class DRMRequestHandler
implements Runnable {
    private Vector activeRequests = new Vector();
    private Node observer = null;
    public boolean shouldLive = true;
    private Vector listeners = new Vector();

    public DRMRequestHandler(Node observer) {
        this.observer = observer;
    }

    public void setNode(Node observer) {
        this.removeAllRequests();
        this.observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDRMRequestListener(DRMRequestListener toAdd) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(toAdd)) {
                this.listeners.add(toAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDRMRequestListener(DRMRequestListener toRemove) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(toRemove)) {
                this.listeners.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(DRMRequest toRemove) {
        Vector vector = this.activeRequests;
        synchronized (vector) {
            if (this.activeRequests.contains(toRemove)) {
                this.activeRequests.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequests() {
        Vector vector = this.activeRequests;
        synchronized (vector) {
            this.activeRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DRMRequest request) {
        Vector vector = this.activeRequests;
        synchronized (vector) {
            if (!this.activeRequests.contains(request)) {
                this.activeRequests.add(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListeners(DRMRequest curReq, int status, Object info) {
        DRMRequestListener currListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.listeners.size()) {
                currListener = (DRMRequestListener)this.listeners.get(i);
                currListener.requestStateChanged(new DRMRequestEvent(curReq, status, info));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Iterator reqIter = null;
        DRMRequest curReq = null;
        IRequest r = null;
        Address recipient = null;
        Vector<DRMRequest> toRemove = new Vector<DRMRequest>();
        while (this.shouldLive) {
            if (this.activeRequests.size() > 0) {
                Vector vector = this.activeRequests;
                synchronized (vector) {
                    reqIter = this.activeRequests.iterator();
                    while (reqIter.hasNext()) {
                        curReq = (DRMRequest)reqIter.next();
                        r = curReq.drmReqest;
                        recipient = curReq.target.getAddress();
                        if (r == null) {
                            if (recipient != null) {
                                curReq.drmReqest = this.observer.fireMessage(curReq.target.getAddress(), curReq.messageText, null);
                                continue;
                            }
                            toRemove.add(curReq);
                            continue;
                        }
                        int status = r.getStatus();
                        switch (status) {
                            case 1: {
                                this.callListeners(curReq, status, r.getInfo("reply"));
                                toRemove.add(curReq);
                                break;
                            }
                            case 2: {
                                this.callListeners(curReq, status, null);
                                toRemove.add(curReq);
                                break;
                            }
                        }
                    }
                }
                int i = 0;
                while (i < toRemove.size()) {
                    this.removeRequest((DRMRequest)toRemove.get(i));
                    ++i;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

