/*
 * Decompiled with CFR 0.152.
 */
package dream.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class PropertyHandler
implements Collection {
    private Vector propStore = new Vector();
    private static PropertyHandler defaultHandler = null;

    public static PropertyHandler getDefaultHandler() {
        if (defaultHandler == null) {
            defaultHandler = new PropertyHandler();
        }
        return defaultHandler;
    }

    public String getProperty(String key, String defaultValue) {
        String answer = defaultValue;
        Properties props = this.findPropertyObject(key);
        if (props != null) {
            answer = props.getProperty(key);
        }
        return answer;
    }

    public String updateProperty(String key, String newValue) {
        String answer = null;
        Properties props = this.findPropertyObject(key);
        if (props != null) {
            answer = props.getProperty(key);
            props.setProperty(key, newValue);
        }
        return answer;
    }

    public String getProperty(String key) {
        String answer = null;
        Properties props = this.findPropertyObject(key);
        if (props != null) {
            answer = props.getProperty(key);
        }
        return answer;
    }

    private Properties findPropertyObject(String key) {
        Properties answer = null;
        Iterator iter = this.propStore.iterator();
        while (iter.hasNext()) {
            PropertyLocation propLoc = (PropertyLocation)iter.next();
            if (propLoc.props.getProperty(key) == null) continue;
            answer = propLoc.props;
            break;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties add(Properties props, String propertyFileName, String id) {
        Properties answer = props;
        PropertyLocation wrap = null;
        boolean isResource = true;
        boolean printErrors = false;
        if (answer == null) {
            answer = new Properties();
        }
        try {
            try {
                answer.load(this.getClass().getResourceAsStream(propertyFileName));
            }
            catch (NullPointerException nex) {
                if (printErrors) {
                    System.out.println("warning: property file " + propertyFileName + " not in classpath, loading as file.");
                }
                answer.load(new FileInputStream(propertyFileName));
                isResource = false;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            answer = null;
        }
        if (answer != null) {
            wrap = new PropertyLocation(answer, propertyFileName, isResource, id);
            Vector vector = this.propStore;
            synchronized (vector) {
                this.propStore.add(wrap);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties create(Properties props, String propertyFileName, String id, PrintStream out) {
        Properties answer = null;
        PropertyLocation wrap = null;
        File propFile = null;
        File propDir = null;
        String dirName = propertyFileName.substring(0, propertyFileName.lastIndexOf(File.separator));
        boolean success = false;
        if (props == null) {
            props = new Properties();
        }
        answer = props;
        if (dirName != null && !(propDir = new File(dirName)).exists()) {
            success = propDir.mkdirs();
            if (out != null) {
                if (success) {
                    out.println("created directory " + dirName);
                } else {
                    out.println("failed to create directory" + dirName);
                }
            }
        }
        propFile = new File(propertyFileName);
        try {
            success = propFile.createNewFile();
            if (success) {
                if (out != null) {
                    out.println("created new property file: " + propertyFileName);
                }
            } else {
                if (out != null) {
                    out.println("creation of new property file (" + propertyFileName + ") failed.");
                }
                answer = null;
            }
        }
        catch (IOException ex) {
            if (out != null) {
                out.println(ex.toString());
            }
            answer = null;
        }
        if (answer != null && success) {
            wrap = new PropertyLocation(answer, propertyFileName, false, id);
            Vector vector = this.propStore;
            synchronized (vector) {
                this.propStore.add(wrap);
            }
        }
        return answer;
    }

    public Properties create(String propertyFileName, String id, PrintStream out) {
        return this.create(new Properties(), propertyFileName, id, out);
    }

    public Properties add(String propertyFileName, String id) {
        return this.add(null, propertyFileName, id);
    }

    public Properties fetch(String id) {
        Properties answer = null;
        if (id == null) {
            return null;
        }
        PropertyLocation sample = new PropertyLocation();
        sample.idName = id;
        if (this.propStore.contains(sample)) {
            answer = ((PropertyLocation)this.propStore.get((int)this.propStore.indexOf((Object)sample))).props;
        }
        return answer;
    }

    public Properties fetch(String propertyFileName, String id, String defaultDir, PrintStream out, String propType, Properties defaultProps) {
        Properties answer = null;
        String propName = "default";
        answer = this.fetch(id);
        if (answer != null) {
            return answer;
        }
        if (propType != null) {
            propName = propType;
        }
        String filePath = defaultDir + propertyFileName;
        if (defaultDir != "" && propertyFileName != "" && !defaultDir.endsWith("/") && !defaultDir.endsWith(File.separator)) {
            filePath = defaultDir + File.separator + propertyFileName;
        }
        if ((answer = this.add(filePath, id)) == null && (answer = this.add(propertyFileName, id)) == null) {
            answer = this.create(defaultProps, filePath, id, out);
        }
        if (out != null) {
            if (answer == null) {
                out.println("no " + propName + " property file found, " + "don't have permissions to create one in directory (" + defaultDir + ") .");
            } else {
                PropertyLocation propLoc = this.findAssociated(answer);
                String type = " property file: ";
                if (propLoc.asResource) {
                    type = " resource: ";
                }
                out.println("using " + propName + type + propLoc.path + propLoc.filename);
            }
        }
        return answer;
    }

    private PropertyLocation findAssociated(Properties props) {
        Iterator iter = this.propStore.iterator();
        while (iter.hasNext()) {
            PropertyLocation tmp = (PropertyLocation)iter.next();
            if (tmp.props != props) continue;
            return tmp;
        }
        return null;
    }

    public void backup(Properties props) {
        PropertyLocation propLoc = this.findAssociated(props);
        if (propLoc != null) {
            propLoc.backup = new Properties(propLoc.props);
        }
    }

    public Properties restore(Properties props) {
        PropertyLocation propLoc = this.findAssociated(props);
        Properties answer = null;
        if (propLoc != null) {
            if (propLoc.backup != null) {
                propLoc.props = propLoc.backup;
            }
            answer = propLoc.props;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAll() {
        boolean answer = true;
        Iterator it = this.iterator();
        Object next = null;
        PropertyLocation loc = null;
        Vector vector = this.propStore;
        synchronized (vector) {
            while (it.hasNext()) {
                next = it.next();
                if (!(next instanceof PropertyLocation)) continue;
                loc = next;
                this.save(loc);
            }
        }
        return answer;
    }

    private boolean saveToResourcePath(Properties toSave, String resourcePath, String header) {
        boolean answer;
        block2: {
            answer = false;
            URL propUrl = null;
            FileOutputStream fileOut = null;
            propUrl = this.getClass().getResource(resourcePath);
            if (propUrl == null || toSave == null) break block2;
            try {
                fileOut = new FileOutputStream(propUrl.getFile());
                toSave.store(fileOut, header);
                answer = true;
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
        }
        return answer;
    }

    private boolean saveToFile(Properties toSave, String filename, String header) {
        boolean answer;
        block2: {
            answer = false;
            FileOutputStream fileOut = null;
            if (toSave == null) break block2;
            try {
                fileOut = new FileOutputStream(filename);
                toSave.store(fileOut, header);
                answer = true;
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(Object o) {
        boolean answer = false;
        PropertyLocation save = null;
        if (o instanceof Properties) {
            save = this.findAssociated((Properties)o);
        } else if (o instanceof PropertyLocation) {
            save = (PropertyLocation)o;
        }
        if (save != null && save.dirty) {
            PropertyLocation propertyLocation = save;
            synchronized (propertyLocation) {
                answer = save.asResource ? this.saveToResourcePath(save.props, save.path + save.filename, null) : this.saveToFile(save.props, save.path + save.filename, null);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(Collection c) {
        boolean answer = true;
        Vector vector = this.propStore;
        synchronized (vector) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                boolean bl = answer = answer && this.save(iter.next());
            }
        }
        return answer;
    }

    public int size() {
        return this.propStore.size();
    }

    public boolean isEmpty() {
        return this.propStore.isEmpty();
    }

    public boolean contains(Object o) {
        return this.propStore.contains(o);
    }

    public Iterator iterator() {
        return this.propStore.iterator();
    }

    public Object[] toArray() {
        return this.propStore.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.propStore.toArray(a);
    }

    public boolean add(Object o) {
        return this.propStore.add(o);
    }

    public boolean remove(Object o) {
        return this.propStore.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.propStore.containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this.propStore.addAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.propStore.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.propStore.retainAll(c);
    }

    public void clear() {
        this.propStore.clear();
        this.propStore = new Vector();
    }

    public boolean equals(Object o) {
        return this.propStore.equals(o);
    }

    public int hashCode() {
        return this.propStore.hashCode();
    }

    class PropertyLocation {
        Properties props = null;
        String filename = null;
        String path = "";
        boolean asResource = false;
        String idName = null;
        boolean dirty = true;
        Properties backup = null;

        PropertyLocation() {
        }

        PropertyLocation(Properties importProps, String importedFile, boolean isResource, String idName) {
            int pathEnd;
            this.props = importProps;
            this.filename = importedFile;
            this.asResource = isResource;
            if (idName == null || idName.length() == 0) {
                idName = "id" + this.hashCode() + System.currentTimeMillis();
                System.err.println("PropertyHandler$PropertyLocation#constructor warning: no id given, generating one: " + idName);
            }
            this.idName = idName;
            if (this.filename != null && (pathEnd = this.filename.lastIndexOf(File.separator)) >= 0) {
                this.path = this.filename.substring(0, pathEnd + 1);
                this.filename = this.filename.substring(pathEnd + 1);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PropertyLocation)) {
                return false;
            }
            if (((PropertyLocation)obj).idName == null) {
                return false;
            }
            if (((PropertyLocation)obj).idName.length() < 1) {
                return false;
            }
            return this.idName.compareTo(((PropertyLocation)obj).idName) == 0;
        }
    }
}

