/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.BreedingSource;
import ec.EvolutionState;
import ec.Population;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;

public abstract class BreedingPipeline
extends BreedingSource
implements SteadyStateBSourceForm {
    private static final long serialVersionUID = 1L;
    public static final String V_SAME = "same";
    public static final String V_STUB = "stub";
    public static final String P_LIKELIHOOD = "likelihood";
    public static final int DYNAMIC_SOURCES = -1;
    public static final String P_NUMSOURCES = "num-sources";
    public static final String P_SOURCE = "source";
    public Parameter mybase;
    public double likelihood;
    public BreedingSource[] sources;

    public abstract int numSources();

    public int minChildProduction() {
        if (this.sources.length == 0) {
            return 0;
        }
        int min = this.sources[0].typicalIndsProduced();
        for (int x = 1; x < this.sources.length; ++x) {
            int cur = this.sources[x].typicalIndsProduced();
            if (min <= cur) continue;
            min = cur;
        }
        return min;
    }

    public int maxChildProduction() {
        if (this.sources.length == 0) {
            return 0;
        }
        int max = this.sources[0].typicalIndsProduced();
        for (int x = 1; x < this.sources.length; ++x) {
            int cur = this.sources[x].typicalIndsProduced();
            if (max >= cur) continue;
            max = cur;
        }
        return max;
    }

    @Override
    public void fillStubs(EvolutionState state, BreedingSource source) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (this.sources[x] == null) {
                if (source == null) {
                    state.output.fatal("BreedingPipeline needed to fill a stub, but no BreedingSource was provided to fill it.\nThis is probably because no parent pipeline was a StubPipeline.");
                }
                this.sources[x] = source;
                continue;
            }
            this.sources[x].fillStubs(state, source);
        }
    }

    @Override
    public int typicalIndsProduced() {
        return this.minChildProduction();
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int numsources;
        super.setup(state, base);
        this.mybase = base;
        Parameter def = this.defaultBase();
        this.likelihood = state.parameters.getDoubleWithDefault(base.push(P_LIKELIHOOD), def.push(P_LIKELIHOOD), 1.0);
        if (this.likelihood < 0.0 || this.likelihood > 1.0) {
            state.output.fatal("Breeding Pipeline likelihood must be a value between 0.0 and 1.0 inclusive", base.push(P_LIKELIHOOD), def.push(P_LIKELIHOOD));
        }
        if ((numsources = this.numSources()) == -1) {
            numsources = state.parameters.getInt(base.push(P_NUMSOURCES), def.push(P_NUMSOURCES), 0);
            if (numsources == -1) {
                state.output.fatal("Breeding pipeline num-sources value must exist and be >= 0", base.push(P_NUMSOURCES), def.push(P_NUMSOURCES));
            }
        } else {
            if (numsources <= -1) {
                throw new RuntimeException("In " + String.valueOf(this) + " numSources() returned < DYNAMIC_SOURCES (that is, < -1)");
            }
            if (state.parameters.exists(base.push(P_NUMSOURCES), def.push(P_NUMSOURCES))) {
                state.output.warning("Breeding pipeline's number of sources is hard-coded to " + numsources + " yet num-sources was provided: num-sources will be ignored.", base.push(P_NUMSOURCES), def.push(P_NUMSOURCES));
            }
        }
        this.sources = new BreedingSource[numsources];
        for (int x = 0; x < this.sources.length; ++x) {
            Parameter d;
            Parameter p = base.push(P_SOURCE).push("" + x);
            String s = state.parameters.getString(p, d = def.push(P_SOURCE).push("" + x));
            if (s != null && s.equals(V_SAME)) {
                if (x == 0) {
                    state.output.fatal("Source #0 cannot be declared with the value \"same\".", p, d);
                }
                this.sources[x] = this.sources[x - 1];
                continue;
            }
            if (s != null && s.equals(V_STUB)) {
                this.sources[x] = null;
                continue;
            }
            this.sources[x] = (BreedingSource)state.parameters.getInstanceForParameter(p, d, BreedingSource.class);
            this.sources[x].setup(state, p);
        }
        state.output.exitIfErrors();
    }

    @Override
    public Object clone() {
        BreedingPipeline c = (BreedingPipeline)super.clone();
        c.sources = new BreedingSource[this.sources.length];
        for (int x = 0; x < this.sources.length; ++x) {
            if (this.sources[x] == null) continue;
            c.sources[x] = x == 0 || this.sources[x] != this.sources[x - 1] ? (BreedingSource)this.sources[x].clone() : c.sources[x - 1];
        }
        return c;
    }

    @Override
    public boolean produces(EvolutionState state, Population newpop, int subpopulation, int thread) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (x != 0 && this.sources[x] == this.sources[x - 1] || this.sources[x].produces(state, newpop, subpopulation, thread)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (this.sources[x] == null) {
                state.output.fatal("Stub not filled in Breeding Pipeline.");
            }
            if (x != 0 && this.sources[x] == this.sources[x - 1]) continue;
            this.sources[x].prepareToProduce(state, subpopulation, thread);
        }
    }

    @Override
    public void finishProducing(EvolutionState state, int subpopulation, int thread) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (x != 0 && this.sources[x] == this.sources[x - 1]) continue;
            this.sources[x].finishProducing(state, subpopulation, thread);
        }
    }

    @Override
    public void preparePipeline(Object hook) {
        for (int x = 0; x < this.sources.length; ++x) {
            this.sources[x].preparePipeline(hook);
        }
    }

    @Override
    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
        for (int x = 0; x < this.sources.length; ++x) {
            ((SteadyStateBSourceForm)((Object)this.sources[x])).individualReplaced(state, subpopulation, thread, individual);
        }
    }

    @Override
    public void sourcesAreProperForm(SteadyStateEvolutionState state) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (!(this.sources[x] instanceof SteadyStateBSourceForm)) {
                state.output.error("The following breeding source is not of SteadyStateBSourceForm.", this.mybase.push(P_SOURCE).push("" + x), this.defaultBase().push(P_SOURCE).push("" + x));
                continue;
            }
            ((SteadyStateBSourceForm)((Object)this.sources[x])).sourcesAreProperForm(state);
        }
    }
}

