/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.Singleton;
import ec.Subpopulation;
import ec.eval.MasterProblem;
import ec.util.Parameter;

public abstract class Evaluator
implements Singleton {
    private static final long serialVersionUID = 1L;
    public static final String P_PROBLEM = "problem";
    public Problem p_problem;
    public MasterProblem masterproblem = null;
    public static final String P_MASTERPROBLEM = "masterproblem";
    public static final String P_IAMSLAVE = "i-am-slave";
    public String runComplete;

    public abstract void evaluatePopulation(EvolutionState var1);

    public abstract String runComplete(EvolutionState var1);

    public void setRunComplete(String message) {
        this.runComplete = message;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        this.p_problem = (Problem)state.parameters.getInstanceForParameter(base.push(P_PROBLEM), null, Problem.class);
        this.p_problem.setup(state, base.push(P_PROBLEM));
        if (state.parameters.exists(base.push(P_MASTERPROBLEM), null)) {
            this.masterproblem = (MasterProblem)state.parameters.getInstanceForParameter(base.push(P_MASTERPROBLEM), null, Problem.class);
            this.masterproblem.setup(state, base.push(P_MASTERPROBLEM));
            this.masterproblem.problem = this.p_problem;
            if (!state.parameters.getBoolean(base.push(P_IAMSLAVE), null, false)) {
                this.p_problem = this.masterproblem;
            }
        }
    }

    public void initializeContacts(EvolutionState state) {
        this.p_problem.initializeContacts(state);
    }

    public void reinitializeContacts(EvolutionState state) {
        this.p_problem.reinitializeContacts(state);
    }

    public void closeContacts(EvolutionState state, int result) {
        this.p_problem.closeContacts(state, result);
    }

    public void postEvaluationGlobalUpdate(EvolutionState state) {
        assert (state != null);
        assert (state.population != null);
        assert (state.population.subpops != null);
        for (Subpopulation subpop : state.population.subpops) {
            subpop.species.updateSubpopulation(state, subpop);
        }
    }

    public void postEvaluationLocalUpdate(EvolutionState state, Individual ind, int subpop) {
        assert (state != null);
        assert (state.population != null);
        assert (state.population.subpops != null);
        assert (state.population.subpops.size() > subpop);
        state.population.subpops.get((int)subpop).species.updateIndividual(state, ind);
    }
}

