/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Fitness;
import ec.Prototype;
import ec.Species;
import ec.util.Code;
import ec.util.DataPipe;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public abstract class Individual
implements Prototype,
Comparable<Individual> {
    private static final long serialVersionUID = 1L;
    public static final String P_INDIVIDUAL = "individual";
    public static final String EVALUATED_PREAMBLE = "Evaluated: ";
    public Fitness fitness;
    public Species species;
    public boolean evaluated;

    @Override
    public Object clone() {
        try {
            Individual myobj = (Individual)super.clone();
            if (myobj.fitness != null) {
                myobj.fitness = (Fitness)this.fitness.clone();
            }
            return myobj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public long size() {
        return 0L;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{" + this.hashCode() + "}";
    }

    public String genotypeToStringForHumans() {
        return this.toString();
    }

    public String genotypeToString() {
        return this.toString();
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
    }

    public void printIndividualForHumans(EvolutionState state, int log) {
        state.output.println(EVALUATED_PREAMBLE + Code.encode(this.evaluated), log);
        this.fitness.printFitnessForHumans(state, log);
        state.output.println(this.genotypeToStringForHumans(), log);
    }

    public final void printIndividualForHumans(EvolutionState state, int log, int verbosity) {
        this.printIndividualForHumans(state, log);
    }

    public void printIndividual(EvolutionState state, int log) {
        state.output.println(EVALUATED_PREAMBLE + Code.encode(this.evaluated), log);
        this.fitness.printFitness(state, log);
        state.output.println(this.genotypeToString(), log);
    }

    public final void printIndividual(EvolutionState state, int log, int verbosity) {
        this.printIndividual(state, log);
    }

    public void printIndividual(EvolutionState state, PrintWriter writer) {
        writer.println(EVALUATED_PREAMBLE + Code.encode(this.evaluated));
        this.fitness.printFitness(state, writer);
        writer.println(this.genotypeToString());
    }

    public void readIndividual(EvolutionState state, LineNumberReader reader) throws IOException {
        this.evaluated = Code.readBooleanWithPreamble(EVALUATED_PREAMBLE, state, reader);
        this.fitness.readFitness(state, reader);
        this.parseGenotype(state, reader);
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        state.output.fatal("parseGenotype(EvolutionState, LineNumberReader) not implemented in " + String.valueOf(this.getClass()));
    }

    public void writeIndividual(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.evaluated);
        this.fitness.writeFitness(state, dataOutput);
        this.writeGenotype(state, dataOutput);
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        state.output.fatal("writeGenotype(EvolutionState, DataOutput) not implemented in " + String.valueOf(this.getClass()));
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        state.output.fatal("readGenotype(EvolutionState, DataOutput) not implemented in " + String.valueOf(this.getClass()));
    }

    public void readIndividual(EvolutionState state, DataInput dataInput) throws IOException {
        this.evaluated = dataInput.readBoolean();
        this.fitness.readFitness(state, dataInput);
        this.readGenotype(state, dataInput);
    }

    public double distanceTo(Individual otherInd) {
        return this.equals(otherInd) ? 0.0 : Double.POSITIVE_INFINITY;
    }

    @Override
    public int compareTo(Individual o) {
        Individual other = o;
        return this.fitness.compareTo(other.fitness);
    }

    public void merge(EvolutionState state, Individual other) {
        other.fitness.merge(state, this.fitness);
        try {
            DataPipe p = new DataPipe();
            DataInputStream in = p.input;
            DataOutputStream out = p.output;
            other.writeIndividual(state, out);
            this.readIndividual(state, in);
        }
        catch (IOException e) {
            e.printStackTrace();
            state.output.fatal("Caught impossible IOException in Individual.merge(...).");
        }
    }
}

