/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Setup;
import ec.Subpopulation;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class Population
implements Cloneable,
Setup {
    private static final long serialVersionUID = 1L;
    public ArrayList<Subpopulation> subpops = new ArrayList();
    public static final String P_SIZE = "subpops";
    public static final String P_SUBPOP = "subpop";
    public static final String P_DEFAULT_SUBPOP = "default-subpop";
    public static final String P_FILE = "file";
    public static final String NUM_SUBPOPS_PREAMBLE = "Number of Subpopulations: ";
    public static final String SUBPOP_INDEX_PREAMBLE = "Subpopulation Number: ";
    public boolean loadInds;
    public Parameter file;

    public Population emptyClone() {
        try {
            Population p = (Population)this.clone();
            p.subpops = new ArrayList(this.subpops.size());
            for (int x = 0; x < this.subpops.size(); ++x) {
                p.subpops.add(this.subpops.get(x).emptyClone());
            }
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void clear() {
        for (int x = 0; x < this.subpops.size(); ++x) {
            this.subpops.get(x).clear();
        }
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        this.file = base.push(P_FILE);
        this.loadInds = state.parameters.exists(this.file, null);
        Parameter p = base.push(P_SIZE);
        int size = state.parameters.getInt(p, null, 1);
        if (size <= 0) {
            state.output.fatal("Population size must be >0.\n", base.push(P_SIZE));
        }
        this.subpops = new ArrayList(this.subpops.size());
        for (int x = 0; x < size; ++x) {
            int defaultSubpop;
            p = base.push(P_SUBPOP).push("" + x);
            if (!state.parameters.exists(p, null) && (defaultSubpop = state.parameters.getInt(p = base.push(P_DEFAULT_SUBPOP), null, 0)) >= 0) {
                state.output.warning("Using subpopulation " + defaultSubpop + " as the default for subpopulation " + x);
                p = base.push(P_SUBPOP).push("" + defaultSubpop);
            }
            this.subpops.add((Subpopulation)state.parameters.getInstanceForParameterEq(p, null, Subpopulation.class));
            this.subpops.get(x).setup(state, p);
            if (!this.loadInds || !this.subpops.get((int)x).loadInds) continue;
            state.output.fatal("Both a subpopulation and its parent population have been told to load from files.  This can't happen.  It's got to be one or the other.", base.push(P_FILE), null);
        }
    }

    public void populate(EvolutionState state, int thread) {
        if (this.loadInds) {
            InputStream stream = state.parameters.getResource(this.file, null);
            if (stream == null) {
                state.output.fatal("Could not load population from file", this.file);
            }
            try {
                this.readPopulation(state, new LineNumberReader(new InputStreamReader(stream)));
            }
            catch (IOException e) {
                state.output.fatal("An IOException occurred when trying to read from the file " + state.parameters.getString(this.file, null) + ".  The IOException was: \n" + String.valueOf(e), this.file, null);
            }
        } else {
            for (int x = 0; x < this.subpops.size(); ++x) {
                this.subpops.get(x).populate(state, thread);
            }
        }
    }

    public final void printPopulationForHumans(EvolutionState state, int log, int verbosity) {
        this.printPopulationForHumans(state, log);
    }

    public final void printPopulation(EvolutionState state, int log, int verbosity) {
        this.printPopulation(state, log);
    }

    public void printPopulationForHumans(EvolutionState state, int log) {
        state.output.println(NUM_SUBPOPS_PREAMBLE + this.subpops.size(), log);
        for (int i = 0; i < this.subpops.size(); ++i) {
            state.output.println(SUBPOP_INDEX_PREAMBLE + i, log);
            this.subpops.get(i).printSubpopulationForHumans(state, log);
        }
    }

    public void printPopulation(EvolutionState state, int log) {
        state.output.println(NUM_SUBPOPS_PREAMBLE + Code.encode(this.subpops.size()), log);
        for (int i = 0; i < this.subpops.size(); ++i) {
            state.output.println(SUBPOP_INDEX_PREAMBLE + Code.encode(i), log);
            this.subpops.get(i).printSubpopulation(state, log);
        }
    }

    public void printPopulation(EvolutionState state, PrintWriter writer) {
        writer.println(NUM_SUBPOPS_PREAMBLE + Code.encode(this.subpops.size()));
        for (int i = 0; i < this.subpops.size(); ++i) {
            writer.println(SUBPOP_INDEX_PREAMBLE + Code.encode(i));
            this.subpops.get(i).printSubpopulation(state, writer);
        }
    }

    public void readPopulation(EvolutionState state, LineNumberReader reader) throws IOException {
        int numSubpops = Code.readIntegerWithPreamble(NUM_SUBPOPS_PREAMBLE, state, reader);
        if (numSubpops != this.subpops.size()) {
            state.output.fatal("On reading population from text stream, the number of subpopulations was wrong.");
        }
        for (int i = 0; i < this.subpops.size(); ++i) {
            int j = Code.readIntegerWithPreamble(SUBPOP_INDEX_PREAMBLE, state, reader);
            if (j != i) {
                state.output.warnOnce("On reading population from text stream, some subpopulation indexes in the population did not match.");
            }
            this.subpops.get(i).readSubpopulation(state, reader);
        }
    }

    public void writePopulation(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.subpops.size());
        for (int i = 0; i < this.subpops.size(); ++i) {
            this.subpops.get(i).writeSubpopulation(state, dataOutput);
        }
    }

    public void readPopulation(EvolutionState state, DataInput dataInput) throws IOException {
        int numSubpopulations = dataInput.readInt();
        if (numSubpopulations != this.subpops.size()) {
            state.output.fatal("On reading subpopulation from binary stream, the number of subpopulations was wrong.");
        }
        for (int i = 0; i < this.subpops.size(); ++i) {
            this.subpops.get(i).readSubpopulation(state, dataInput);
        }
    }
}

