/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.ECDefaults;
import ec.EvolutionState;
import ec.Individual;
import ec.Setup;
import ec.Species;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class Subpopulation
implements Cloneable,
Setup {
    private static final long serialVersionUID = 1L;
    public boolean loadInds;
    public Parameter file;
    public Species species;
    public ArrayList<Individual> individuals;
    public int initialSize;
    public int numDuplicateRetries;
    public int extraBehavior;
    public static final String P_SUBPOPULATION = "subpop";
    public static final String P_FILE = "file";
    public static final String P_SUBPOPSIZE = "size";
    public static final String P_SPECIES = "species";
    public static final String P_RETRIES = "duplicate-retries";
    public static final String P_EXTRA_BEHAVIOR = "extra-behavior";
    public static final String V_TRUNCATE = "truncate";
    public static final String V_WRAP = "wrap";
    public static final String V_FILL = "fill";
    public static final String NUM_INDIVIDUALS_PREAMBLE = "Number of Individuals: ";
    public static final String INDIVIDUAL_INDEX_PREAMBLE = "Individual Number: ";
    public static final int TRUNCATE = 0;
    public static final int WRAP = 1;
    public static final int FILL = 2;
    boolean warned = false;

    public Parameter defaultBase() {
        return ECDefaults.base().push(P_SUBPOPULATION);
    }

    public Subpopulation emptyClone() {
        try {
            Subpopulation p = (Subpopulation)this.clone();
            p.species = this.species;
            p.individuals = new ArrayList();
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void truncate(int toThis) {
        for (int i = this.individuals.size() - 1; i >= toThis; --i) {
            this.individuals.remove(i);
        }
        assert (this.individuals.size() == toThis);
    }

    public void clear() {
        this.individuals.clear();
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.file = base.push(P_FILE);
        this.loadInds = state.parameters.exists(this.file, null);
        this.initialSize = state.parameters.getInt(base.push(P_SUBPOPSIZE), def.push(P_SUBPOPSIZE), 1);
        if (this.initialSize <= 0) {
            state.output.fatal("Subpopulation size must be an integer >= 1.\n", base.push(P_SUBPOPSIZE), def.push(P_SUBPOPSIZE));
        }
        this.species = (Species)state.parameters.getInstanceForParameter(base.push(P_SPECIES), def.push(P_SPECIES), Species.class);
        this.species.setup(state, base.push(P_SPECIES));
        this.numDuplicateRetries = state.parameters.getInt(base.push(P_RETRIES), def.push(P_RETRIES), 0);
        if (this.numDuplicateRetries < 0) {
            state.output.fatal("The number of retries for duplicates must be an integer >= 0.\n", base.push(P_RETRIES), def.push(P_RETRIES));
        }
        this.individuals = new ArrayList();
        this.extraBehavior = 0;
        if (this.loadInds) {
            String extra = state.parameters.getStringWithDefault(base.push(P_EXTRA_BEHAVIOR), def.push(P_EXTRA_BEHAVIOR), null);
            if (extra == null) {
                state.output.warning("Subpopulation is reading from a file, but no extra-behavior provided.  By default, subpopulation will be truncated to fit the file size.");
            } else if (extra.equalsIgnoreCase(V_TRUNCATE)) {
                this.extraBehavior = 0;
            } else if (extra.equalsIgnoreCase(V_FILL)) {
                this.extraBehavior = 2;
            } else if (extra.equalsIgnoreCase(V_WRAP)) {
                this.extraBehavior = 1;
            } else {
                state.output.fatal("Subpopulation given a bad extra-behavior: " + extra, base.push(P_EXTRA_BEHAVIOR), def.push(P_EXTRA_BEHAVIOR));
            }
        }
    }

    public void populate(EvolutionState state, int thread) {
        int len = this.initialSize;
        int start = 0;
        if (this.loadInds) {
            InputStream stream = state.parameters.getResource(this.file, null);
            if (stream == null) {
                state.output.fatal("Could not load subpopulation from file", this.file);
            }
            try {
                this.readSubpopulation(state, new LineNumberReader(new InputStreamReader(stream)));
            }
            catch (IOException e) {
                state.output.fatal("An IOException occurred when trying to read from the file " + state.parameters.getString(this.file, null) + ".  The IOException was: \n" + String.valueOf(e), this.file, null);
            }
            if (len < this.individuals.size()) {
                state.output.message("Old subpopulation was of size " + len + ", expanding to size " + this.individuals.size());
                return;
            }
            if (len > this.individuals.size()) {
                if (this.extraBehavior == 0) {
                    state.output.message("Old subpopulation was of size " + len + ", truncating to size " + this.individuals.size());
                    return;
                }
                if (this.extraBehavior == 1) {
                    state.output.message("Only " + this.individuals.size() + " individuals were read in.  Subpopulation will stay size " + len + ", and the rest will be filled with copies of the read-in individuals.");
                    start = this.individuals.size();
                    int count = 0;
                    for (int i = start; i < len; ++i) {
                        this.individuals.add((Individual)this.individuals.get(count).clone());
                        if (++count < start) continue;
                        count = 0;
                    }
                    return;
                }
                state.output.message("Only " + this.individuals.size() + " individuals were read in.  Subpopulation will stay size " + len + ", and the rest will be filled using randomly generated individuals.");
                start = this.individuals.size();
            } else {
                return;
            }
        }
        HashMap<Individual, Individual> h = null;
        if (this.numDuplicateRetries >= 1) {
            h = new HashMap<Individual, Individual>((len - start) / 2);
        }
        for (int x = start; x < len; ++x) {
            Individual newInd = null;
            for (int tries = 0; tries <= this.numDuplicateRetries; ++tries) {
                Object o;
                newInd = this.species.newIndividual(state, thread);
                if (this.numDuplicateRetries < 1 || (o = h.get(newInd)) != null) continue;
                h.put(newInd, newInd);
                break;
            }
            this.individuals.add(newInd);
        }
    }

    public final void printSubpopulationForHumans(EvolutionState state, int log, int verbosity) {
        this.printSubpopulationForHumans(state, log);
    }

    public final void printSubpopulation(EvolutionState state, int log, int verbosity) {
        this.printSubpopulation(state, log);
    }

    public void printSubpopulationForHumans(EvolutionState state, int log) {
        state.output.println(NUM_INDIVIDUALS_PREAMBLE + this.individuals.size(), log);
        for (int i = 0; i < this.individuals.size(); ++i) {
            state.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i), log);
            if (this.individuals.get(i) != null) {
                this.individuals.get(i).printIndividualForHumans(state, log);
                continue;
            }
            if (this.warned) continue;
            state.output.warnOnce("Null individuals found in subpopulation");
            this.warned = true;
        }
    }

    public void printSubpopulation(EvolutionState state, int log) {
        state.output.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.size()), log);
        for (int i = 0; i < this.individuals.size(); ++i) {
            state.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i), log);
            this.individuals.get(i).printIndividual(state, log);
        }
    }

    public void printSubpopulation(EvolutionState state, PrintWriter writer) {
        writer.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.size()));
        for (int i = 0; i < this.individuals.size(); ++i) {
            writer.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i));
            this.individuals.get(i).printIndividual(state, writer);
        }
    }

    public void readSubpopulation(EvolutionState state, LineNumberReader reader) throws IOException {
        int numIndividuals = Code.readIntegerWithPreamble(NUM_INDIVIDUALS_PREAMBLE, state, reader);
        if (numIndividuals < 1) {
            state.output.fatal("On reading subpopulation from text stream, the subpopulation size must be >= 1.  The provided value was: " + numIndividuals + ".");
        }
        if (numIndividuals != this.individuals.size()) {
            state.output.warnOnce("On reading subpopulation from text stream, the current subpopulation size (" + this.individuals.size() + " didn't match the number of individuals in the file (" + numIndividuals + ") and so the subpopulation size will change.");
        }
        this.individuals = new ArrayList();
        for (int i = 0; i < numIndividuals; ++i) {
            int j = Code.readIntegerWithPreamble(INDIVIDUAL_INDEX_PREAMBLE, state, reader);
            if (j != i) {
                state.output.warnOnce("On reading subpopulation from text stream, some individual indexes in the subpopulation did not match.  The first was individual " + i + ", which is listed in the file as " + j);
            }
            this.individuals.add(this.species.newIndividual(state, reader));
        }
    }

    public void writeSubpopulation(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.individuals.size());
        for (int i = 0; i < this.individuals.size(); ++i) {
            this.individuals.get(i).writeIndividual(state, dataOutput);
        }
    }

    public void readSubpopulation(EvolutionState state, DataInput dataInput) throws IOException {
        int numIndividuals = dataInput.readInt();
        if (numIndividuals != this.individuals.size()) {
            state.output.warnOnce("On reading subpopulation from binary stream, the subpopulation size was incorrect.\nHad to resize and use newIndividual() instead of readIndividual().");
            this.individuals = new ArrayList();
            for (int i = 0; i < numIndividuals; ++i) {
                this.individuals.add(this.species.newIndividual(state, dataInput));
            }
        } else {
            for (int i = 0; i < this.individuals.size(); ++i) {
                this.individuals.get(i).readIndividual(state, dataInput);
            }
        }
    }
}

