/*
 * Decompiled with CFR 0.152.
 */
package ec.app.cartpole;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.neat.NEATIndividual;
import ec.neat.NEATNetwork;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;

public class CartPole
extends Problem
implements SimpleProblemForm {
    int MAX_STEPS = 100000;
    double x;
    double x_dot;
    double theta;
    double theta_dot;
    int steps = 0;
    int y;

    public double[] getNetOutput(NEATNetwork net, double[][] in, EvolutionState state) {
        int netDepth = net.maxDepth();
        net.loadSensors(in[0]);
        for (int relax = 0; relax < netDepth; ++relax) {
            net.activate(state);
        }
        double[] out = net.getOutputResults();
        net.flush();
        return out;
    }

    public int runCartPole(NEATNetwork net, EvolutionState state) {
        double twelve_degrees = 0.2094384;
        this.theta_dot = 0.0;
        this.theta = 0.0;
        this.x_dot = 0.0;
        this.x = 0.0;
        this.steps = 0;
        double[][] in = new double[1][5];
        while (this.steps++ < this.MAX_STEPS) {
            in[0][0] = 1.0;
            in[0][1] = (this.x + 2.4) / 4.8;
            in[0][2] = (this.x_dot + 0.75) / 1.5;
            in[0][3] = (this.theta + twelve_degrees) / 0.41;
            in[0][4] = (this.theta_dot + 1.0) / 2.0;
            double[] out = this.getNetOutput(net, in, state);
            this.y = out[0] > out[1] ? 0 : 1;
            this.cart_pole(this.y);
            if (!(this.x < -2.4 || this.x > 2.4 || this.theta < -twelve_degrees) && !(this.theta > twelve_degrees)) continue;
            return this.steps;
        }
        return this.steps;
    }

    void cart_pole(int action) {
        double GRAVITY = 9.8;
        double MASSCART = 1.0;
        double MASSPOLE = 0.1;
        double TOTAL_MASS = 1.1;
        double LENGTH = 0.5;
        double POLEMASS_LENGTH = 0.05;
        double FORCE_MAG = 10.0;
        double TAU = 0.02;
        double FOURTHIRDS = 1.3333333333333;
        double force = action > 0 ? 10.0 : -10.0;
        double costheta = Math.cos(this.theta);
        double sintheta = Math.sin(this.theta);
        double temp = (force + 0.05 * this.theta_dot * this.theta_dot * sintheta) / 1.1;
        double thetaacc = (9.8 * sintheta - costheta * temp) / (0.5 * (1.3333333333333 - 0.1 * costheta * costheta / 1.1));
        double xacc = temp - 0.05 * thetaacc * costheta / 1.1;
        this.x += 0.02 * this.x_dot;
        this.x_dot += 0.02 * xacc;
        this.theta += 0.02 * this.theta_dot;
        this.theta_dot += 0.02 * thetaacc;
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (ind.evaluated) {
            return;
        }
        if (!(ind instanceof NEATIndividual)) {
            state.output.fatal("Whoa! It's not a NEATIndividual!!!", null);
        }
        NEATIndividual neatInd = (NEATIndividual)ind;
        if (!(neatInd.fitness instanceof SimpleFitness)) {
            state.output.fatal("Whoa! It's not a SimpleFitness!!!", null);
        }
        NEATNetwork net = neatInd.createNetwork();
        double fitness = this.runCartPole(net, state);
        ((SimpleFitness)neatInd.fitness).setFitness(state, fitness, fitness >= (double)this.MAX_STEPS);
        neatInd.evaluated = true;
    }
}

