/*
 * Decompiled with CFR 0.152.
 */
package ec.app.highdimension;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.eda.dovs.DOVSFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;

public class HighDimension
extends Problem
implements SimpleProblemForm {
    public static final String P_HIGHDIMENSION = "high-dimension";

    @Override
    public Parameter defaultBase() {
        return super.defaultBase().push(P_HIGHDIMENSION);
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        int[] genome;
        if (!(ind instanceof IntegerVectorIndividual)) {
            state.output.fatal("Whoa!  It's not an IntegerVectorIndividual!!!", null);
        }
        if ((genome = ((IntegerVectorIndividual)ind).genome).length != 5) {
            state.output.fatal("Whoa! The size of the genome is not right!!!", null);
        }
        double gamma = 0.001;
        long xi = 0L;
        double beta = 10000.0;
        double g = 0.0;
        double sum = 0.0;
        for (int j = 0; j < genome.length; ++j) {
            sum += (double)(((long)genome[j] - xi) * ((long)genome[j] - xi)) * gamma;
        }
        g = beta * Math.exp(-sum);
        double variance = g * 0.09;
        double noise = variance < 1.0E-30 ? 0.0 : state.random[0].nextGaussian() * variance;
        ((DOVSFitness)ind.fitness).recordObservation(state, g);
        ind.evaluated = true;
    }
}

