/*
 * Decompiled with CFR 0.152.
 */
package ec.app.knapsack;

import ec.EvolutionState;
import ec.co.Component;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class KnapsackComponent
extends Component {
    private double size;
    private double value;

    public KnapsackComponent(double size, double value) {
        if (size <= 0.0 || !Double.isFinite(size)) {
            throw new IllegalArgumentException(String.format("%s: attempted to create a component with size %f, but must be positive and finite.", this.getClass().getSimpleName(), size));
        }
        if (value <= 0.0 || !Double.isFinite(value)) {
            throw new IllegalArgumentException(String.format("%s: attempted to create a component with value %f, but must be positive and finite.", this.getClass().getSimpleName(), value));
        }
        this.size = size;
        this.value = value;
        assert (this.repOK());
    }

    public double size() {
        assert (this.repOK());
        return this.size;
    }

    public double value() {
        assert (this.repOK());
        return this.value;
    }

    @Override
    public double desirability() {
        assert (this.repOK());
        return this.value;
    }

    @Override
    public void writeComponent(EvolutionState state, DataOutput output) throws IOException {
        output.writeDouble(this.size);
        output.writeDouble(this.value);
    }

    @Override
    public Component readComponent(EvolutionState state, DataInput input) throws IOException {
        double size = input.readDouble();
        double value = input.readDouble();
        return new KnapsackComponent(size, value);
    }

    public final boolean repOK() {
        return this.size > 0.0 && Double.isFinite(this.size) && this.value > 0.0 && Double.isFinite(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof KnapsackComponent)) {
            return false;
        }
        KnapsackComponent ref = (KnapsackComponent)o;
        return this.size == ref.size && this.value == ref.value;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.size) ^ Double.doubleToLongBits(this.size) >>> 32);
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return hash;
    }

    public String toString() {
        return String.format("%s[size=%f, value=%f]", this.getClass().getSimpleName(), this.size, this.value);
    }
}

