/*
 * Decompiled with CFR 0.152.
 */
package ec.app.knapsack;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.app.knapsack.KnapsackComponent;
import ec.co.Component;
import ec.co.ConstructiveIndividual;
import ec.co.ConstructiveProblemForm;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.List;

public class KnapsackProblem
extends Problem
implements SimpleProblemForm,
ConstructiveProblemForm {
    public static final String P_SIZES = "sizes";
    public static final String P_VALUES = "values";
    public static final String P_KNAPSACK_SIZE = "knapsack-size";
    public static final String P_ALLOW_DUPLICATES = "allow-duplicates";
    private List<KnapsackComponent> components;
    private double knapsackSize;
    private boolean allowDuplicates;

    public List<Component> getAllComponents() {
        return new ArrayList<Component>(this.components);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        double[] values;
        assert (state != null);
        assert (base != null);
        this.knapsackSize = state.parameters.getDouble(base.push(P_KNAPSACK_SIZE), null);
        this.allowDuplicates = state.parameters.getBoolean(base.push(P_ALLOW_DUPLICATES), null, false);
        double[] sizes = state.parameters.getDoubles(base.push(P_SIZES), null, 0.0);
        if (sizes.length != (values = state.parameters.getDoubles(base.push(P_VALUES), null, 0.0)).length) {
            state.output.fatal(String.format("%s: '%s' has %d elements, but '%s' has %d elements.  Must be the same length.", this.getClass().getSimpleName(), base.push(P_SIZES), sizes.length, base.push(P_VALUES), values.length));
        }
        assert (sizes.length == values.length);
        this.components = new ArrayList<KnapsackComponent>(sizes.length);
        for (int i = 0; i < sizes.length; ++i) {
            this.components.add(new KnapsackComponent(sizes[i], values[i]));
        }
        assert (this.repOK());
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        assert (state != null);
        if (!(ind instanceof ConstructiveIndividual)) {
            state.output.fatal(String.format("%s requires a %s, but was given a %s.", this.getClass().getSimpleName(), ConstructiveIndividual.class.getSimpleName(), ind.getClass().getSimpleName()));
        }
        ((SimpleFitness)ind.fitness).setFitness(state, this.totalValue((ConstructiveIndividual)ind), false);
        ind.evaluated = true;
        assert (this.repOK());
    }

    private double totalValue(ConstructiveIndividual solution) {
        assert (solution != null);
        double value = 0.0;
        for (Object c : solution) {
            if (!(c instanceof KnapsackComponent)) {
                throw new IllegalArgumentException(String.format("%s: found a %s containing a %s, but must contain only %ss.", this.getClass().getSimpleName(), solution.getClass().getSimpleName(), c.getClass().getSimpleName(), KnapsackComponent.class.getSimpleName()));
            }
            value += ((KnapsackComponent)c).value();
        }
        assert (this.repOK());
        return value;
    }

    private double totalSize(ConstructiveIndividual solution) {
        assert (solution != null);
        double size = 0.0;
        for (Object c : solution) {
            if (!(c instanceof KnapsackComponent)) {
                throw new IllegalArgumentException(String.format("%s: found a %s containing a %s, but must contain only %ss.", this.getClass().getSimpleName(), solution.getClass().getSimpleName(), c.getClass().getSimpleName(), KnapsackComponent.class.getSimpleName()));
            }
            size += ((KnapsackComponent)c).size();
        }
        assert (this.repOK());
        return size;
    }

    public boolean isViolated(ConstructiveIndividual partialSolution, Component component) {
        assert (partialSolution != null);
        assert (component != null);
        if (!(component instanceof KnapsackComponent)) {
            throw new IllegalArgumentException(String.format("%s: tried to check constraints on a %s containing a %s, but must be a %s.", this.getClass().getSimpleName(), partialSolution.getClass().getSimpleName(), component.getClass().getSimpleName(), KnapsackComponent.class.getSimpleName()));
        }
        return this.totalSize(partialSolution) + ((KnapsackComponent)component).size() > this.knapsackSize;
    }

    @Override
    public int numComponents() {
        assert (this.repOK());
        return this.components.size();
    }

    public final boolean repOK() {
        return P_VALUES != null && !P_VALUES.isEmpty() && P_SIZES != null && !P_SIZES.isEmpty() && P_KNAPSACK_SIZE != null && !P_KNAPSACK_SIZE.isEmpty() && this.components != null && !this.components.isEmpty() && this.knapsackSize > 0.0 && !Double.isNaN(this.knapsackSize);
    }

    public KnapsackComponent getArbitraryComponent(EvolutionState state, int thread) {
        assert (state != null);
        assert (thread >= 0);
        KnapsackComponent result = this.components.get(state.random[thread].nextInt(this.components.size()));
        assert (this.repOK());
        return result;
    }

    public List<Component> getAllowedComponents(ConstructiveIndividual partialSolution) {
        assert (partialSolution != null);
        double partialSolutionSize = this.totalSize(partialSolution);
        ArrayList<Component> allowedComponents = new ArrayList<Component>();
        for (KnapsackComponent c : this.components) {
            if (!this.allowDuplicates && partialSolution.contains(c) || !(partialSolutionSize + c.size() <= this.knapsackSize)) continue;
            allowedComponents.add(c);
        }
        return allowedComponents;
    }

    public boolean isCompleteSolution(ConstructiveIndividual solution) {
        assert (solution != null);
        double size = this.totalSize(solution);
        for (KnapsackComponent c : this.components) {
            if (!this.allowDuplicates && solution.contains(c) || !(size + c.size() <= this.knapsackSize)) continue;
            return false;
        }
        return true;
    }

    public Component getComponentFromString(String s) {
        double value;
        double size;
        assert (s != null);
        assert (!s.isEmpty());
        String error = String.format("%s: failed to decode string representation of %s.  It must have the form '%s[size=M, value=N]' where M, N are floating point numbers, but was '%s'.", this.getClass().getSimpleName(), KnapsackComponent.class.getSimpleName(), KnapsackComponent.class.getSimpleName(), s);
        String[] splits = s.split("\\[");
        if (splits.length != 2) {
            throw new IllegalArgumentException(error);
        }
        String name = splits[0].trim();
        if (!name.equals(KnapsackComponent.class.getSimpleName())) {
            throw new IllegalArgumentException(error);
        }
        if ((splits = splits[1].split(",")).length != 2) {
            throw new IllegalArgumentException(error);
        }
        String sizeStr = splits[0];
        String valueStr = splits[1].substring(0, splits[1].length() - 1);
        splits = sizeStr.split("=");
        if (!splits[0].trim().equals("size")) {
            throw new IllegalArgumentException(error);
        }
        try {
            size = Double.parseDouble(splits[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(error);
        }
        splits = valueStr.split("=");
        if (!splits[0].trim().equals("value")) {
            throw new IllegalArgumentException(error);
        }
        try {
            value = Double.parseDouble(splits[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(error);
        }
        assert (this.repOK());
        return new KnapsackComponent(size, value);
    }
}

