/*
 * Decompiled with CFR 0.152.
 */
package ec.app.lawnmower.func;

import ec.EvolutionState;
import ec.Problem;
import ec.app.lawnmower.Lawnmower;
import ec.app.lawnmower.LawnmowerData;
import ec.gp.ADFStack;
import ec.gp.GPData;
import ec.gp.GPIndividual;
import ec.gp.GPNode;

public class Frog
extends GPNode {
    @Override
    public String toString() {
        return "frog";
    }

    @Override
    public int expectedChildren() {
        return 1;
    }

    @Override
    public void eval(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem) {
        Lawnmower p = (Lawnmower)problem;
        LawnmowerData d = (LawnmowerData)input;
        this.children[0].eval(state, thread, input, stack, individual, problem);
        switch (p.orientation) {
            case 0: {
                p.posx -= d.y;
                p.posy += d.x;
                break;
            }
            case 1: {
                p.posx -= d.x;
                p.posy -= d.y;
                break;
            }
            case 2: {
                p.posx += d.y;
                p.posy -= d.x;
                break;
            }
            case 3: {
                p.posx += d.x;
                p.posy += d.y;
                break;
            }
            default: {
                state.output.fatal("Whoa, somehow I got a bad orientation! (" + p.orientation + ")");
            }
        }
        p.posx = (p.posx % p.maxx + p.maxx) % p.maxx;
        p.posy = (p.posy % p.maxy + p.maxy) % p.maxy;
        ++p.moves;
        if (p.map[p.posx][p.posy] == 0) {
            ++p.sum;
            p.map[p.posx][p.posy] = p.moves;
        }
    }
}

