/*
 * Decompiled with CFR 0.152.
 */
package ec.app.lid;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class Lid
extends GPProblem
implements SimpleProblemForm {
    static final String P_TARGET_DEPTH = "targetDepth";
    static final String P_TARGET_TERMINALS = "targetTerminals";
    static final String P_WEIGHT_DEPTH = "weightDepth";
    int maxWeight = 100;
    int targetDepth;
    int targetTerminals;
    int actualDepth;
    int actualTerminals;
    int weightDepth;
    int weightTerminals;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.targetDepth = state.parameters.getInt(base.push(P_TARGET_DEPTH), null, 1);
        if (this.targetDepth == 0) {
            state.output.error("The target depth must be > 0", base.push(P_TARGET_DEPTH));
        }
        this.targetTerminals = state.parameters.getInt(base.push(P_TARGET_TERMINALS), null, 1);
        if (this.targetTerminals == 0) {
            state.output.error("The target terminals must be > 0", base.push(P_TARGET_TERMINALS));
        }
        this.weightDepth = state.parameters.getInt(base.push(P_WEIGHT_DEPTH), null, 0);
        if (this.weightDepth < 0 || this.weightDepth > this.maxWeight) {
            state.output.error("The depth-weighting must be in [0, maxWeight]", base.push(P_WEIGHT_DEPTH));
        }
        this.weightTerminals = this.maxWeight - this.weightDepth;
        state.output.exitIfErrors();
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            this.actualDepth = ((GPIndividual)ind).trees[0].child.depth() - 1;
            this.actualTerminals = ((GPIndividual)ind).trees[0].child.numNodes(1);
            double scoreDepth = (double)this.weightDepth * (1.0 - (double)Math.abs(this.targetDepth - this.actualDepth) / (double)this.targetDepth);
            double scoreTerminals = 0.0;
            if (this.targetDepth == this.actualDepth) {
                scoreTerminals = (double)this.weightTerminals * (1.0 - (double)Math.abs(this.targetTerminals - this.actualTerminals) / (double)this.targetTerminals);
            }
            double score = scoreTerminals + scoreDepth;
            SimpleFitness f = (SimpleFitness)ind.fitness;
            f.setFitness(state, score, false);
            ind.evaluated = true;
        }
    }

    @Override
    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        this.actualDepth = ((GPIndividual)ind).trees[0].child.depth() - 1;
        this.actualTerminals = ((GPIndividual)ind).trees[0].child.numNodes(1);
        state.output.println("\n\nBest Individual: in ECJ terms depth = " + (this.actualDepth + 1) + "; in Lid terms depth = " + this.actualDepth + "; number of terminals = " + this.actualTerminals, log);
    }
}

