/*
 * Decompiled with CFR 0.152.
 */
package ec.app.majority;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.app.majority.CA;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.BitVectorIndividual;

public class MajorityGA
extends Problem
implements SimpleProblemForm {
    CA ca = null;
    public static final int NUM_TRIALS = 128;
    public static final int CA_WIDTH = 149;
    public static final int NEIGHBORHOOD = 7;
    public static final int STEPS = 200;
    int[][] trials = new int[128][149];
    int[] majorities = new int[128];
    static final int MAJORITY_ZERO = 0;
    static final int MAJORITY_ONE = 1;
    static final int RANDOM = -1;
    int lockCount = 0;
    private Object[] lock = new Object[0];
    public static final int NUM_TESTS = 10000;
    double density = 0.0;

    boolean makeTrial(EvolutionState state, int thread, int[] trial, int trialType) {
        if (trialType == -1) {
            int count = 0;
            for (int i = 0; i < 149; ++i) {
                trial[i] = state.random[thread].nextInt(2);
                count += trial[i];
            }
            return (double)count > 74.5;
        }
        if (trialType == 1) {
            while (!this.makeTrial(state, thread, trial, -1)) {
            }
            return true;
        }
        if (trialType == 0) {
            while (this.makeTrial(state, thread, trial, -1)) {
            }
            return false;
        }
        state.output.fatal("This should never happen");
        return false;
    }

    public void generateTrials(EvolutionState state, int thread) {
        int i;
        for (i = 0; i < 32; ++i) {
            this.majorities[i] = this.makeTrial(state, thread, this.trials[i], 0) ? 1 : 0;
        }
        for (i = 32; i < 64; ++i) {
            this.majorities[i] = this.makeTrial(state, thread, this.trials[i], 1) ? 1 : 0;
        }
        for (i = 64; i < 128; ++i) {
            this.majorities[i] = this.makeTrial(state, thread, this.trials[i], -1) ? 1 : 0;
        }
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.generateTrials(state, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepareToEvaluate(EvolutionState state, int threadnum) {
        if (threadnum == 0) return;
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            ++this.lockCount;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishEvaluating(EvolutionState state, int threadnum) {
        if (threadnum != 0) {
            Object[] objectArray = this.lock;
            synchronized (this.lock) {
                --this.lockCount;
                this.lock.notifyAll();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            while (this.lockCount > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            this.generateTrials(state, threadnum);
            return;
        }
    }

    public static boolean all(int[] vals, int val) {
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == val) continue;
            return false;
        }
        return true;
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        int i;
        if (this.ca == null) {
            this.ca = new CA(149, 7);
        }
        int sum = 0;
        boolean[] genome = ((BitVectorIndividual)ind).genome;
        int[] rule = this.ca.getRule();
        for (i = 0; i < 128; ++i) {
            rule[i] = genome[i] ? 1 : 0;
        }
        this.ca.setRule(rule);
        for (i = 0; i < 128; ++i) {
            this.ca.setVals(this.trials[i]);
            this.ca.step(200, true);
            if (!MajorityGA.all(this.ca.getVals(), this.majorities[i])) continue;
            ++sum;
        }
        SimpleFitness f = (SimpleFitness)ind.fitness;
        f.setFitness(state, (double)sum / 128.0, false);
        ind.evaluated = true;
    }

    @Override
    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        if (this.ca == null) {
            this.ca = new CA(149, 7);
        }
        int[] trial = new int[149];
        boolean[] genome = ((BitVectorIndividual)ind).genome;
        int[] rule = this.ca.getRule();
        for (int i = 0; i < 128; ++i) {
            rule[i] = genome[i] ? 1 : 0;
        }
        this.ca.setRule(rule);
        double sum = 0.0;
        for (int i = 0; i < 10000; ++i) {
            int result = this.makeTrial(state, threadnum, trial, -1) ? 1 : 0;
            this.ca.setVals(trial);
            this.ca.step(200, true);
            if (!MajorityGA.all(this.ca.getVals(), result)) continue;
            sum += 1.0;
        }
        this.density = sum / 10000.0;
        if (state.output == null) {
            System.err.println("Generalization Accuracy: " + this.density);
        } else {
            state.output.println("Generalization Accuracy: " + this.density, 1);
            state.output.println("Generalization Accuracy: " + this.density, log);
        }
    }

    public static void main(String[] args) {
        int[] ABK = new int[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        EvolutionState state = new EvolutionState();
        state.random = new MersenneTwisterFast[]{new MersenneTwisterFast(500L)};
        MajorityGA ga = new MajorityGA();
        ga.setup(state, new Parameter(""));
        BitVectorIndividual bvi = new BitVectorIndividual();
        bvi.fitness = new SimpleFitness();
        bvi.genome = new boolean[128];
        for (int i = 0; i < 128; ++i) {
            bvi.genome[i] = ABK[i] != 0;
        }
        ga.evaluate(state, bvi, 0, 0);
        System.err.println("ABK Rule");
        ga.describe(state, bvi, 0, 0, 1);
    }
}

