/*
 * Decompiled with CFR 0.152.
 */
package ec.app.multiplexer;

import ec.EvolutionState;
import ec.Individual;
import ec.app.multiplexer.Fast;
import ec.app.multiplexer.MultiplexerData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class Multiplexer
extends GPProblem
implements SimpleProblemForm {
    private static final long serialVersionUID = 1L;
    public static final int NUMINPUTS = 20;
    public static final String P_NUMBITS = "bits";
    public int bits;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.input instanceof MultiplexerData)) {
            state.output.fatal("GPData class must subclass from " + String.valueOf(MultiplexerData.class), base.push("data"), null);
        }
        this.bits = state.parameters.getIntWithMax(base.push(P_NUMBITS), null, 1, 3);
        if (this.bits < 1) {
            state.output.fatal("The number of bits for Multiplexer must be between 1 and 3 inclusive");
        }
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            MultiplexerData input = (MultiplexerData)this.input;
            input.status = (byte)this.bits;
            int sum = 0;
            ((GPIndividual)ind).trees[0].child.eval(state, threadnum, input, this.stack, (GPIndividual)ind, this);
            if (this.bits == 1) {
                byte item1 = input.dat_3;
                byte item2 = Fast.M_3[3];
                for (int y = 0; y < 8; ++y) {
                    sum += 1 & ~(item1 ^ item2);
                    item1 = (byte)(item1 >>> 1);
                    item2 = (byte)(item2 >>> 1);
                }
            } else if (this.bits == 2) {
                long item1 = input.dat_6;
                long item2 = Fast.M_6[6];
                for (int y = 0; y < 64; ++y) {
                    sum = (int)((long)sum + (1L & (item1 ^ item2 ^ 0xFFFFFFFFFFFFFFFFL)));
                    item1 >>>= 1;
                    item2 >>>= 1;
                }
            } else {
                for (int y = 0; y < 32; ++y) {
                    long item1 = input.dat_11[y];
                    long item2 = Fast.M_11[11][y];
                    for (int z = 0; z < 64; ++z) {
                        sum = (int)((long)sum + (1L & (item1 ^ item2 ^ 0xFFFFFFFFFFFFFFFFL)));
                        item1 >>>= 1;
                        item2 >>>= 1;
                    }
                }
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            if (this.bits == 1) {
                f.setStandardizedFitness(state, 8 - sum);
            } else if (this.bits == 2) {
                f.setStandardizedFitness(state, 64 - sum);
            } else {
                f.setStandardizedFitness(state, 2048 - sum);
            }
            f.hits = sum;
            ind.evaluated = true;
        }
    }
}

