/*
 * Decompiled with CFR 0.152.
 */
package ec.app.multiplexerslow;

import ec.EvolutionState;
import ec.Individual;
import ec.app.multiplexerslow.MultiplexerData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.util.ArrayList;

public class Multiplexer
extends GPProblem
implements SimpleProblemForm {
    private static final long serialVersionUID = 1L;
    public static final int NUMINPUTS = 20;
    public static final String P_NUMBITS = "bits";
    public int bits;
    public int amax;
    public int dmax;
    public int addressPart;
    public int dataPart;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int x;
        super.setup(state, base);
        if (!(this.input instanceof MultiplexerData)) {
            state.output.fatal("GPData class must subclass from " + String.valueOf(MultiplexerData.class), base.push("data"), null);
        }
        this.bits = state.parameters.getIntWithMax(base.push(P_NUMBITS), null, 1, 3);
        if (this.bits < 1) {
            state.output.fatal("The number of bits for Multiplexer must be between 1 and 3 inclusive");
        }
        this.amax = 1;
        for (x = 0; x < this.bits; ++x) {
            this.amax *= 2;
        }
        this.dmax = 1;
        for (x = 0; x < this.amax; ++x) {
            this.dmax *= 2;
        }
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            MultiplexerData input = (MultiplexerData)this.input;
            int sum = 0;
            ArrayList<SimpleFitness> trials = new ArrayList<SimpleFitness>();
            this.addressPart = 0;
            while (this.addressPart < this.amax) {
                this.dataPart = 0;
                while (this.dataPart < this.dmax) {
                    ((GPIndividual)ind).trees[0].child.eval(state, threadnum, input, this.stack, (GPIndividual)ind, this);
                    double trial = 1 - (this.dataPart >>> this.addressPart & 1 ^ input.x & 1);
                    SimpleFitness trialFitness = new SimpleFitness();
                    trialFitness.setFitness(state, trial, false);
                    trials.add(trialFitness);
                    sum = (int)((double)sum + trial);
                    ++this.dataPart;
                }
                ++this.addressPart;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            assert (trials.size() == this.amax * this.dmax);
            f.trials = trials;
            f.setStandardizedFitness(state, this.amax * this.dmax - sum);
            f.hits = sum;
            ind.evaluated = true;
        }
    }
}

