/*
 * Decompiled with CFR 0.152.
 */
package ec.app.regression;

import ec.EvolutionState;
import ec.Individual;
import ec.app.regression.RegressionData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;

public class Benchmarks
extends GPProblem
implements SimpleProblemForm {
    private static final long serialVersionUID = 1L;
    public static final int KOZA1 = 0;
    public static final int KOZA2 = 1;
    public static final int KOZA3 = 2;
    public static final int NGUYEN1 = 3;
    public static final int NGUYEN2 = 4;
    public static final int NGUYEN3 = 5;
    public static final int NGUYEN4 = 6;
    public static final int NGUYEN5 = 7;
    public static final int NGUYEN6 = 8;
    public static final int NGUYEN7 = 9;
    public static final int NGUYEN8 = 10;
    public static final int NGUYEN9 = 11;
    public static final int NGUYEN10 = 12;
    public static final int PAGIE1 = 13;
    public static final int PAGIE2 = 14;
    public static final int KORNS1 = 15;
    public static final int KORNS2 = 16;
    public static final int KORNS3 = 17;
    public static final int KORNS4 = 18;
    public static final int KORNS5 = 19;
    public static final int KORNS6 = 20;
    public static final int KORNS7 = 21;
    public static final int KORNS8 = 22;
    public static final int KORNS9 = 23;
    public static final int KORNS10 = 24;
    public static final int KORNS11 = 25;
    public static final int KORNS12 = 26;
    public static final int KORNS13 = 27;
    public static final int KORNS14 = 28;
    public static final int KORNS15 = 29;
    public static final int KEIJZER1 = 30;
    public static final int KEIJZER2 = 31;
    public static final int KEIJZER3 = 32;
    public static final int KEIJZER4 = 33;
    public static final int KEIJZER5 = 34;
    public static final int KEIJZER6 = 35;
    public static final int KEIJZER7 = 36;
    public static final int KEIJZER8 = 37;
    public static final int KEIJZER9 = 38;
    public static final int KEIJZER10 = 39;
    public static final int KEIJZER11 = 40;
    public static final int KEIJZER12 = 41;
    public static final int KEIJZER13 = 42;
    public static final int KEIJZER14 = 43;
    public static final int KEIJZER15 = 44;
    public static final int VLADISLAVLEVA1 = 45;
    public static final int VLADISLAVLEVA2 = 46;
    public static final int VLADISLAVLEVA3 = 47;
    public static final int VLADISLAVLEVA4 = 48;
    public static final int VLADISLAVLEVA5 = 49;
    public static final int VLADISLAVLEVA6 = 50;
    public static final int VLADISLAVLEVA7 = 51;
    public static final int VLADISLAVLEVA8 = 52;
    public static final String[] names = new String[]{"koza-1", "koza-2", "koza-3", "nguyen-1", "nguyen-2", "nguyen-3", "nguyen-4", "nguyen-5", "nguyen-6", "nguyen-7", "nguyen-8", "nguyen-9", "nguyen-10", "pagie-1", "pagie-2", "korns-1", "korns-2", "korns-3", "korns-4", "korns-5", "korns-6", "korns-7", "korns-8", "korns-9", "korns-10", "korns-11", "korns-12", "korns-13", "korns-14", "korns-15", "keijzer-1", "keijzer-2", "keijzer-3", "keijzer-4", "keijzer-5", "keijzer-6", "keijzer-7", "keijzer-8", "keijzer-9", "keijzer-10", "keijzer-11", "keijzer-12", "keijzer-13", "keijzer-14", "keijzer-15", "vladislavleva-1", "vladislavleva-2", "vladislavleva-3", "vladislavleva-4", "vladislavleva-5", "vladislavleva-6", "vladislavleva-7", "vladislavleva-8"};
    public static final String[] fs = new String[]{"koza1", "koza1", "koza1", "koza1", "koza1", "koza1", "koza1", "koza1", "koza1", "koza1", "koza1", "koza2", "koza2", "koza2", "koza3", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "korns5", "keijzer1", "keijzer1", "keijzer1", "keijzer1", "keijzer3", "keijzer1", "keijzer1", "keijzer1", "keijzer1", "keijzer2", "keijzer2", "keijzer2", "keijzer2", "keijzer2", "keijzer2", "vladislavleva-b2", "vladislavleva-c1", "vladislavleva-c2", "vladislavleva-a5", "vladislavleva-a3", "vladislavleva-b2", "vladislavleva-c2", "vladislavleva-a2"};
    public static final String[][] fs_vars = new String[][]{new String[0], {"koza1", "keijzer1", "vladislavleva-c1"}, {"koza2", "keijzer2", "vladislavleva-a2", "vladislavleva-b2", "vladislavleva-c2"}, {"koza3", "keijzer3", "vladislavleva-a3"}, new String[0], {"korns5", "vladislavleva-a5"}};
    static final double PROBABLY_ZERO = 1.11E-15;
    static final double BIG_NUMBER = 1.0E15;
    public static final String P_TESTING_FILE = "testing-file";
    public static final String P_TRAINING_FILE = "training-file";
    public static final String P_PROBLEM_TYPE = "type";
    public double[] currentValue;
    public double[][] trainingInputs;
    public double[] trainingOutputs;
    public double[][] testingInputs;
    public double[] testingOutputs;

    static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public double[][] generateRandomSamples(EvolutionState state, double[] min, double[] max, int numPoints, int threadnum) {
        int vars = max.length;
        double[][] d = new double[numPoints][vars];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < vars; ++j) {
                d[i][j] = state.random[threadnum].nextDouble(true, true) * (max[j] - min[j]) + min[j];
            }
        }
        return d;
    }

    public double[][] generateRandomSamples(EvolutionState state, double min, double max, int numPoints, int threadnum) {
        return this.generateRandomSamples(state, new double[]{min}, new double[]{max}, numPoints, threadnum);
    }

    void buildIntervalPoints(EvolutionState state, ArrayList list, double[] min, double[] max, double[] interval, double[] current, int variable, int threadnum) {
        if (variable == min.length) {
            double[] d = new double[min.length];
            for (int i = 0; i < d.length; ++i) {
                d[i] = current[i];
            }
            list.add(d);
        } else {
            int jumps = (int)((max[variable] - min[variable]) / interval[variable]) + 1;
            for (int j = 0; j < jumps; ++j) {
                current[variable] = min[variable] + interval[variable] * (double)j;
                this.buildIntervalPoints(state, list, min, max, interval, current, variable + 1, threadnum);
            }
        }
    }

    public double[][] generateIntervalSpacedSamples(EvolutionState state, double[] min, double[] max, double[] interval, int threadnum) {
        ArrayList list = new ArrayList();
        double[] current = new double[min.length];
        this.buildIntervalPoints(state, list, min, max, interval, current, 0, threadnum);
        return (double[][])list.toArray((T[])new double[0][]);
    }

    public double[][] generateIntervalSpacedSamples(EvolutionState state, double min, double max, double interval, int threadnum) {
        return this.generateIntervalSpacedSamples(state, new double[]{min}, new double[]{max}, new double[]{interval}, threadnum);
    }

    public double[][] trainPoints(EvolutionState state, int benchmark, int threadnum) {
        switch (benchmark) {
            case 0: 
            case 1: 
            case 2: {
                return this.generateRandomSamples(state, -1.0, 1.0, 20, threadnum);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.generateRandomSamples(state, -1.0, 1.0, 20, threadnum);
            }
            case 9: {
                return this.generateRandomSamples(state, 0.0, 2.0, 20, threadnum);
            }
            case 10: {
                return this.generateRandomSamples(state, 0.0, 4.0, 20, threadnum);
            }
            case 11: 
            case 12: {
                return this.generateRandomSamples(state, new double[]{0.0, 0.0}, new double[]{1.0, 1.0}, 100, threadnum);
            }
            case 13: {
                return this.generateIntervalSpacedSamples(state, new double[]{-5.0, -5.0}, new double[]{5.0, 5.0}, new double[]{0.4, 0.4}, threadnum);
            }
            case 14: {
                return this.generateIntervalSpacedSamples(state, new double[]{-5.0, -5.0, -5.0}, new double[]{5.0, 5.0, 5.0}, new double[]{0.4, 0.4, 0.4}, threadnum);
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return this.generateRandomSamples(state, new double[]{-50.0, -50.0, -50.0, -50.0, -50.0}, new double[]{50.0, 50.0, 50.0, 50.0, 50.0}, 10000, threadnum);
            }
            case 30: {
                return this.generateIntervalSpacedSamples(state, -1.0, 1.0, 0.1, threadnum);
            }
            case 31: {
                return this.generateIntervalSpacedSamples(state, -2.0, 2.0, 0.1, threadnum);
            }
            case 32: {
                return this.generateIntervalSpacedSamples(state, -3.0, 3.0, 0.1, threadnum);
            }
            case 33: {
                return this.generateIntervalSpacedSamples(state, 0.0, 10.0, 0.05, threadnum);
            }
            case 34: {
                return this.generateRandomSamples(state, new double[]{-1.0, 1.0, -1.0}, new double[]{1.0, 2.0, 1.0}, 1000, threadnum);
            }
            case 35: {
                return this.generateIntervalSpacedSamples(state, 1.0, 50.0, 1.0, threadnum);
            }
            case 36: {
                return this.generateIntervalSpacedSamples(state, 1.0, 100.0, 1.0, threadnum);
            }
            case 37: 
            case 38: {
                return this.generateIntervalSpacedSamples(state, 0.0, 100.0, 1.0, threadnum);
            }
            case 39: {
                return this.generateRandomSamples(state, new double[]{0.0, 0.0}, new double[]{1.0, 1.0}, 100, threadnum);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return this.generateRandomSamples(state, new double[]{-3.0, -3.0}, new double[]{3.0, 3.0}, 20, threadnum);
            }
            case 45: {
                return this.generateRandomSamples(state, new double[]{0.3, 0.3}, new double[]{4.0, 4.0}, 100, threadnum);
            }
            case 46: {
                return this.generateIntervalSpacedSamples(state, 0.05, 10.0, 0.1, threadnum);
            }
            case 47: {
                return this.generateIntervalSpacedSamples(state, new double[]{0.05, 0.05}, new double[]{10.0, 10.05}, new double[]{0.1, 2.0}, threadnum);
            }
            case 48: {
                return this.generateRandomSamples(state, new double[]{0.05, 0.05, 0.05, 0.05, 0.05}, new double[]{6.05, 6.05, 6.05, 6.05, 6.05}, 1024, threadnum);
            }
            case 49: {
                return this.generateRandomSamples(state, new double[]{0.05, 1.0, 0.05}, new double[]{2.0, 2.0, 2.0}, 300, threadnum);
            }
            case 50: {
                return this.generateRandomSamples(state, new double[]{0.1, 0.1}, new double[]{5.9, 5.9}, 30, threadnum);
            }
            case 51: {
                return this.generateRandomSamples(state, new double[]{0.05, 0.05}, new double[]{6.05, 6.05}, 300, threadnum);
            }
            case 52: {
                return this.generateRandomSamples(state, new double[]{0.05, 0.05}, new double[]{6.05, 6.05}, 50, threadnum);
            }
        }
        return null;
    }

    public double[][] testPoints(EvolutionState state, int benchmark, int threadnum, double[][] trainpoints) {
        switch (benchmark) {
            case 0: 
            case 1: 
            case 2: {
                return trainpoints;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return trainpoints;
            }
            case 13: 
            case 14: {
                return trainpoints;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return this.generateRandomSamples(state, new double[]{-50.0, -50.0, -50.0, -50.0, -50.0}, new double[]{50.0, 50.0, 50.0, 50.0, 50.0}, 10000, threadnum);
            }
            case 30: {
                return this.generateIntervalSpacedSamples(state, -1.0, 1.0, 0.001, threadnum);
            }
            case 31: {
                return this.generateIntervalSpacedSamples(state, -2.0, 2.0, 0.001, threadnum);
            }
            case 32: {
                return this.generateIntervalSpacedSamples(state, -3.0, 3.0, 0.001, threadnum);
            }
            case 33: {
                return this.generateIntervalSpacedSamples(state, 0.05, 10.05, 0.05, threadnum);
            }
            case 34: {
                return this.generateRandomSamples(state, new double[]{-1.0, 1.0, -1.0}, new double[]{1.0, 2.0, 1.0}, 10000, threadnum);
            }
            case 35: {
                return this.generateIntervalSpacedSamples(state, 1.0, 120.0, 1.0, threadnum);
            }
            case 36: {
                return this.generateIntervalSpacedSamples(state, 1.0, 100.0, 0.1, threadnum);
            }
            case 37: 
            case 38: {
                return this.generateIntervalSpacedSamples(state, 0.0, 100.0, 0.1, threadnum);
            }
            case 39: {
                return this.generateIntervalSpacedSamples(state, new double[]{0.0, 0.0}, new double[]{1.0, 1.0}, new double[]{0.01, 0.01}, threadnum);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return this.generateIntervalSpacedSamples(state, new double[]{-3.0, -3.0}, new double[]{3.0, 3.0}, new double[]{0.01, 0.01}, threadnum);
            }
            case 45: {
                return this.generateIntervalSpacedSamples(state, new double[]{-0.2, -0.2}, new double[]{4.2, 4.2}, new double[]{0.1, 0.1}, threadnum);
            }
            case 46: {
                return this.generateIntervalSpacedSamples(state, -0.5, 10.5, 0.05, threadnum);
            }
            case 47: {
                return this.generateIntervalSpacedSamples(state, new double[]{-0.5, -0.5}, new double[]{10.5, 10.5}, new double[]{0.05, 0.5}, threadnum);
            }
            case 48: {
                return this.generateRandomSamples(state, new double[]{-0.25, -0.25, -0.25, -0.25, -0.25}, new double[]{6.35, 6.35, 6.35, 6.35, 6.35}, 5000, threadnum);
            }
            case 49: {
                return this.generateIntervalSpacedSamples(state, new double[]{-0.05, 0.95, -0.05}, new double[]{2.1, 2.05, 2.1}, new double[]{0.15, 0.15, 0.1}, threadnum);
            }
            case 50: {
                return this.generateIntervalSpacedSamples(state, new double[]{-0.05, -0.05}, new double[]{6.05, 6.05}, new double[]{0.02, 0.02}, threadnum);
            }
            case 51: {
                return this.generateRandomSamples(state, new double[]{-0.25, -0.25}, new double[]{6.35, 6.35}, 1000, threadnum);
            }
            case 52: {
                return this.generateIntervalSpacedSamples(state, new double[]{-0.25, -0.25}, new double[]{6.35, 6.35}, new double[]{0.2, 0.2}, threadnum);
            }
        }
        return null;
    }

    public double func(EvolutionState state, double[] xs, int benchmark) throws IllegalArgumentException {
        double x = xs[0];
        double y = xs.length > 1 ? xs[1] : 0.0;
        double z = xs.length > 2 ? xs[2] : 0.0;
        switch (benchmark) {
            case 0: {
                return x * x * x * x + x * x * x + x * x + x;
            }
            case 1: {
                return x * x * x * x * x - 2.0 * x * x * x + x;
            }
            case 2: {
                return x * x * x * x * x * x - 2.0 * x * x * x * x + x * x;
            }
            case 3: {
                return x * x * x + x * x + x;
            }
            case 4: {
                return x * x * x * x + x * x * x + x * x + x;
            }
            case 5: {
                return x * x * x * x * x + x * x * x * x + x * x * x + x * x + x;
            }
            case 6: {
                return x * x * x * x * x * x + x * x * x * x * x + x * x * x * x + x * x * x + x * x + x;
            }
            case 7: {
                return Math.sin(x * x) * Math.cos(x) - 1.0;
            }
            case 8: {
                return Math.sin(x) + Math.sin(x * x + x);
            }
            case 9: {
                return Math.log(x + 1.0) + Math.log(x * x + 1.0);
            }
            case 10: {
                return Math.sqrt(x);
            }
            case 11: {
                return Math.sin(x) + Math.sin(y * y);
            }
            case 12: {
                return 2.0 * Math.sin(x) * Math.cos(y);
            }
            case 13: {
                return 1.0 / (1.0 + 1.0 / (x * x * x * x)) + 1.0 / (1.0 + 1.0 / (y * y * y * y));
            }
            case 14: {
                return 1.0 / (1.0 + 1.0 / (x * x * x * x)) + 1.0 / (1.0 + 1.0 / (y * y * y * y)) + 1.0 / (1.0 + 1.0 / (z * z * z * z));
            }
            case 15: {
                return 1.57 + 24.3 * xs[3];
            }
            case 16: {
                return 0.23 + 14.2 * ((xs[3] + xs[1]) / (3.0 * xs[4]));
            }
            case 17: {
                return -5.41 + 4.9 * ((xs[3] - xs[0] + xs[1] / xs[4]) / (3.0 * xs[4]));
            }
            case 18: {
                return -2.3 + 0.13 * Math.sin(xs[2]);
            }
            case 19: {
                return 3.0 + 2.13 * Math.log(xs[4]);
            }
            case 20: {
                return 1.3 + 0.13 * Math.sqrt(xs[0]);
            }
            case 21: {
                return 213.80940889 - 213.80940889 * Math.exp(-0.54723748542 * xs[0]);
            }
            case 22: {
                return 6.87 + 11.0 * Math.sqrt(7.23 * xs[0] * xs[3] * xs[4]);
            }
            case 23: {
                return Math.sqrt(xs[0]) / Math.log(xs[1]) * Math.exp(xs[2]) / (xs[3] * xs[3]);
            }
            case 24: {
                return 0.81 + 24.3 * ((2.0 * xs[1] + 3.0 * (xs[2] * xs[2])) / (4.0 * (xs[3] * xs[3] * xs[3]) + 5.0 * (xs[4] * xs[4] * xs[4] * xs[4])));
            }
            case 25: {
                return 6.87 + 11.0 * Math.cos(7.23 * xs[0] * xs[0] * xs[0]);
            }
            case 26: {
                return 2.0 - 2.1 * (Math.cos(9.8 * xs[0]) * Math.sin(1.3 * xs[4]));
            }
            case 27: {
                return 32.0 - 3.0 * (Math.tan(xs[0]) / Math.tan(xs[1]) * (Math.tan(xs[2]) / Math.tan(xs[3])));
            }
            case 28: {
                return 22.0 - 4.2 * ((Math.cos(xs[0]) - Math.tan(xs[1])) * (Math.tanh(xs[2]) / Math.sin(xs[3])));
            }
            case 29: {
                return 12.0 - 6.0 * (Math.tan(xs[0]) / Math.exp(xs[1]) * (Math.log(xs[2]) - Math.tan(xs[3])));
            }
            case 30: 
            case 31: 
            case 32: {
                return 0.3 * x * Math.sin(Math.PI * 2 * x);
            }
            case 33: {
                return x * x * x * Math.exp(-x) * Math.cos(x) * Math.sin(x) * (Math.sin(x) * Math.sin(x) * Math.cos(x) - 1.0);
            }
            case 34: {
                return 30.0 * x * z / ((x - 10.0) * y * y);
            }
            case 35: {
                double sum = 0.0;
                double fx = Math.floor(x);
                int i = 1;
                while ((double)i < fx + 1.0) {
                    sum += 1.0 / (double)i;
                    ++i;
                }
                return sum;
            }
            case 36: {
                return Math.log(x);
            }
            case 37: {
                return Math.sqrt(x);
            }
            case 38: {
                return Benchmarks.asinh(x);
            }
            case 39: {
                return Math.pow(x, y);
            }
            case 40: {
                return x * y + Math.sin((x - 1.0) * (y - 1.0));
            }
            case 41: {
                return x * x * x * x - x * x * x + y * y / 2.0 - y;
            }
            case 42: {
                return 6.0 * Math.sin(x) * Math.cos(y);
            }
            case 43: {
                return 8.0 / (2.0 + x * x + y * y);
            }
            case 44: {
                return x * x * x / 5.0 + y * y * y / 2.0 - y - x;
            }
            case 45: {
                return Math.exp(-(x - 1.0) * (x - 1.0)) / (1.2 + (y - 2.5) * (y - 2.5));
            }
            case 46: {
                return Math.exp(-x) * x * x * x * Math.cos(x) * Math.sin(x) * (Math.cos(x) * Math.sin(x) * Math.sin(x) - 1.0);
            }
            case 47: {
                return Math.exp(-x) * x * x * x * Math.cos(x) * Math.sin(x) * (Math.cos(x) * Math.sin(x) * Math.sin(x) - 1.0) * (y - 5.0);
            }
            case 48: {
                double sum = 0.0;
                for (int i = 0; i < 5; ++i) {
                    sum += (xs[i] - 3.0) * (xs[i] - 3.0);
                }
                return 10.0 / (5.0 + sum);
            }
            case 49: {
                return 30.0 * (x - 1.0) * (z - 1.0) / (y * y * (x - 10.0));
            }
            case 50: {
                return 6.0 * Math.sin(x) * Math.cos(y);
            }
            case 51: {
                return (x - 3.0) * (y - 3.0) + 2.0 * Math.sin((x - 4.0) * (y - 4.0));
            }
            case 52: {
                return ((x - 3.0) * (x - 3.0) * (x - 3.0) * (x - 3.0) + (y - 3.0) * (y - 3.0) * (y - 3.0) - (y - 3.0)) / ((y - 2.0) * (y - 2.0) * (y - 2.0) * (y - 2.0) + 10.0);
            }
        }
        throw new IllegalArgumentException("Invalid benchmark value " + benchmark);
    }

    public double error(double result, double expectedResult) {
        double delta = Math.abs(result - expectedResult);
        if (!(delta < 1.0E15)) {
            delta = 1.0E15;
        } else if (delta < 1.11E-15) {
            delta = 0.0;
        }
        return delta;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.input instanceof RegressionData)) {
            state.output.fatal("GPData class must subclass from " + String.valueOf(RegressionData.class), base.push("data"), null);
        }
        InputStream training_file = state.parameters.getResource(base.push(P_TRAINING_FILE), null);
        InputStream testing_file = state.parameters.getResource(base.push(P_TESTING_FILE), null);
        String problem = state.parameters.getString(base.push(P_PROBLEM_TYPE), null);
        int benchmark = -1;
        if (problem == null) {
            state.output.message("Loading benchmark data from files");
            if (testing_file == null || training_file == null) {
                state.output.fatal("If you don't specify a problem type, you must provide a training file and a testing file", training_file == null ? base.push(P_TRAINING_FILE) : base.push(P_TESTING_FILE));
            } else {
                try {
                    int numInputs = 0;
                    Scanner scan = new Scanner(training_file);
                    if (scan.hasNextInt()) {
                        numInputs = scan.nextInt();
                    } else {
                        state.output.fatal("Number of input variables not provided at beginning of training file ", base.push(P_TRAINING_FILE), null);
                    }
                    ArrayList<double[]> input = new ArrayList<double[]>();
                    ArrayList<Double> output = new ArrayList<Double>();
                    while (scan.hasNextDouble()) {
                        double[] in = new double[numInputs];
                        double out = 0.0;
                        for (int i = 0; i < numInputs; ++i) {
                            if (scan.hasNextDouble()) {
                                in[i] = scan.nextDouble();
                                continue;
                            }
                            state.output.fatal("Non-normal number of data points in training file ", base.push(P_TRAINING_FILE), null);
                        }
                        if (scan.hasNextDouble()) {
                            out = scan.nextDouble();
                        } else {
                            state.output.fatal("Non-normal number of data points in training file ", base.push(P_TRAINING_FILE), null);
                        }
                        input.add(in);
                        output.add(out);
                    }
                    int len = input.size();
                    this.trainingInputs = new double[len][numInputs];
                    this.trainingOutputs = new double[len];
                    for (int i = 0; i < len; ++i) {
                        this.trainingInputs[i] = (double[])input.get(i);
                        this.trainingOutputs[i] = (Double)output.get(i);
                    }
                    scan = new Scanner(testing_file);
                    if (scan.hasNextInt()) {
                        numInputs = scan.nextInt();
                    } else {
                        state.output.fatal("Number of input variables not provided at beginning of testing file ", base.push(P_TESTING_FILE), null);
                    }
                    input = new ArrayList();
                    output = new ArrayList();
                    while (scan.hasNextDouble()) {
                        double[] in = new double[numInputs];
                        double out = 0.0;
                        for (int i = 0; i < numInputs; ++i) {
                            if (scan.hasNextDouble()) {
                                in[i] = scan.nextDouble();
                                continue;
                            }
                            state.output.fatal("Non-normal number of data points in testing file ", base.push(P_TESTING_FILE), null);
                        }
                        if (scan.hasNextDouble()) {
                            out = scan.nextDouble();
                        } else {
                            state.output.fatal("Non-normal number of data points in testing file ", base.push(P_TESTING_FILE), null);
                        }
                        input.add(in);
                        output.add(out);
                    }
                    len = input.size();
                    this.testingInputs = new double[len][numInputs];
                    this.testingOutputs = new double[len];
                    for (int i = 0; i < len; ++i) {
                        this.testingInputs[i] = (double[])input.get(i);
                        this.testingOutputs[i] = (Double)output.get(i);
                    }
                }
                catch (NumberFormatException e) {
                    state.output.fatal("Some tokens in the file were not numbers.");
                }
            }
        } else {
            int i;
            for (i = 0; i < names.length; ++i) {
                if (!names[i].equals(problem)) continue;
                benchmark = i;
                break;
            }
            if (benchmark == -1) {
                state.output.fatal("Could not find benchmark " + problem, base.push(P_PROBLEM_TYPE), null);
            }
            state.output.message("Doing benchmark " + names[benchmark]);
            try {
                this.trainingInputs = this.trainPoints(state, benchmark, 0);
                this.trainingOutputs = new double[this.trainingInputs.length];
                for (i = 0; i < this.trainingOutputs.length; ++i) {
                    this.trainingOutputs[i] = this.func(state, this.trainingInputs[i], benchmark);
                }
            }
            catch (IllegalArgumentException e) {
                state.output.fatal("Error in generating training data: " + e.getMessage());
            }
            try {
                this.testingInputs = this.testPoints(state, benchmark, 0, this.trainingInputs);
                this.testingOutputs = new double[this.testingInputs.length];
                for (int i2 = 0; i2 < this.testingOutputs.length; ++i2) {
                    this.testingOutputs[i2] = this.func(state, this.testingInputs[i2], benchmark);
                }
            }
            catch (IllegalArgumentException e) {
                state.output.fatal("Error in generating testing data: " + e.getMessage());
            }
        }
        Parameter param = new Parameter("gp.tc.0.fset");
        String pval = state.parameters.getString(param, null);
        if (problem == null) {
            boolean found = false;
            String[] vars = fs_vars[this.trainingInputs[0].length];
            for (int i = 0; i < vars.length; ++i) {
                if (!pval.equals(vars[i])) continue;
                found = true;
                break;
            }
            if (!found) {
                state.output.warning("The number of variables in your problem data (" + this.trainingInputs[0].length + "does not match the variables found in the function set " + pval + ".  Hope you know what you're doing.", param);
            } else {
                state.output.message("Using function set " + pval);
            }
        } else if (!pval.equals(fs[benchmark])) {
            state.output.warning("The number of variables for the " + names[benchmark] + " problem (" + this.trainingInputs[0].length + ") is normally handled by the function set " + fs[benchmark] + " but you are using " + pval + ".  Hope you know what you're doing.  To correct this, try adding the parameter gp.tc.0.fset=" + fs[benchmark], param);
        } else {
            state.output.message("Using function set " + pval);
        }
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            RegressionData input = (RegressionData)this.input;
            int hits = 0;
            double sum = 0.0;
            for (int y = 0; y < this.trainingInputs.length; ++y) {
                this.currentValue = this.trainingInputs[y];
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, input, this.stack, (GPIndividual)ind, this);
                double error = this.error(input.x, this.trainingOutputs[y]);
                double HIT_LEVEL = 0.01;
                if (error <= 0.01) {
                    ++hits;
                }
                sum += error;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, sum);
            f.hits = hits;
            ind.evaluated = true;
        }
    }

    @Override
    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        RegressionData input = (RegressionData)this.input;
        state.output.println("\n\nPerformance of Best Individual on Testing Set:\n", log);
        int hits = 0;
        double sum = 0.0;
        for (int y = 0; y < this.testingInputs.length; ++y) {
            this.currentValue = this.testingInputs[y];
            ((GPIndividual)ind).trees[0].child.eval(state, threadnum, input, this.stack, (GPIndividual)ind, this);
            double error = this.error(input.x, this.testingOutputs[y]);
            double HIT_LEVEL = 0.01;
            if (error <= 0.01) {
                ++hits;
            }
            sum += error;
        }
        KozaFitness f = (KozaFitness)ind.fitness.clone();
        f.setStandardizedFitness(state, sum);
        f.hits = hits;
        f.printFitnessForHumans(state, log);
    }
}

