/*
 * Decompiled with CFR 0.152.
 */
package ec.app.regression;

import ec.EvolutionState;
import ec.Individual;
import ec.app.regression.RegressionData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.io.InputStream;
import java.util.Scanner;

public class Regression
extends GPProblem
implements SimpleProblemForm {
    private static final long serialVersionUID = 1L;
    public static final String P_SIZE = "size";
    public static final String P_FILE = "file";
    public static final String P_USE_FUNCTION = "use-function";
    public double currentValue;
    public int trainingSetSize;
    public boolean useFunction;
    public double[] inputs;
    public double[] outputs;

    public double func(double x) {
        return x * x * x * x + x * x * x + x * x + x;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.input instanceof RegressionData)) {
            state.output.fatal("GPData class must subclass from " + String.valueOf(RegressionData.class), base.push("data"), null);
        }
        this.trainingSetSize = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (this.trainingSetSize < 1) {
            state.output.fatal("Training Set Size must be an integer greater than 0", base.push(P_SIZE));
        }
        InputStream inputfile = state.parameters.getResource(base.push(P_FILE), null);
        this.useFunction = state.parameters.getBoolean(base.push(P_USE_FUNCTION), null, true);
        this.inputs = new double[this.trainingSetSize];
        this.outputs = new double[this.trainingSetSize];
        if (inputfile != null) {
            try {
                Scanner scan = new Scanner(inputfile);
                for (int x = 0; x < this.trainingSetSize; ++x) {
                    if (scan.hasNextDouble()) {
                        this.inputs[x] = scan.nextDouble();
                    } else {
                        state.output.fatal("Not enough data points in file: expected " + this.trainingSetSize * (this.useFunction ? 1 : 2));
                    }
                    if (this.useFunction) continue;
                    if (scan.hasNextDouble()) {
                        this.outputs[x] = scan.nextDouble();
                        continue;
                    }
                    state.output.fatal("Not enough data points in file: expected " + this.trainingSetSize * (this.useFunction ? 1 : 2));
                }
            }
            catch (NumberFormatException e) {
                state.output.fatal("Some tokens in the file were not numbers.");
            }
        } else {
            for (int x = 0; x < this.trainingSetSize; ++x) {
                this.inputs[x] = state.random[0].nextDouble(true, true) * 2.0 - 1.0;
            }
        }
        for (int x = 0; x < this.trainingSetSize; ++x) {
            if (this.useFunction) {
                this.outputs[x] = this.func(this.inputs[x]);
            }
            state.output.message("{" + this.inputs[x] + "," + this.outputs[x] + "},");
        }
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            RegressionData input = (RegressionData)this.input;
            int hits = 0;
            double sum = 0.0;
            for (int y = 0; y < this.trainingSetSize; ++y) {
                this.currentValue = this.inputs[y];
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, input, this.stack, (GPIndividual)ind, this);
                double HIT_LEVEL = 0.01;
                double PROBABLY_ZERO = 1.11E-15;
                double BIG_NUMBER = 1.0E15;
                double result = Math.abs(this.outputs[y] - input.x);
                if (!(result < 1.0E15)) {
                    result = 1.0E15;
                } else if (result < 1.11E-15) {
                    result = 0.0;
                }
                if (result <= 0.01) {
                    ++hits;
                }
                sum += result;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, sum);
            f.hits = hits;
            ind.evaluated = true;
        }
    }
}

