/*
 * Decompiled with CFR 0.152.
 */
package ec.app.royaltree;

import ec.EvolutionState;
import ec.Individual;
import ec.app.royaltree.func.RoyalTreeNode;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.gp.GPProblem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;

public class RoyalTree
extends GPProblem
implements SimpleProblemForm {
    char[] successors = new char[256];

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            double score = this.fitness(((GPIndividual)ind).trees[0].child, state);
            SimpleFitness f = (SimpleFitness)ind.fitness;
            f.setFitness(state, score, false);
            ind.evaluated = true;
        }
    }

    double fitness(GPNode node, EvolutionState state) {
        double completeBonus = 2.0;
        double partialBonus = 1.0;
        double fullBonus = 2.0;
        double penalty = 0.3333333333333333;
        char node_fn = ((RoyalTreeNode)node).value();
        if (node_fn == 'X') {
            return 1.0;
        }
        double retval = 0.0;
        boolean nodeIsPerfect = true;
        for (int i = 0; i < node.children.length; ++i) {
            GPNode child = node.children[i];
            char child_fn = ((RoyalTreeNode)child).value();
            if (this.isPerfect(node_fn, child, state)) {
                retval += fullBonus * this.fitness(child, state);
                continue;
            }
            if (this.isSuccessor(node_fn, child_fn, state)) {
                retval += partialBonus * this.fitness(child, state);
                nodeIsPerfect = false;
                continue;
            }
            retval += penalty * this.fitness(child, state);
            nodeIsPerfect = false;
        }
        if (nodeIsPerfect) {
            retval *= completeBonus;
        }
        return retval;
    }

    public RoyalTree() {
        String SUCCESSORS = "XABCDEFGHIJ";
        for (int i = 0; i < SUCCESSORS.length() - 1; ++i) {
            this.successors[SUCCESSORS.charAt((int)i)] = SUCCESSORS.charAt(i + 1);
        }
    }

    boolean isSuccessor(char p, char q, EvolutionState state) {
        return this.successors[p] == q;
    }

    boolean isPerfect(char parent, GPNode node, EvolutionState state) {
        char node_fn = ((RoyalTreeNode)node).value();
        if (!this.isSuccessor(parent, node_fn, state)) {
            return false;
        }
        for (int i = 0; i < node.children.length; ++i) {
            GPNode child = node.children[i];
            if (this.isPerfect(node_fn, child, state)) continue;
            return false;
        }
        return true;
    }
}

