/*
 * Decompiled with CFR 0.152.
 */
package ec.app.sum;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;
import ec.vector.IntegerVectorSpecies;

public class Sum
extends Problem
implements SimpleProblemForm {
    public static final String P_SUM = "sum";

    @Override
    public Parameter defaultBase() {
        return super.defaultBase().push(P_SUM);
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (ind.evaluated) {
            return;
        }
        if (!(ind instanceof IntegerVectorIndividual)) {
            state.output.fatal("Whoa!  It's not an IntegerVectorIndividual!!!", null);
        }
        IntegerVectorIndividual ind2 = (IntegerVectorIndividual)ind;
        IntegerVectorSpecies s = (IntegerVectorSpecies)ind2.species;
        long sum = 0L;
        long max = 0L;
        for (int x = 0; x < ind2.genome.length; ++x) {
            sum += (long)ind2.genome[x];
            max += (long)((int)s.maxGene(x));
        }
        ((SimpleFitness)ind2.fitness).setFitness(state, sum, sum >= max);
        ind2.evaluated = true;
    }
}

