/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tsp;

import ec.EvolutionState;
import ec.app.tsp.TSPProblem;
import ec.co.Component;
import ec.util.Misc;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TSPGraph {
    private EdgeWeightType edgeWeightType;
    private int dimension;
    private Map<Integer, double[]> nodes;

    public EdgeWeightType weightType() {
        return this.edgeWeightType;
    }

    public TSPGraph(File file) throws IOException {
        assert (file != null);
        BufferedReader r = new BufferedReader(new FileReader(file));
        this.loadHeader(r);
        this.nodes = this.loadNodes(r);
        assert (this.repOK());
    }

    private void loadHeader(BufferedReader tspReader) throws IOException {
        String line;
        assert (tspReader != null);
        while ((line = tspReader.readLine()) != null && !line.trim().toUpperCase().equals(TSPKeyword.NODE_COORD_SECTION.toString())) {
            this.readLine(line);
        }
        if (this.dimension == 0) {
            throw new IllegalStateException("No valid 'DIMENSION' attribute found in TSP file.  Are you sure this file is in TSPLIB format?");
        }
    }

    private void readLine(String line) {
        TSPKeyword keyword;
        assert (line != null);
        String[] keyValue = line.split(":");
        if (keyValue.length != 2) {
            throw new IllegalStateException(String.format("%s: invalid TSPLIB specification '%s'.  Expected a key-value pair.", this.getClass().getSimpleName(), line));
        }
        String value = keyValue[1].trim();
        try {
            keyword = TSPKeyword.valueOf(keyValue[0].trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        assert (!keyword.equals((Object)TSPKeyword.NODE_COORD_SECTION));
        switch (keyword) {
            case DIMENSION: {
                try {
                    this.dimension = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException(String.format("%s: invalid value '%s' found for %s attribute.  Integer expected.", new Object[]{this.getClass().getSimpleName(), value, TSPKeyword.DIMENSION}));
                }
                if (this.dimension > 0) break;
                throw new IllegalStateException(String.format("%s: invalid value '%d' found for %s attribute.  Must be positive", new Object[]{this.getClass().getSimpleName(), this.dimension, TSPKeyword.DIMENSION}));
            }
            case EDGE_WEIGHT_TYPE: {
                try {
                    this.edgeWeightType = EdgeWeightType.valueOf(value.toUpperCase());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(String.format("%s: invalid value '%s' found for %s attribute.  Recognized values are %s.", new Object[]{this.getClass().getSimpleName(), value, TSPKeyword.EDGE_WEIGHT_TYPE, Arrays.asList(EdgeWeightType.values())}));
                }
            }
            case TYPE: {
                if (value.trim().toUpperCase().equals("TSP")) break;
                throw new IllegalStateException(String.format("%s: invalid problem type '%s' found for %s attribute.  Only 'TSP' is supported.", new Object[]{this.getClass().getSimpleName(), value, TSPKeyword.TYPE}));
            }
            default: {
                throw new UnsupportedOperationException(String.format("%s: no logic has been implemented to handle the '%s' attribute.", new Object[]{this.getClass().getSimpleName(), keyword}));
            }
        }
    }

    private Map<Integer, double[]> loadNodes(BufferedReader r) throws IOException {
        String line;
        assert (r != null);
        HashMap<Integer, double[]> nodes = new HashMap<Integer, double[]>();
        while ((line = r.readLine()) != null && !line.trim().equals("EOF")) {
            String[] cols = line.split(" ");
            if (cols.length != 3) {
                throw new IllegalStateException(String.format("%s: Node '%s' has %d columns, expected 3.", TSPProblem.class.getSimpleName(), line, cols.length));
            }
            int id = Integer.valueOf(cols[0].trim()) - 1;
            double x = Double.valueOf(cols[1].trim());
            double y = Double.valueOf(cols[2].trim());
            nodes.put(id, new double[]{x, y});
        }
        if (nodes.size() != this.dimension) {
            throw new IllegalStateException(String.format("%s: TSP problem 'DIMENSION' is specified to be %d, but %d nodes were found.", TSPProblem.class.getSimpleName(), this.dimension, nodes.size()));
        }
        return nodes;
    }

    public int numNodes() {
        return this.nodes.size();
    }

    public Set<Integer> getNodes() {
        return this.nodes.keySet();
    }

    public int numEdges() {
        return (int)Math.pow(this.nodes.size(), 2.0);
    }

    public List<TSPComponent> getAllEdges() {
        ArrayList<TSPComponent> result = new ArrayList<TSPComponent>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            for (int j = 0; j < this.nodes.size(); ++j) {
                result.add(new TSPComponent(i, j));
            }
        }
        assert (this.repOK());
        assert (result.size() == this.numEdges());
        return result;
    }

    public TSPComponent getEdge(int from, int to) {
        return new TSPComponent(from, to);
    }

    private static double latitude(double[] p) {
        assert (p != null);
        assert (p.length == 2);
        double deg = Math.rint(p[0]);
        double min = p[0] - deg;
        return Math.PI * (deg + 5.0 * min / 3.0) / 180.0;
    }

    private static double longitude(double[] p) {
        assert (p != null);
        assert (p.length == 2);
        double deg = Math.rint(p[1]);
        double min = p[1] - deg;
        return Math.PI * (deg + 5.0 * min / 3.0) / 180.0;
    }

    public final boolean repOK() {
        return this.nodes != null && this.nodes.size() == this.dimension && !TSPGraph.containsNullKey(this.nodes) && !TSPGraph.containsNullValue(this.nodes) && !TSPGraph.pointsInvalid(this.nodes.values());
    }

    private static <T> boolean containsNullKey(Map<T, ?> map) {
        assert (map != null);
        for (T o : map.keySet()) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean containsNullValue(Map<?, T> map) {
        assert (map != null);
        for (T o : map.values()) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    private static boolean pointsInvalid(Collection<double[]> points) {
        assert (points != null);
        for (double[] a : points) {
            if (a.length == 2 && !Double.isNaN(a[0]) && !Double.isInfinite(a[0]) && !Double.isNaN(a[1]) && !Double.isInfinite(a[1])) continue;
            return true;
        }
        return false;
    }

    private static enum EdgeWeightType {
        EUC_2D,
        GEO,
        ATT;

    }

    private static enum TSPKeyword {
        TYPE,
        DIMENSION,
        EDGE_WEIGHT_TYPE,
        NODE_COORD_SECTION;

    }

    public class TSPComponent
    extends Component {
        private int fromNode;
        private int toNode;
        private double[] from;
        private double[] to;

        public int from() {
            assert (this.repOK());
            return this.fromNode;
        }

        public int to() {
            assert (this.repOK());
            return this.toNode;
        }

        public TSPComponent(int from, int to) {
            assert (from >= 0);
            assert (from < TSPGraph.this.numNodes());
            assert (to >= 0);
            assert (to < TSPGraph.this.numNodes());
            this.fromNode = from;
            this.toNode = to;
            this.from = TSPGraph.this.nodes.get(this.fromNode);
            this.to = TSPGraph.this.nodes.get(this.toNode);
            assert (this.repOK());
        }

        @Override
        public double desirability() {
            double eta = 1.0 / this.distance();
            assert (!Double.isInfinite(eta));
            assert (!Double.isNaN(eta));
            return eta;
        }

        public double distance() {
            switch (TSPGraph.this.weightType()) {
                default: {
                    return this.euclideanDistance();
                }
                case ATT: {
                    return this.attDistance();
                }
                case GEO: 
            }
            return this.geoDistance();
        }

        private double euclideanDistance() {
            double dist = Math.sqrt(Math.pow(this.from[0] - this.to[0], 2.0) + Math.pow(this.from[1] - this.to[1], 2.0));
            if (dist == 0.0) {
                return 0.0;
            }
            return Math.max(1.0, Math.rint(dist));
        }

        private double attDistance() {
            double xd = this.from[0] - this.to[0];
            double yd = this.from[1] - this.to[1];
            double rft = Math.sqrt((xd * xd + yd * yd) / 10.0);
            double tft = Math.rint(rft);
            if (tft < rft) {
                return tft + 1.0;
            }
            return tft;
        }

        private double geoDistance() {
            double rrr = 6378.388;
            double q1 = Math.cos(TSPGraph.longitude(this.from) - TSPGraph.longitude(this.to));
            double q2 = Math.cos(TSPGraph.latitude(this.from) - TSPGraph.latitude(this.to));
            double q3 = Math.cos(TSPGraph.latitude(this.from) + TSPGraph.latitude(this.to));
            return (int)(6378.388 * Math.acos(0.5 * ((1.0 + q1) * q2 - (1.0 - q1) * q3)) + 1.0);
        }

        @Override
        public void writeComponent(EvolutionState state, DataOutput output) throws IOException {
            assert (output != null);
            output.writeInt(this.fromNode);
            output.writeInt(this.toNode);
            assert (this.repOK());
        }

        @Override
        public TSPComponent readComponent(EvolutionState state, DataInput input) throws IOException {
            assert (input != null);
            int fromNode = input.readInt();
            int toNode = input.readInt();
            assert (this.repOK());
            return new TSPComponent(fromNode, toNode);
        }

        public final boolean repOK() {
            return this.fromNode >= 0 && this.fromNode < TSPGraph.this.nodes.size() && this.toNode >= 0 && this.toNode < TSPGraph.this.nodes.size() && this.from != null && this.to != null && this.from.length == 2 && this.to.length == 2;
        }

        public String toString() {
            return String.format("%s[from=%d, to=%d]", this.getClass().getSimpleName(), this.fromNode, this.toNode);
        }

        public boolean equals(Object o) {
            if (!(o instanceof TSPComponent)) {
                return false;
            }
            TSPComponent ref = (TSPComponent)o;
            return this.from == ref.from && this.to == ref.to && Misc.doubleEquals(this.toNode, ref.toNode, 1.0E-6) && Misc.doubleEquals(this.fromNode, ref.fromNode, 1.0E-6);
        }

        public int hashCode() {
            int hash = 5;
            hash = 11 * hash + this.fromNode;
            hash = 11 * hash + this.toNode;
            hash = 11 * hash + Arrays.hashCode(this.from);
            hash = 11 * hash + Arrays.hashCode(this.to);
            return hash;
        }
    }
}

