/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tsp;

import ec.EvolutionState;
import ec.app.tsp.TSPGraph;
import ec.co.ConstructiveIndividual;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TSPIndividual
extends ConstructiveIndividual<TSPGraph.TSPComponent> {
    private static final long serialVersionUID = 1L;
    private Set<Integer> visitedNodes = new HashSet<Integer>();
    private int lastNodeVisited = -1;

    public boolean visited(int node) {
        assert (node >= 0);
        assert (this.repOK());
        return this.visitedNodes.contains(node);
    }

    public int getLastNodeVisited() {
        assert (this.repOK());
        return this.lastNodeVisited;
    }

    @Override
    public void add(EvolutionState state, TSPGraph.TSPComponent component) {
        TSPGraph.TSPComponent e;
        super.add(state, component);
        assert (component != null);
        if (!(component instanceof TSPGraph.TSPComponent)) {
            state.output.fatal(String.format("%s: attempted to add a component of type %s, but must be %s.", this.getClass().getSimpleName(), component.getClass().getSimpleName(), TSPGraph.TSPComponent.class.getSimpleName()));
        }
        if (this.visitedNodes.contains((e = component).from()) && this.visitedNodes.contains(e.to())) {
            state.output.fatal(String.format("%s: attempted to add an edge connected two nodes that have already been visited, but this is disallowed.", this.getClass().getSimpleName()));
        }
        if (!(this.visitedNodes.isEmpty() || this.visitedNodes.contains(e.from()) || this.visitedNodes.contains(e.to()))) {
            state.output.fatal(String.format("%s: attempted to add an edge that is disconnected from the existing tour, but this is disallowed.", this.getClass().getSimpleName()));
        }
        assert (this.visitedNodes.isEmpty() || this.visitedNodes.contains(e.from()));
        this.lastNodeVisited = e.to();
        this.visitedNodes.add(e.from());
        this.visitedNodes.add(e.to());
        assert (this.repOK());
    }

    @Override
    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        this.visitedNodes = new HashSet<Integer>();
        super.readGenotype(state, dataInput);
    }

    @Override
    public Object clone() {
        TSPIndividual myobj = (TSPIndividual)super.clone();
        myobj.visitedNodes = new HashSet<Integer>(this.visitedNodes);
        assert (this.repOK());
        return myobj;
    }

    @Override
    public boolean repOK() {
        return super.repOK() && this.visitedNodes != null;
    }
}

