/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tsp;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.app.tsp.TSPGraph;
import ec.app.tsp.TSPIndividual;
import ec.co.Component;
import ec.co.ConstructiveIndividual;
import ec.co.ConstructiveProblemForm;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TSPProblem
extends Problem
implements SimpleProblemForm,
ConstructiveProblemForm<TSPGraph.TSPComponent> {
    private static final long serialVersionUID = 1L;
    public static final String P_FILE = "file";
    public static final String P_ALLOW_CYCLES = "allow-cycles";
    private boolean allowCycles;
    private TSPGraph graph;

    public TSPGraph.TSPComponent getComponent(int from, int to) {
        return this.graph.getEdge(from, to);
    }

    @Override
    public TSPGraph.TSPComponent getComponentFromString(String s) {
        int to;
        int from;
        assert (s != null);
        assert (!s.isEmpty());
        String error = String.format("%s: failed to decode string representation of %s.  It must have the form '%s[from=M, to=N]' where M, N are integers, but was '%s'.", this.getClass().getSimpleName(), TSPGraph.TSPComponent.class.getSimpleName(), TSPGraph.TSPComponent.class.getSimpleName(), s);
        String[] splits = s.split("\\[");
        if (splits.length != 2) {
            throw new IllegalArgumentException(error);
        }
        String name = splits[0].trim();
        if (!name.equals(TSPGraph.TSPComponent.class.getSimpleName())) {
            throw new IllegalArgumentException(error);
        }
        if ((splits = splits[1].split(",")).length != 2) {
            throw new IllegalArgumentException(error);
        }
        String fromStr = splits[0];
        String toStr = splits[1].substring(0, splits[1].length() - 1);
        splits = fromStr.split("=");
        if (!splits[0].trim().equals("from")) {
            throw new IllegalArgumentException(error);
        }
        try {
            from = Integer.parseInt(splits[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(error);
        }
        splits = toStr.split("=");
        if (!splits[0].trim().equals("to")) {
            throw new IllegalArgumentException(error);
        }
        try {
            to = Integer.parseInt(splits[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(error);
        }
        assert (this.repOK());
        return this.graph.getEdge(from, to);
    }

    public int numNodes() {
        return this.graph.numNodes();
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        File file = state.parameters.getFile(base.push(P_FILE), null);
        this.allowCycles = state.parameters.getBoolean(base.push(P_ALLOW_CYCLES), null, false);
        if (file == null) {
            state.output.fatal(String.format("%s: Unable to read file path '%s'.", this.getClass().getSimpleName(), base.push(P_FILE)), base.push(P_FILE));
        }
        try {
            assert (file != null);
            this.graph = new TSPGraph(file);
        }
        catch (Exception e) {
            state.output.fatal(String.format("%s: Unable to load TSP instance from file '%s': %s", this.getClass().getSimpleName(), state.parameters.getString(base.push(P_FILE), null), e), base.push(P_FILE));
        }
        assert (this.repOK());
    }

    @Override
    public boolean isViolated(ConstructiveIndividual<TSPGraph.TSPComponent> partialSolution, Component component) {
        assert (partialSolution != null);
        if (!(component instanceof TSPGraph.TSPComponent)) {
            throw new IllegalArgumentException(String.format("%s: attempted to verify a component of type %s, but must be %s.", this.getClass().getSimpleName(), component.getClass().getSimpleName(), TSPGraph.TSPComponent.class.getSimpleName()));
        }
        TSPGraph.TSPComponent edge = (TSPGraph.TSPComponent)component;
        boolean connected = false;
        for (TSPGraph.TSPComponent c : partialSolution) {
            assert (c instanceof TSPGraph.TSPComponent);
            TSPGraph.TSPComponent solEdge = c;
            if (edge.from() == solEdge.from() || edge.from() == solEdge.to()) {
                connected = false;
            }
            if (edge.from() != solEdge.from() && edge.to() != solEdge.to()) continue;
            return true;
        }
        return connected;
    }

    @Override
    public TSPGraph.TSPComponent getArbitraryComponent(EvolutionState state, int thread) {
        int from;
        assert (state != null);
        assert (state.random != null);
        assert (thread >= 0);
        assert (this.graph.numNodes() > 1);
        int to = from = state.random[thread].nextInt(this.graph.numNodes());
        while (to == from) {
            to = state.random[thread].nextInt(this.graph.numNodes());
        }
        TSPGraph.TSPComponent result = this.graph.getEdge(from, to);
        assert (this.repOK());
        return result;
    }

    @Override
    public List<TSPGraph.TSPComponent> getAllComponents() {
        return new ArrayList<TSPGraph.TSPComponent>(this.graph.getAllEdges());
    }

    @Override
    public List<TSPGraph.TSPComponent> getAllowedComponents(ConstructiveIndividual<TSPGraph.TSPComponent> partialSolution) {
        assert (partialSolution != null);
        if (!(partialSolution instanceof TSPIndividual)) {
            throw new IllegalStateException(String.format("%s: received an individual of type %s, but must be %s.", this.getClass().getSimpleName(), partialSolution.getClass().getSimpleName(), TSPIndividual.class.getSimpleName()));
        }
        TSPIndividual tspSol = (TSPIndividual)partialSolution;
        ArrayList<TSPGraph.TSPComponent> allowedComponents = new ArrayList<TSPGraph.TSPComponent>();
        if (partialSolution.isEmpty()) {
            for (TSPGraph.TSPComponent edge : this.graph.getAllEdges()) {
                if (edge.to() == edge.from()) continue;
                allowedComponents.add(edge);
            }
        } else {
            int mostRecentNode = tspSol.getLastNodeVisited();
            assert (mostRecentNode == ((TSPGraph.TSPComponent)tspSol.get((int)partialSolution.size() - 1)).to());
            for (int to = 0; to < this.graph.numNodes(); ++to) {
                if (mostRecentNode == to || !this.allowCycles && tspSol.visited(to)) continue;
                allowedComponents.add(this.graph.getEdge(mostRecentNode, to));
            }
        }
        assert (this.repOK());
        assert (allowedComponents.size() <= this.numComponents());
        return allowedComponents;
    }

    @Override
    public boolean isCompleteSolution(ConstructiveIndividual<TSPGraph.TSPComponent> solution) {
        Set<Integer> visited = this.nodesVisited(solution);
        return visited.size() == this.graph.numNodes() && visited.containsAll(this.graph.getNodes()) && this.graph.getNodes().containsAll(visited);
    }

    private Set<Integer> nodesVisited(ConstructiveIndividual<TSPGraph.TSPComponent> partialSolution) {
        assert (partialSolution != null);
        HashSet<Integer> nodesVisited = new HashSet<Integer>();
        Iterator<TSPGraph.TSPComponent> iterator = partialSolution.iterator();
        while (iterator.hasNext()) {
            TSPGraph.TSPComponent c;
            TSPGraph.TSPComponent edge = c = iterator.next();
            if (!this.allowCycles && nodesVisited.contains(edge.to())) {
                throw new IllegalStateException(String.format("%s: '%s' is set to false, but an individual containing cycles was encountered.  Is your construction heuristic configured to avoid cycles?", this.getClass().getSimpleName(), P_ALLOW_CYCLES));
            }
            nodesVisited.add(edge.to());
            nodesVisited.add(edge.from());
        }
        return nodesVisited;
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        assert (state != null);
        assert (ind != null);
        assert (ind instanceof ConstructiveIndividual);
        assert (subpopulation >= 0);
        assert (subpopulation < state.population.subpops.size());
        assert (threadnum >= 0);
        if (!ind.evaluated) {
            double fitness = 1.0 / this.totalDistance(state, ind);
            ((SimpleFitness)ind.fitness).setFitness(state, fitness, false);
            ind.evaluated = true;
        }
    }

    private double totalDistance(EvolutionState state, Individual ind) {
        TSPIndividual tind = (TSPIndividual)ind;
        assert (ind != null);
        if (!this.isCompleteSolution(tind)) {
            state.output.fatal(String.format("%s: attempted to evaluate an incomplete solution.", this.getClass().getSimpleName()));
        }
        assert (tind.size() == (long)(this.graph.numNodes() - 1));
        List components = tind.getComponents();
        double distance = 0.0;
        for (TSPGraph.TSPComponent c : tind.getComponents()) {
            distance += c.distance();
        }
        assert (((TSPGraph.TSPComponent)components.get(components.size() - 1)).to() != ((TSPGraph.TSPComponent)components.get(0)).from());
        assert ((distance += this.graph.getEdge(((TSPGraph.TSPComponent)components.get(components.size() - 1)).to(), ((TSPGraph.TSPComponent)components.get(0)).from()).distance()) >= 0.0);
        assert (!Double.isNaN(distance));
        assert (!Double.isInfinite(distance));
        return distance;
    }

    @Override
    public int numComponents() {
        return this.graph.numEdges();
    }

    public final boolean repOK() {
        return P_FILE != null && !P_FILE.isEmpty() && P_ALLOW_CYCLES != null && !P_ALLOW_CYCLES.isEmpty() && this.graph != null;
    }
}

