/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tutorial3;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

public class OddRosenbrock
extends Problem
implements SimpleProblemForm {
    @Override
    public void setup(EvolutionState state, Parameter base) {
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!(ind instanceof DoubleVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be DoubleVectorIndividuals.");
        }
        double[] genome = ((DoubleVectorIndividual)ind).genome;
        int len = genome.length;
        double value = 0.0;
        for (int i = 1; i < len; ++i) {
            value += 100.0 * (genome[i - 1] * genome[i - 1] - genome[i]) * (genome[i - 1] * genome[i - 1] - genome[i]) + (1.0 - genome[i - 1]) * (1.0 - genome[i - 1]);
        }
        value = 1.0 / (1.0 + value);
        ((SimpleFitness)ind.fitness).setFitness(state, value, value == 1.0);
        ind.evaluated = true;
    }
}

