/*
 * Decompiled with CFR 0.152.
 */
package ec.app.xor;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.neat.NEATIndividual;
import ec.neat.NEATNetwork;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;

public class XOR
extends Problem
implements SimpleProblemForm {
    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (ind.evaluated) {
            return;
        }
        if (!(ind instanceof NEATIndividual)) {
            state.output.fatal("Whoa! It's not a NEATIndividual!!!", null);
        }
        NEATIndividual neatInd = (NEATIndividual)ind;
        if (!(neatInd.fitness instanceof SimpleFitness)) {
            state.output.fatal("Whoa! It's not a SimpleFitness!!!", null);
        }
        double[][] in = new double[][]{{1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}, {1.0, 1.0, 1.0}};
        double[] out = new double[4];
        double[] expectedOut = new double[]{0.0, 1.0, 1.0, 0.0};
        NEATNetwork net = neatInd.createNetwork();
        int netDepth = net.maxDepth();
        for (int i = 0; i < in.length; ++i) {
            net.loadSensors(in[i]);
            for (int relax = 0; relax < netDepth; ++relax) {
                net.activate(state);
            }
            out[i] = net.getOutputResults()[0];
            net.flush();
        }
        double errorSum = 0.0;
        for (int i = 0; i < out.length; ++i) {
            errorSum += Math.abs(out[i] - expectedOut[i]);
        }
        double fitness = (4.0 - errorSum) * (4.0 - errorSum);
        boolean ideal = true;
        for (int i = 0; i < out.length; ++i) {
            if (!(Math.abs(out[i] - expectedOut[i]) > 0.5)) continue;
            ideal = false;
            break;
        }
        ((SimpleFitness)neatInd.fitness).setFitness(state, fitness, ideal);
        neatInd.evaluated = true;
    }
}

