/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

public class BufferedBreedingPipeline
extends BreedingPipeline {
    public static final String P_BUFSIZE = "num-inds";
    public static final String P_BUFFERED = "buffered";
    public static final int INDS_PRODUCED = 1;
    public static final int NUM_SOURCES = 1;
    public ArrayList<Individual> buffer;
    public int bufSize;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_BUFFERED);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public int typicalIndsProduced() {
        return 1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.bufSize = state.parameters.getInt(base.push(P_BUFSIZE), def.push(P_BUFSIZE), 1);
        if (this.bufSize == 0) {
            state.output.fatal("BufferedBreedingPipeline's number of individuals must be >= 1.", base.push(P_BUFSIZE), def.push(P_BUFSIZE));
        }
        if (this.likelihood < 1.0) {
            state.output.warning("BufferedBreedingPipeline does not respond to the 'likelihood' parameter.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    @Override
    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        super.prepareToProduce(state, subpopulation, thread);
        this.buffer = new ArrayList();
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        for (int q = 0; q < min; ++q) {
            if (this.buffer.isEmpty()) {
                this.sources[0].produce(this.bufSize, this.bufSize, subpopulation, this.buffer, state, thread, misc);
            }
            inds.add(this.buffer.remove(this.buffer.size() - 1));
        }
        return min;
    }
}

