/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

public class FirstCopyPipeline
extends BreedingPipeline {
    public static final String P_FIRST_COPY = "first-copy";
    public static final int NUM_SOURCES = 2;
    public boolean firstTime = true;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_FIRST_COPY);
    }

    @Override
    public int numSources() {
        return 2;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (this.likelihood != 1.0) {
            state.output.warning("FirstCopyPipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    @Override
    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        super.prepareToProduce(state, subpopulation, thread);
        this.firstTime = true;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        if (this.firstTime) {
            int n = this.sources[0].produce(1, 1, subpopulation, inds, state, thread, misc);
            if (min > 1) {
                n += this.sources[1].produce(min - 1, max - 1, subpopulation, inds, state, thread, misc);
            }
            this.firstTime = false;
            return n;
        }
        int n = this.sources[1].produce(min, max, subpopulation, inds, state, thread, misc);
        return n;
    }
}

