/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.IntBag;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

public class RepeatPipeline
extends BreedingPipeline {
    public static final String P_REPEAT = "repeat";
    public static final int NUM_SOURCES = 1;
    public Individual individual = null;
    public IntBag parents;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_REPEAT);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (this.likelihood != 1.0) {
            state.output.warning("RepeatPipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    @Override
    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        super.prepareToProduce(state, subpopulation, thread);
        this.individual = null;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        if (this.individual == null) {
            HashMap<String, Object> misc1 = null;
            if (misc != null && misc.get("parents") != null) {
                IntBag[] parentsArray = new IntBag[1];
                misc1 = new HashMap<String, Object>();
                misc1.put("parents", parentsArray);
            }
            ArrayList<Individual> temp = new ArrayList<Individual>();
            this.sources[0].produce(1, 1, subpopulation, temp, state, thread, misc1);
            this.individual = temp.get(0);
            this.parents = misc1 != null && misc1.get("parents") != null ? ((IntBag[])misc.get("parents"))[0] : null;
        }
        int start = inds.size();
        for (int i = 0; i < min; ++i) {
            inds.add((Individual)this.individual.clone());
        }
        if (this.parents != null && misc != null && misc.get("parents") != null) {
            IntBag[] parentsArray = (IntBag[])misc.get("parents");
            for (int i = 0; i < min; ++i) {
                parentsArray[start + i] = new IntBag(this.parents);
            }
        }
        return min;
    }
}

