/*
 * Decompiled with CFR 0.152.
 */
package ec.co;

import ec.EvolutionState;
import ec.Individual;
import ec.co.Component;
import ec.co.ConstructiveProblemForm;
import ec.util.Misc;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConstructiveIndividual<T extends Component>
extends Individual
implements Iterable<T> {
    private static final long serialVersionUID = 1L;
    public static final String P_DEFAULTBASE = "constr-ind";
    private List<T> components = new ArrayList<T>();
    private Set<T> componentsSet = new HashSet<T>();

    public T get(int i) {
        return (T)((Component)this.components.get(i));
    }

    @Override
    public Parameter defaultBase() {
        return new Parameter(P_DEFAULTBASE);
    }

    @Override
    public Object clone() {
        ConstructiveIndividual myobj = (ConstructiveIndividual)super.clone();
        myobj.components = new ArrayList<T>(this.components);
        myobj.componentsSet = new HashSet<T>(this.componentsSet);
        assert (this.repOK());
        return myobj;
    }

    public List<T> getComponents() {
        assert (this.repOK());
        return new ArrayList<T>(this.components);
    }

    public void setComponents(EvolutionState state, Collection<T> newComponents) {
        assert (newComponents != null);
        this.components = new ArrayList<T>(newComponents.size());
        this.componentsSet = new HashSet<T>();
        for (Component c : newComponents) {
            this.add(state, c);
        }
        assert (this.repOK());
    }

    public void add(EvolutionState state, T component) {
        assert (component != null);
        this.components.add(component);
        this.componentsSet.add(component);
        assert (this.repOK());
    }

    public boolean contains(T component) {
        return this.componentsSet.contains(component);
    }

    @Override
    public Iterator<T> iterator() {
        return this.components.iterator();
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public long size() {
        assert (this.repOK());
        return this.components.size();
    }

    @Override
    public boolean equals(Object ind) {
        if (ind == this) {
            return true;
        }
        if (!(ind instanceof ConstructiveIndividual)) {
            return false;
        }
        ConstructiveIndividual ref = (ConstructiveIndividual)ind;
        return this.components.equals(ref.components);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this.components != null ? this.components.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return this.components.toString();
    }

    @Override
    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.components.size());
        for (Component c : this.components) {
            c.writeComponent(state, dataOutput);
        }
        assert (this.repOK());
    }

    @Override
    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        this.components = new ArrayList<T>();
        this.componentsSet = new HashSet<T>();
        int numComponents = dataInput.readInt();
        ConstructiveProblemForm problem = (ConstructiveProblemForm)((Object)state.evaluator.p_problem);
        Object p_component = problem.getArbitraryComponent(state, 0);
        for (int i = 0; i < numComponents; ++i) {
            this.add(state, ((Component)p_component).readComponent(state, dataInput));
        }
        assert (this.repOK());
    }

    public boolean repOK() {
        return P_DEFAULTBASE != null && !P_DEFAULTBASE.isEmpty() && this.components != null && !Misc.containsNulls(this.components) && this.componentsSet.size() == new HashSet<T>(this.components).size() && this.componentsSet.equals(new HashSet<T>(this.components));
    }
}

